/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BinaryDataProxy;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.IndexedResource;
import org.eclipse.osee.orcs.db.internal.search.tagger.Tagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.TaggingEngine;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AttributeDataMatcher {
    private final Log logger;
    private final TaggingEngine engine;

    public AttributeDataMatcher(Log logger, TaggingEngine engine) {
        this.logger = logger;
        this.engine = engine;
    }

    public List<MatchLocation> process(HasCancellation cancellation, AttributeData<?> data, Collection<String> valuesToMatch, Collection<AttributeTypeToken> typesFilter, QueryOption ... options) throws Exception {
        this.logger.debug("Attribute Data match for attr[%s] - [%s]", new Object[]{data.getId(), valuesToMatch});
        if (Conditions.hasValues((Object[])options)) {
            return this.matchTokenizedValue(cancellation, data, valuesToMatch, typesFilter, options);
        }
        return this.matchValuesExactly(cancellation, data, valuesToMatch);
    }

    private void checkCancelled(HasCancellation cancellation) {
        if (cancellation != null) {
            cancellation.checkForCancelled();
        }
    }

    private List<MatchLocation> matchValuesExactly(HasCancellation cancellation, AttributeData<?> data, Iterable<String> valuesToMatch) throws Exception {
        String value = this.getValue(data);
        LinkedList matched = Lists.newLinkedList();
        for (String toMatch : valuesToMatch) {
            this.checkCancelled(cancellation);
            if (!value.equals(toMatch) && (Strings.isValid((String)value) || Strings.isValid((String)toMatch))) continue;
            MatchLocation matchLocation = new MatchLocation(1, value.length());
            matched.add(matchLocation);
        }
        return matched;
    }

    private List<MatchLocation> matchTokenizedValue(HasCancellation cancellation, AttributeData<?> data, Iterable<String> valuesToMatch, Collection<AttributeTypeToken> typesFilter, QueryOption ... options) {
        AttributeIndexedResource source = this.adapt(data);
        AttributeTypeToken attrType = source.getAttributeType();
        if (typesFilter.contains(QueryBuilder.ANY_ATTRIBUTE_TYPE) || typesFilter.contains(attrType)) {
            this.checkCancelled(cancellation);
            TaggerTypeToken taggerType = attrType.getTaggerType();
            if (taggerType.isValid()) {
                Tagger tagger = this.engine.getTagger(taggerType);
                this.checkCancelled(cancellation);
                try {
                    LinkedList matched = Lists.newLinkedList();
                    for (String toMatch : valuesToMatch) {
                        matched.addAll(tagger.find(source.getResourceInput(), toMatch, true, options));
                    }
                    return matched;
                }
                catch (Exception ex) {
                    this.logger.error((Throwable)ex, "Error searching attrId [%d] gamma [%d]", new Object[]{data.getId(), data.getVersion().getGammaId()});
                }
            }
        }
        return null;
    }

    private AttributeIndexedResource adapt(AttributeData<?> data) {
        return new AttributeIndexedResource(data);
    }

    private String getValue(AttributeData<?> data) {
        String value = "";
        DataProxy dataProxy = data.getDataProxy();
        value = dataProxy instanceof CharacterDataProxy ? ((CharacterDataProxy)dataProxy).getValueAsString() : dataProxy.toString();
        return value;
    }

    private final class AttributeIndexedResource
    extends ByteSource
    implements IndexedResource {
        private final AttributeData<?> attrData;

        public AttributeIndexedResource(AttributeData<?> attrData) {
            this.attrData = attrData;
        }

        public AttributeTypeToken getAttributeType() {
            return (AttributeTypeToken)this.attrData.getType();
        }

        public GammaId getGammaId() {
            return this.attrData.getVersion().getGammaId();
        }

        public InputStream getResourceInput() throws IOException {
            return this.openStream();
        }

        public InputStream openStream() throws IOException {
            ByteArrayInputStream stream = null;
            DataProxy dataProxy = this.attrData.getDataProxy();
            if (dataProxy instanceof BinaryDataProxy) {
                ByteBuffer valueAsBytes;
                try {
                    valueAsBytes = ((BinaryDataProxy)dataProxy).getValueAsBytes();
                }
                catch (OseeCoreException ex) {
                    throw new IOException(ex);
                }
                if (valueAsBytes != null) {
                    stream = new ByteArrayInputStream(valueAsBytes.array());
                }
            } else {
                String value = null;
                if (dataProxy instanceof CharacterDataProxy) {
                    try {
                        value = ((CharacterDataProxy)dataProxy).getValueAsString();
                    }
                    catch (OseeCoreException ex) {
                        throw new IOException(ex);
                    }
                } else {
                    value = dataProxy.toString();
                }
                stream = new ByteArrayInputStream(value.getBytes("UTF-8"));
            }
            return stream;
        }
    }
}

