/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseExportImportSaxHandler
extends AbstractSaxHandler {
    protected static final String STRING_CONTENT = "stringContent";
    protected static final String BINARY_CONTENT_LOCATION = "binaryContentLocation";
    private final Map<String, String> dataMap = new HashMap<String, String>();

    protected BaseExportImportSaxHandler() {
    }

    public void startElementFound(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equalsIgnoreCase("data")) {
            this.handleData(attributes);
        } else if (localName.equalsIgnoreCase("entry")) {
            this.handleEntry(attributes);
        } else if (localName.equalsIgnoreCase("binaryContent")) {
            this.handleBinaryContent(attributes);
        }
    }

    public void endElementFound(String uri, String localName, String name) throws Exception {
        if (localName.equalsIgnoreCase(STRING_CONTENT)) {
            this.finishStringContent(STRING_CONTENT);
        } else if (localName.equalsIgnoreCase("osee_comment")) {
            this.finishStringContent("osee_comment");
        } else if (localName.equalsIgnoreCase("branch_name")) {
            this.finishStringContent("branch_name");
        } else if (localName.equalsIgnoreCase("rationale")) {
            this.finishStringContent("rationale");
        } else if (localName.equalsIgnoreCase("entry")) {
            this.finishEntry();
        } else if (localName.equalsIgnoreCase("data")) {
            this.finishData();
        }
    }

    private void handleData(Attributes attributes) {
    }

    protected void finishData() {
    }

    private void handleEntry(Attributes attributes) {
        this.dataMap.clear();
        int attributeCount = attributes.getLength();
        int index = 0;
        while (index < attributeCount) {
            String columnName = attributes.getLocalName(index);
            String value = attributes.getValue(index);
            if (Strings.isValid((String)value) && !value.equals("null")) {
                this.dataMap.put(columnName, value);
            }
            ++index;
        }
    }

    private void handleBinaryContent(Attributes attributes) {
        this.dataMap.put(BINARY_CONTENT_LOCATION, attributes.getValue("location"));
    }

    private void finishEntry() {
        if (!this.dataMap.isEmpty()) {
            this.processData(this.dataMap);
        }
        this.dataMap.clear();
    }

    private void finishStringContent(String name) {
        this.dataMap.put(name, this.getContents());
    }

    protected abstract void processData(Map<String, String> var1);
}

