/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.orcs.core.internal.SetupPublishing;
import org.eclipse.osee.orcs.core.util.PublishingTemplateMatchCriterion;
import org.eclipse.osee.orcs.core.util.PublishingTemplateSetter;

public class PublishingTemplate {
    private String identifier;
    private final List<PublishingTemplateMatchCriterion> matchCriteria;
    private final String name;
    private final ArtifactToken parentArtifactToken;
    private final Path rendererOptionsFileName;
    private final Path templateContentFileName;

    public static List<PublishingTemplate> load(Supplier<List<PublishingTemplate>> publishingTemplatesSupplier, PublishingTemplateSetter publishingTemplateSetter, Class<?> locationClass, boolean inOseeInf) {
        return publishingTemplatesSupplier.get().stream().map(publishingTemplate -> publishingTemplate.load(locationClass, inOseeInf, publishingTemplateSetter)).collect(Collectors.toList());
    }

    public PublishingTemplate(ArtifactToken parentArtifactToken, String name, String rendererOptionsFileName, String templateContentFileName, List<PublishingTemplateMatchCriterion> matchCriteria) {
        this.parentArtifactToken = Objects.requireNonNull(parentArtifactToken, "SetupPublishing.PublishingTemplate::new, paramter \"parentArtifactToken\" cannot be null.");
        this.name = Objects.requireNonNull(name, "SetupPublishing.PublishingTemplate::new, parameter \"name\" cannnot be null.");
        this.rendererOptionsFileName = Objects.nonNull(rendererOptionsFileName) ? Paths.get(rendererOptionsFileName, new String[0]) : null;
        this.templateContentFileName = Objects.nonNull(templateContentFileName) ? Paths.get(templateContentFileName, new String[0]) : null;
        this.matchCriteria = matchCriteria;
    }

    public PublishingTemplateRequest getPublishingTemplateRequest() {
        PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest(this.identifier);
        return publishingTemplateRequest;
    }

    public PublishingTemplate load(Class<?> locationClass, boolean inOseeInf, PublishingTemplateSetter publishingTemplateSetter) {
        Objects.requireNonNull(locationClass, "PublishingTemplate::load, parameter \"locationClass\" cannot be null.");
        Objects.requireNonNull(locationClass, "PublishingTemplate::load, parameter \"publishingTemplateSetter\" cannot be null.");
        String templateContents = null;
        String rendererContents = null;
        if (Objects.nonNull(this.rendererOptionsFileName)) {
            try {
                rendererContents = inOseeInf ? OseeInf.getResourceContents((String)this.rendererOptionsFileName.toString(), locationClass) : Lib.fileToString(locationClass, (String)Paths.get("support", new String[0]).resolve(this.rendererOptionsFileName).toString());
            }
            catch (Exception e) {
                throw new AssertionError(new Message().title((CharSequence)"PublishingTemplate::createPublishingTemplate, Failed to load renderer file.").indentInc().segment((CharSequence)"Location Class", (Object)locationClass.getCanonicalName()).segment((CharSequence)"In Osee Inf", (Object)inOseeInf).segment((CharSequence)"File Path", (Object)this.rendererOptionsFileName).reasonFollows((Throwable)e).toString(), e);
            }
        }
        if (Objects.nonNull(this.templateContentFileName)) {
            try {
                templateContents = inOseeInf ? OseeInf.getResourceContents((String)this.templateContentFileName.toString(), SetupPublishing.class) : Lib.fileToString(locationClass, (String)Paths.get("support", new String[0]).resolve(this.templateContentFileName).toString());
            }
            catch (Exception e) {
                throw new AssertionError(new Message().title((CharSequence)"PublishingTemplate::createPublishingTemplate, Failed to load template file.").indentInc().segment((CharSequence)"Location Class", (Object)locationClass.getCanonicalName()).segment((CharSequence)"In Osee Inf", (Object)inOseeInf).segment((CharSequence)"File Path", (Object)this.templateContentFileName).reasonFollows((Throwable)e).toString(), e);
            }
            templateContents = templateContents.replace("_TEMPLATE_NAME_", this.name);
            this.identifier = publishingTemplateSetter.set(this.parentArtifactToken, this.name, templateContents, rendererContents, this.matchCriteria.stream().map(PublishingTemplateMatchCriterion::getTemplateMatchCriteria).collect(Collectors.toCollection(ArrayList::new)));
        }
        return this;
    }
}

