/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.OrcsTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.RelationDataSideA;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private final TxCallableFactory txFactory;
    private final TxDataManager txManager;
    private final TxData txData;
    private final QueryFactory queryFactory;
    private final OrcsApi orcsApi;
    private final KeyValueOps keyValueOps;
    private final TupleQuery tupleQuery;
    private boolean committed = false;

    public TransactionBuilderImpl(TxCallableFactory txFactory, TxDataManager dataManager, TxData txData, OrcsApi orcsApi, KeyValueOps keyValueOps) {
        this.txFactory = txFactory;
        this.txManager = dataManager;
        this.txData = txData;
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.keyValueOps = keyValueOps;
        this.tupleQuery = orcsApi.getQueryFactory().tupleQuery();
    }

    private Artifact getForWrite(ArtifactId artifactId) {
        return this.txManager.getForWrite(this.txData, artifactId);
    }

    public BranchId getBranch() {
        return this.txData.getBranch();
    }

    public String getComment() {
        return this.txData.getComment();
    }

    public void setComment(String comment) {
        this.validateBuilder();
        this.txManager.setComment(this.txData, comment);
    }

    public UserId getAuthor() {
        return this.txData.getAuthor();
    }

    public void setAuthor(UserToken author) {
        this.validateBuilder();
        this.txManager.setAuthor(this.txData, author);
    }

    public ArtifactToken createArtifact(ArtifactId parent, ArtifactToken token) {
        this.validateBuilder();
        ArtifactToken child = this.createArtifact(token);
        if (parent.isValid()) {
            this.addChild(parent, (ArtifactId)child);
        }
        return child;
    }

    public ArtifactToken createArtifact(ArtifactId parent, ArtifactTypeToken artifactType, String name) {
        this.validateBuilder();
        ArtifactToken child = this.createArtifact(artifactType, name);
        if (parent.isValid()) {
            this.addChild(parent, (ArtifactId)child);
        }
        return child;
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, artifactType, name, (String)null);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, ApplicabilityId appId) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, artifactType, name, (String)null, appId);
    }

    public ArtifactToken createArtifact(ArtifactToken token) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, token.getArtifactType(), token.getName(), (ArtifactId)token);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, ArtifactId artifactId) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, artifactType, name, artifactId);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, ArtifactId artifactId, ApplicabilityId appId) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, artifactType, name, artifactId, appId);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, String guid) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, artifactType, name, guid);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, String guid, ApplicabilityId appId) {
        this.validateBuilder();
        return this.txManager.createArtifact(this.txData, artifactType, name, guid, appId);
    }

    public List<ArtifactToken> createArtifacts(ArtifactTypeToken artifactType, ArtifactId parent, List<String> names) {
        this.validateBuilder();
        ResultSet results = this.queryFactory.fromBranch(this.getBranch()).andTypeEquals(new ArtifactTypeToken[]{artifactType}).and((AttributeTypeToken)CoreAttributeTypes.Name, names, new QueryOption[0]).getResults();
        if (!results.isEmpty()) {
            throw new OseeCoreException("Found %s artifacts of type %s with duplicate names: %s", new Object[]{results.size(), artifactType, results.getList()});
        }
        ArrayList<ArtifactToken> tokens = new ArrayList<ArtifactToken>(names.size());
        ArtifactTypeToken artifactTypeToken = this.orcsApi.tokenService().getArtifactType(artifactType.getId());
        for (String name : names) {
            tokens.add(this.createArtifact(parent, artifactTypeToken, name));
        }
        return tokens;
    }

    public ArtifactToken copyArtifact(ArtifactReadable sourceArtifact) {
        this.validateBuilder();
        return this.copyArtifact((BranchId)sourceArtifact.getBranch(), (ArtifactId)sourceArtifact);
    }

    public ArtifactToken copyArtifact(BranchId fromBranch, ArtifactId artifactId) {
        this.validateBuilder();
        return this.txManager.copyArtifact(this.txData, fromBranch, artifactId);
    }

    public ArtifactToken copyArtifact(ArtifactReadable sourceArtifact, Collection<AttributeTypeToken> attributesToDuplicate) {
        for (AttributeTypeToken typeToken : attributesToDuplicate) {
            this.checkPermissionsForLoginId(typeToken);
        }
        this.validateBuilder();
        return this.copyArtifact((BranchId)sourceArtifact.getBranch(), (ArtifactId)sourceArtifact, attributesToDuplicate);
    }

    public ArtifactToken copyArtifact(BranchId fromBranch, ArtifactId artifactId, Collection<AttributeTypeToken> attributesToDuplicate) {
        for (AttributeTypeToken typeToken : attributesToDuplicate) {
            this.checkPermissionsForLoginId(typeToken);
        }
        this.validateBuilder();
        return this.txManager.copyArtifact(this.txData, fromBranch, artifactId, attributesToDuplicate);
    }

    public ArtifactToken introduceArtifact(BranchId fromBranch, ArtifactId sourceArtifact) {
        this.validateBuilder();
        this.checkAreOnDifferentBranches(this.txData, fromBranch);
        ArtifactReadable source = this.getArtifactReadable(this.txData.getSession(), this.queryFactory, fromBranch, sourceArtifact);
        Conditions.assertNotSentinel((Id)source, (String)"Source Artifact");
        ArtifactReadable destination = this.getArtifactReadable(this.txData.getSession(), this.queryFactory, this.txData.getBranch(), sourceArtifact);
        return this.txManager.introduceArtifact(this.txData, fromBranch, source, destination);
    }

    public void introduceTuple(TupleTypeId tupleType, GammaId tupleGamma) {
        this.validateBuilder();
        this.txData.add(this.txManager.introduceTuple(tupleType, tupleGamma));
    }

    public ArtifactToken replaceWithVersion(ArtifactReadable sourceArtifact, ArtifactReadable destination) {
        this.validateBuilder();
        return this.txManager.replaceWithVersion(this.txData, (BranchId)sourceArtifact.getBranch(), sourceArtifact, destination);
    }

    public AttributeId createAttribute(ArtifactId sourceArtifact, AttributeTypeToken attributeType) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttribute(attributeType);
    }

    public <T> AttributeId createAttribute(ArtifactId sourceArtifact, AttributeTypeToken attributeType, T value) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttribute(attributeType, value);
    }

    public <T> AttributeId createAttribute(ArtifactId sourceArtifact, AttributeTypeToken attributeType, UserToken user, T value) {
        this.checkPermissionsForLoginId(attributeType, user);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttribute(attributeType, value);
    }

    public <T> AttributeId createAttributeNoAccess(ArtifactId sourceArtifact, AttributeTypeToken attributeType, T value) {
        if (!OseeProperties.isInTest()) {
            throw new OseeArgumentException("createAttributeNoAccess can only be used in tests or bootstrapping", new Object[0]);
        }
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        return asArtifact.createAttribute(attributeType, value);
    }

    public <T> void setSoleAttributeValue(ArtifactId sourceArtifact, AttributeTypeToken attributeType, T value) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setSoleAttributeValue(attributeType, value);
    }

    public void setSoleAttributeFromStream(ArtifactId sourceArtifact, AttributeTypeToken attributeType, InputStream stream) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setSoleAttributeFromStream(attributeType, stream);
    }

    public void setSoleAttributeFromString(ArtifactId sourceArtifact, AttributeTypeToken attributeType, String value) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setSoleAttributeFromString(attributeType, value);
    }

    public void setName(ArtifactId sourceArtifact, String value) {
        this.validateBuilder();
        this.setSoleAttributeFromString(sourceArtifact, (AttributeTypeToken)CoreAttributeTypes.Name, value);
    }

    public <T> void setAttributesFromValues(ArtifactId sourceArtifact, AttributeTypeToken attributeType, Collection<T> values) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromValues(attributeType, values);
    }

    public void checkPermissionsForLoginId(AttributeTypeToken attributeType) {
        UserToken user;
        List roles;
        if (attributeType.equals(CoreAttributeTypes.LoginId) && !(roles = (user = this.orcsApi.userService().getUser()).getRoles()).contains(CoreUserGroups.AccountAdmin)) {
            throw new OseeAccessDeniedException("User %s is not an account admin", new Object[]{user.toStringWithId()});
        }
    }

    public void checkPermissionsForLoginId(AttributeTypeToken attributeType, UserToken user) {
        List roles;
        if (attributeType.equals(CoreAttributeTypes.LoginId) && !(roles = user.getRoles()).contains(CoreUserGroups.AccountAdmin)) {
            throw new OseeAccessDeniedException("User %s is not an account admin", new Object[]{user.toStringWithId()});
        }
    }

    public void setAttributesFromStrings(ArtifactId sourceArtifact, AttributeTypeToken attributeType, String ... values) {
        if (attributeType.getName().contains("Login Id")) {
            this.checkPermissionsForLoginId(attributeType);
        }
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromStrings(attributeType, values);
    }

    public void setAttributesFromStrings(ArtifactId sourceArtifact, AttributeTypeToken attributeType, Collection<String> values) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.setAttributesFromStrings(attributeType, values);
    }

    public <T> void setAttributeById(ArtifactId sourceArtifact, AttributeId attrId, T value) {
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId).setValue(value);
    }

    public void setAttributeById(ArtifactId sourceArtifact, AttributeId attrId, String value) {
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId).setFromString(value);
    }

    public void setAttributeById(ArtifactId sourceArtifact, AttributeId attrId, InputStream stream) {
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId).setValueFromInputStream(stream);
    }

    public void setAttributeApplicability(ArtifactId art, AttributeId attrId, ApplicabilityId applicId) {
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(art);
        Attribute attribute = asArtifact.getAttributeById(attrId);
        ((AttributeData)attribute.getOrcsData()).setApplicabilityId(applicId);
    }

    public void deleteByAttributeId(ArtifactId sourceArtifact, AttributeId attrId) {
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.getAttributeById(attrId).delete();
    }

    public void deleteSoleAttribute(ArtifactId sourceArtifact, AttributeTypeToken attributeType) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.deleteSoleAttribute(attributeType);
    }

    public void deleteAttributes(ArtifactId sourceArtifact, AttributeTypeToken attributeType) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.deleteAttributes(attributeType);
    }

    public void deleteAttributesWithValue(ArtifactId sourceArtifact, AttributeTypeToken attributeType, Object value) {
        this.checkPermissionsForLoginId(attributeType);
        this.validateBuilder();
        Artifact asArtifact = this.getForWrite(sourceArtifact);
        asArtifact.deleteAttributesWithValue(attributeType, value);
    }

    public void addChild(ArtifactId parent, ArtifactId child) {
        this.validateBuilder();
        this.txManager.addChild(this.txData, parent, child);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB) {
        this.validateBuilder();
        if (relType.isNewRelationTable()) {
            this.relate(relType, artA, artB, ArtifactId.SENTINEL, "end", 0, 0);
        } else {
            this.txManager.relate(this.txData, artA, relType, artB);
        }
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, String rationale) {
        this.validateBuilder();
        if (relType.isNewRelationTable()) {
            this.relate(relType, artA, artB, ArtifactId.SENTINEL, "end", 0, 0);
        } else {
            this.txManager.relate(this.txData, artA, relType, artB, rationale);
        }
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, RelationSorter sortType) {
        this.validateBuilder();
        if (relType.isNewRelationTable()) {
            this.relate(relType, artA, artB, ArtifactId.SENTINEL, "end", 0, 0);
        } else {
            this.txManager.relate(this.txData, artA, relType, artB, sortType);
        }
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, String rationale, RelationSorter sortType) {
        this.validateBuilder();
        if (relType == null) {
            throw new OseeCoreException("In TransactionBuilderImpl.related, parameter \"relType\" is null which is dereferenced", new Object[0]);
        }
        if (relType.isNewRelationTable()) {
            this.relate(relType, artA, artB, ArtifactId.SENTINEL, "end", 0, 0);
        } else {
            this.txManager.relate(this.txData, artA, relType, artB, rationale, sortType);
        }
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, ArtifactId relatedArtifact, String insertType, int afterIndex, int beforeIndex) {
        this.relate(relType, artA, artB, relatedArtifact, insertType, afterIndex, beforeIndex);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, ArtifactId relatedArtifact, String afterArtifact) {
        ArtifactId afterArtifactId;
        String insertType;
        Integer beforeIndex;
        Integer afterIndex;
        block5: {
            afterIndex = 0;
            beforeIndex = 0;
            insertType = afterArtifact;
            afterArtifactId = ArtifactId.SENTINEL;
            try {
                Long afterId = Long.parseLong(afterArtifact);
                afterArtifactId = ArtifactId.valueOf((Long)afterId);
                insertType = "insert";
            }
            catch (NumberFormatException numberFormatException) {
                if (afterArtifact != null) break block5;
                insertType = "end";
            }
        }
        if (afterArtifactId.isValid()) {
            RelationTypeSide rts = new RelationTypeSide(relType, RelationSide.SIDE_B);
            ArtifactReadable artifactA = this.orcsApi.getQueryFactory().fromBranch(this.getBranch()).andId(artA).asArtifact();
            List related = artifactA.getRelatedIds(rts);
            if (related.indexOf(afterArtifactId) + 1 > related.size() - 1) {
                insertType = "end";
            } else {
                ArtifactId beforeArtifact = (ArtifactId)related.get(related.indexOf(afterArtifactId) + 1);
                Integer selectAfterIndex = (Integer)this.orcsApi.getJdbcService().getClient().fetch((Object)0, "SELECT rel_order from osee_txs tx, osee_relation rel where tx.branch_id = ? and tx.tx_current = 1 and tx.gamma_id = rel.gamma_id and rel.a_art_id = ? and rel.rel_type = ? and rel.b_art_id = ?", new Object[]{this.getBranch(), artA, relType.getId(), afterArtifactId});
                Integer selectBeforeIndex = (Integer)this.orcsApi.getJdbcService().getClient().fetch((Object)0, "SELECT rel_order from osee_txs tx, osee_relation rel where tx.branch_id = ? and tx.tx_current = 1 and tx.gamma_id = rel.gamma_id and rel.a_art_id = ? and rel.rel_type = ? and rel.b_art_id = ?", new Object[]{this.getBranch(), artA, relType.getId(), beforeArtifact});
                afterIndex = selectAfterIndex != null ? selectAfterIndex : 0;
                beforeIndex = selectBeforeIndex != null ? selectBeforeIndex : 0;
            }
        }
        this.relate(relType, artA, artB, relatedArtifact, insertType, (int)afterIndex, (int)beforeIndex);
    }

    private void relate(RelationTypeToken relType, ArtifactId artA, ArtifactId artB, ArtifactId relationArt, String insertType, int afterIndex, int beforeIndex) {
        int minOrder = 0;
        int maxOrder = 0;
        int relOrder = 0;
        RelationTypeMultiplicity mult = relType.getMultiplicity();
        if (mult.equals((Object)RelationTypeMultiplicity.MANY_TO_MANY) || mult.equals((Object)RelationTypeMultiplicity.ONE_TO_MANY)) {
            if (this.txData.relationSideAExists(relType, artA)) {
                minOrder = ((RelationDataSideA)this.txData.getNewRelations().get((Object)relType, (Object)artA)).getMinOrder();
                maxOrder = ((RelationDataSideA)this.txData.getNewRelations().get((Object)relType, (Object)artA)).getMaxOrder();
            } else {
                String minMaxString = (String)this.orcsApi.getJdbcService().getClient().fetch((Object)"0,0", "SELECT min(rel.rel_order) || ',' ||max(rel.rel_order) from osee_relation rel where rel.a_art_id = ? and rel.rel_type = ?", new Object[]{artA, relType.getId()});
                if (minMaxString != null && minMaxString.length() > 3) {
                    minOrder = Integer.parseInt(minMaxString.substring(0, minMaxString.indexOf(",") - 1));
                    maxOrder = Integer.parseInt(minMaxString.substring(minMaxString.indexOf(",") + 1));
                }
                this.txData.addRelationSideA(relType, artA, minOrder, maxOrder);
            }
            if (insertType.equals("start")) {
                relOrder = this.txData.calculateHeadInsertionOrderIndex(minOrder);
                ((RelationDataSideA)this.txData.getNewRelations().get((Object)relType, (Object)artA)).setMinOrder(relOrder);
            } else if (insertType.equals("insert")) {
                relOrder = this.txData.calculateInsertionOrderIndex(afterIndex, beforeIndex);
            } else {
                relOrder = this.txData.calculateEndInsertionOrderIndex(maxOrder);
                ((RelationDataSideA)this.txData.getNewRelations().get((Object)relType, (Object)artA)).setMaxOrder(relOrder);
            }
        }
        this.txManager.relate(this.txData, artA, relType, artB, relationArt, relOrder, RelationSorter.USER_DEFINED);
    }

    public void setRelations(ArtifactId artA, RelationTypeToken relType, Iterable<? extends ArtifactId> artBs) {
        this.validateBuilder();
        this.txManager.setRelations(this.txData, artA, relType, artBs);
    }

    public void setRelationsAndOrder(ArtifactId artifact, RelationTypeSide relationSide, List<? extends ArtifactId> artifacts) {
        this.validateBuilder();
        this.txManager.setRelationsAndOrder(this.txData, artifact, relationSide, artifacts);
    }

    public void setRationale(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, String rationale) {
        this.validateBuilder();
        this.txManager.setRationale(this.txData, artA, relType, artB, rationale);
    }

    public void unrelate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB) {
        this.validateBuilder();
        this.txManager.unrelate(this.txData, artA, relType, artB);
    }

    public void unrelateFromAll(RelationTypeSide typeAndSide, ArtifactId art) {
        this.validateBuilder();
        RelationTypeToken type = typeAndSide.getRelationType();
        this.txManager.unrelateFromAll(this.txData, type, art, typeAndSide.getSide());
    }

    public void unrelateFromAll(ArtifactId artA) {
        this.validateBuilder();
        this.txManager.unrelateFromAll(this.txData, artA);
    }

    public void unrelateFromInvalidArtifact(ArtifactId validArt, ArtifactId invalidArt) {
        this.txManager.unrelateFromInvalidArtifact(this.txData, validArt, invalidArt);
    }

    public void setRelationApplicability(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, ApplicabilityId applicId) {
        this.validateBuilder();
        this.txManager.setRelationApplicabilityId(this.txData, artA, relType, artB, applicId);
    }

    public void deleteArtifact(ArtifactId sourceArtifact) {
        this.validateBuilder();
        this.txManager.deleteArtifact(this.txData, sourceArtifact);
    }

    public boolean isCommitInProgress() {
        return this.txData.isCommitInProgress();
    }

    public TransactionToken commit() {
        this.validateBuilder();
        try {
            if (this.validateGammaIds()) {
                TransactionToken txId = (TransactionToken)this.txFactory.createTx(this.txData).call();
                if (txId.isValid()) {
                    this.committed = true;
                    return txId;
                }
                return TransactionToken.SENTINEL;
            }
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return TransactionToken.SENTINEL;
    }

    public List<ArtifactReadable> getTxDataReadables() {
        ArrayList<ArtifactReadable> list = new ArrayList<ArtifactReadable>(this.txData.getAllReadables());
        return list;
    }

    private void checkAreOnDifferentBranches(TxData txData, BranchId sourceBranch) {
        boolean isOnSameBranch = txData.isOnBranch(sourceBranch);
        Conditions.checkExpressionFailOnTrue((boolean)isOnSameBranch, (String)"Source branch is same branch as transaction branch[%s]", (Object[])new Object[]{txData.getBranch()});
    }

    protected ArtifactReadable getArtifactReadable(OrcsSession session, QueryFactory queryFactory, BranchId branch, ArtifactId id) {
        return (ArtifactReadable)queryFactory.fromBranch(branch).includeDeletedArtifacts().andId(id).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
    }

    public void setApplicability(ArtifactId artId, ApplicabilityId applicId) {
        this.validateBuilder();
        this.txManager.setApplicabilityId(this.txData, artId, applicId);
    }

    public void setApplicabilityReference(HashMap<ArtifactId, List<ApplicabilityId>> artifacts) {
        this.validateBuilder();
        TupleQuery tupleQuery = this.queryFactory.tupleQuery();
        for (Map.Entry<ArtifactId, List<ApplicabilityId>> entry : artifacts.entrySet()) {
            for (ApplicabilityId appId : entry.getValue()) {
                if (tupleQuery.doesTuple2Exist(CoreTupleTypes.ArtifactReferenceApplicabilityType, (Object)entry.getKey(), (Object)appId)) continue;
                this.addTuple2(CoreTupleTypes.ArtifactReferenceApplicabilityType, entry.getKey(), appId);
            }
        }
    }

    public void setApplicability(ApplicabilityId applicId, List<? extends ArtifactId> artifacts) {
        this.validateBuilder();
        for (ArtifactId artifactId : artifacts) {
            this.setApplicability(artifactId, applicId);
        }
    }

    public ArtifactToken createView(BranchId branch, String viewName) {
        this.validateBuilder();
        Artifact plFolder = this.txData.getWriteable((ArtifactId)CoreArtifactTokens.ProductsFolder);
        if (plFolder == null) {
            plFolder = CoreArtifactTokens.ProductsFolder;
        }
        ArtifactToken view = this.createArtifact((ArtifactId)plFolder, CoreArtifactTypes.BranchView, viewName);
        this.addTuple2(CoreTupleTypes.ApplicabilityDefinition, view, "Config = " + viewName);
        this.addTuple2(CoreTupleTypes.ViewApplicability, view, ApplicabilityToken.BASE.getName());
        this.addTuple2(CoreTupleTypes.ViewApplicability, view, "Config = " + viewName);
        return view;
    }

    public void createBranchCategory(BranchId branch, BranchCategoryToken category) {
        this.validateBuilder();
        this.txManager.createBranchCategory(this.txData, category);
    }

    public boolean deleteBranchCategory(BranchId branch, BranchCategoryToken category) {
        this.validateBuilder();
        List categories = this.orcsApi.getQueryFactory().branchQuery().getBranchCategoryGammaId(branch, category);
        if (categories != null) {
            if (categories.isEmpty()) {
                return false;
            }
            for (GammaId gammaId : categories) {
                this.txData.deleteBranchCategory(gammaId);
            }
        }
        return true;
    }

    public void createApplicabilityForView(ArtifactId viewId, String applicability) {
        this.validateBuilder();
        GammaId tupleGamma = this.tupleQuery.getTuple2GammaFromE1E2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)applicability);
        if (tupleGamma.isValid()) {
            this.introduceTuple((TupleTypeId)CoreTupleTypes.ViewApplicability, tupleGamma);
        } else {
            this.addTuple2(CoreTupleTypes.ViewApplicability, viewId, applicability);
        }
    }

    private Long insertValue(String value) {
        return this.keyValueOps.putIfAbsent(value);
    }

    public <E1, E2> GammaId addTuple2(Tuple2Type<E1, E2> tupleType, E1 e1, E2 e2) {
        this.validateBuilder();
        return this.txManager.createTuple2(this.txData, tupleType, this.toLong(e1), this.toLong(e2));
    }

    public <J extends OrcsTypeJoin<J, T>, T extends NamedId> void addOrcsTypeJoin(J typeJoin) {
        this.validateBuilder();
        Tuple2Type tupleType = typeJoin.getTupleType();
        NamedId[] namedIdArray = (NamedId[])typeJoin.getTypes();
        int n = namedIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedId type = namedIdArray[n2];
            this.addTuple2(tupleType, typeJoin, type);
            ++n2;
        }
    }

    public <E1, E2, E3> GammaId addTuple3(Tuple3Type<E1, E2, E3> tupleType, E1 e1, E2 e2, E3 e3) {
        this.validateBuilder();
        return this.txManager.createTuple3(this.txData, tupleType, this.toLong(e1), this.toLong(e2), this.toLong(e3));
    }

    public <E1, E2, E3, E4> GammaId addTuple4(Tuple4Type<E1, E2, E3, E4> tupleType, E1 e1, E2 e2, E3 e3, E4 e4) {
        this.validateBuilder();
        return this.txManager.createTuple4(this.txData, tupleType, this.toLong(e1), this.toLong(e2), this.toLong(e3), this.toLong(e4));
    }

    private Long toLong(Object element) {
        if (element instanceof String) {
            return this.insertValue((String)element);
        }
        if (element instanceof Id) {
            return ((Id)element).getId();
        }
        if (element instanceof Enum) {
            return ((Enum)element).ordinal();
        }
        return (Long)element;
    }

    public void deleteTuple2(GammaId gammaId) {
        this.validateBuilder();
        this.txData.deleteTuple(OseeDb.TUPLE2, gammaId);
    }

    public void deleteTuple3(GammaId gammaId) {
        this.validateBuilder();
        this.txData.deleteTuple(OseeDb.TUPLE3, gammaId);
    }

    public void deleteTuple4(GammaId gammaId) {
        this.validateBuilder();
        this.txData.deleteTuple(OseeDb.TUPLE4, gammaId);
    }

    public <E1, E2> boolean deleteTuple2(Tuple2Type<E1, E2> tupleType, E1 e1, E2 e2) {
        this.validateBuilder();
        ArrayList tuples = new ArrayList();
        this.tupleQuery.getTuple2GammaFromE1E2(tupleType, this.getBranch(), e1, e2, tuples::add);
        if (tuples.isEmpty()) {
            return false;
        }
        tuples.forEach(this::deleteTuple2);
        return true;
    }

    public <E1, E2, E3> boolean deleteTuple3(Tuple3Type<E1, E2, E3> tupleType, E1 element1, E2 element2, E3 element3) {
        this.validateBuilder();
        return false;
    }

    public <E1, E2, E3, E4> boolean deleteTuple4(Tuple4Type<E1, E2, E3, E4> tupleType, E1 element1, E2 element2, E3 element3, E4 element4) {
        this.validateBuilder();
        return false;
    }

    public <E1, E2, E3, E4> boolean deleteTuple4ByE1E2(Tuple4Type<E1, E2, E3, E4> tupleType, E1 e1, E2 e2) {
        this.validateBuilder();
        ArrayList tuples = new ArrayList();
        this.tupleQuery.getTuple4GammaFromE1E2(tupleType, this.getBranch(), e1, e2, tuples::add);
        if (tuples.isEmpty()) {
            return false;
        }
        tuples.forEach(this::deleteTuple4);
        return true;
    }

    public void addKeyValueOps(Long id, String name) {
        this.validateBuilder();
        this.keyValueOps.putByKey(id, name);
    }

    public ArtifactToken getWriteable(ArtifactId artifact) {
        Artifact art = this.txData.getWriteable(artifact);
        if (art == null) {
            art = ArtifactToken.SENTINEL;
        }
        return art;
    }

    private void validateBuilder() {
        if (this.committed) {
            throw new OseeStateException("Transaction has been committed and can not be re-used", new Object[0]);
        }
    }

    public <T> void setSoleAttributeValue(ArtifactId art, AttributeTypeToken attributeType, T value, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setSoleAttributeValue(art, attributeType, value);
    }

    public void setSoleAttributeFromStream(ArtifactId art, AttributeTypeToken attributeType, InputStream stream, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setSoleAttributeFromStream(art, attributeType, stream);
    }

    public void setSoleAttributeFromString(ArtifactId art, AttributeTypeToken attributeType, String value, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setSoleAttributeFromString(art, attributeType, value);
    }

    public <T> void setAttributesFromValues(ArtifactId art, AttributeTypeToken attributeType, Collection<T> values, Collection<GammaId> gammaIds) {
        for (GammaId gammaId : gammaIds) {
            this.addGamma(gammaId);
        }
        this.setAttributesFromValues(art, attributeType, values);
    }

    public void setAttributesFromStrings(ArtifactId art, AttributeTypeToken attributeType, GammaId gammaId, String ... values) {
        this.addGamma(gammaId);
        this.setAttributesFromStrings(art, attributeType, values);
    }

    public void setAttributesFromStrings(ArtifactId art, AttributeTypeToken attributeType, Collection<String> values, Collection<GammaId> gammaIds) {
        for (GammaId gammaId : gammaIds) {
            this.addGamma(gammaId);
        }
        this.setAttributesFromStrings(art, attributeType, values);
    }

    public <T> void setAttributeById(ArtifactId art, AttributeId attrId, T value, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setAttributeById(art, attrId, value);
    }

    public void setAttributeById(ArtifactId art, AttributeId attrId, String value, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setAttributeById(art, attrId, value);
    }

    public void setAttributeById(ArtifactId art, AttributeId attrId, InputStream stream, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setAttributeById(art, attrId, stream);
    }

    public void setAttributeApplicability(ArtifactId art, AttributeId attrId, ApplicabilityId applicId, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setAttributeApplicability(art, attrId, applicId);
    }

    private void addGamma(GammaId gammaId) {
        this.txData.addGammaId(gammaId);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, GammaId gammaId) {
        this.addGamma(gammaId);
        this.relate(artA, relType, artB);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, String rationale, GammaId gammaId) {
        this.addGamma(gammaId);
        this.relate(artA, relType, artB, rationale);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, RelationSorter sortType, GammaId gammaId) {
        this.addGamma(gammaId);
        this.relate(artA, relType, artB, sortType);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, String rationale, RelationSorter sortType, GammaId gammaId) {
        this.addGamma(gammaId);
        this.relate(artA, relType, artB, rationale, sortType);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, ArtifactId relatedArtifact, String insertType, int afterIndex, int beforeIndex, GammaId gammaId) {
        this.addGamma(gammaId);
        this.relate(artA, relType, artB, relatedArtifact, insertType, afterIndex, beforeIndex);
    }

    public void relate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, ArtifactId relatedArtifact, String afterArtifact, GammaId gammaId) {
        this.addGamma(gammaId);
        this.relate(artA, relType, artB, relatedArtifact, afterArtifact);
    }

    public void setRelations(ArtifactId artA, RelationTypeToken relType, Iterable<? extends ArtifactId> artBs, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setRelations(artA, relType, artBs);
    }

    public void setRationale(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, String rationale, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setRationale(artA, relType, artB, rationale);
    }

    public void unrelate(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, GammaId gammaId) {
        this.addGamma(gammaId);
        this.unrelate(artA, relType, artB);
    }

    public void unrelateFromAll(ArtifactId art, GammaId gammaId) {
        this.addGamma(gammaId);
        this.unrelateFromAll(art);
    }

    public void unrelateFromAll(RelationTypeSide typeSide, ArtifactId art, GammaId gammaId) {
        this.addGamma(gammaId);
        this.unrelateFromAll(typeSide, art);
    }

    public void setRelationApplicability(ArtifactId artA, RelationTypeToken relType, ArtifactId artB, ApplicabilityId applicId, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setRelationApplicability(artA, relType, artB, applicId);
    }

    public void setRelationsAndOrder(ArtifactId artifact, RelationTypeSide relationSide, List<? extends ArtifactId> artifacts, GammaId gammaId) {
        this.addGamma(gammaId);
        this.setRelationsAndOrder(artifact, relationSide, artifacts);
    }

    public void deleteByAttributeId(ArtifactId art, AttributeId attrId, GammaId gammaId) {
        this.addGamma(gammaId);
        this.deleteByAttributeId(art, attrId);
    }

    public void deleteSoleAttribute(ArtifactId art, AttributeTypeToken attributeType, GammaId gammaId) {
        this.addGamma(gammaId);
        this.deleteSoleAttribute(art, attributeType);
    }

    public void deleteAttributes(ArtifactId art, AttributeTypeToken attributeType, GammaId gammaId) {
        this.addGamma(gammaId);
        this.deleteAttributes(art, attributeType);
    }

    public void deleteAttributesWithValue(ArtifactId art, AttributeTypeToken attributeType, Object value, GammaId gammaId) {
        this.addGamma(gammaId);
        this.deleteAttributesWithValue(art, attributeType, value);
    }

    private boolean validateGammaIds() {
        if (this.txData.getGammaIdsModified().size() == 0) {
            return true;
        }
        Consumer<JdbcStatement> consumer = stmt -> this.txData.addFailedGammaId(GammaId.valueOf((Long)stmt.getLong("gamma_id")));
        String query = "SELECT gamma_id FROM osee_txs txs where txs.branch_id = ? and txs.tx_current = 0 and txs.gamma_id IN (" + this.txData.getGammaIdsModified().stream().map(g -> g.getIdString()).collect(Collectors.joining(",")) + ")";
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, query, new Object[]{this.txData.getBranch().getId()});
        return this.txData.getGammaIdsFailed().size() <= 0;
    }

    public List<GammaId> getGammaIdsFailed() {
        return this.txData.getGammaIdsFailed();
    }
}

