/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.disposition.model.CopySetParams;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.MassTeamAssignParams;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.internal.report.ExportSet;
import org.eclipse.osee.disposition.rest.internal.report.STRSReport;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

@Swagger
public class DispoAdminEndpoint {
    private final DispoApi dispoApi;
    private final BranchId branch;

    public DispoAdminEndpoint(DispoApi dispoApi, BranchId branch) {
        this.dispoApi = dispoApi;
        this.branch = branch;
    }

    @Path(value="/report")
    @GET
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Get Dispo Set report given a primary Set")
    @Tags(value={@Tag(name="report"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response getDispoSetReport(@Parameter(description="Primary Set", required=true) @Encoded @QueryParam(value="primarySet") String primarySet, @Parameter(description="Secondary Set", required=true) @Encoded @QueryParam(value="secondarySet") String secondarySet) {
        final DispoSet dispoSet = this.dispoApi.getDispoSetById(this.branch, primarySet);
        final DispoSet dispoSet2 = this.dispoApi.getDispoSetById(this.branch, secondarySet);
        final STRSReport writer = new STRSReport(this.dispoApi);
        String fileName = String.format("STRS_Report_%s", System.currentTimeMillis());
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream outputStream) throws WebApplicationException, IOException {
                writer.runReport(DispoAdminEndpoint.this.branch, dispoSet, dispoSet2, outputStream);
                outputStream.flush();
            }
        };
        String contentDisposition = String.format("attachment; filename=\"%s.xml\"; creation-date=\"%s\"", fileName, new Date());
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)contentDisposition).type("application/xml").build();
    }

    @Path(value="/export")
    @GET
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Post Dispo Set export given a primary Set")
    @Tags(value={@Tag(name="export"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response postDispoSetExport(@Parameter(description="Primary Set", required=true) @Encoded @QueryParam(value="primarySet") String primarySet, @Parameter(description="Option", required=true) @QueryParam(value="option") String option) {
        final DispoSet dispoSet = this.dispoApi.getDispoSetById(this.branch, primarySet);
        final ExportSet writer = new ExportSet(this.dispoApi);
        final String options = option;
        Date date = new Date();
        String newstring = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String fileName = String.format("Coverage_%s", newstring);
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream outputStream) throws WebApplicationException, IOException {
                String dispoType = dispoSet.getDispoType();
                if (dispoType.equals("testScript")) {
                    writer.runDispoReport(DispoAdminEndpoint.this.branch, dispoSet, options, outputStream, "");
                } else {
                    writer.runCoverageReport(DispoAdminEndpoint.this.branch, dispoSet, options, outputStream, "");
                }
                outputStream.flush();
            }
        };
        String contentDisposition = String.format("attachment; filename=\"%s.xml\"; creation-date=\"%s\"", fileName, new Date());
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)contentDisposition).type("application/xml").build();
    }

    @Path(value="/exportSummaryCoverage")
    @GET
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Post Dispo Set export summary given a primary Set")
    @Tags(value={@Tag(name="export"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response postDispoSetExportSummary(@Parameter(description="Primary Set", required=true) @Encoded @QueryParam(value="primarySet") String primarySet) {
        DispoSet dispoSet = this.dispoApi.getDispoSetById(this.branch, primarySet);
        ExportSet exportSet = new ExportSet(this.dispoApi);
        HashMap<String, Object> summaryCoverage = new HashMap<String, Object>();
        HashMap<String, Object> jsonResponse = new HashMap<String, Object>();
        exportSet.runCoverageSummaryReport(this.branch, dispoSet, summaryCoverage);
        Set<String> keys = summaryCoverage.keySet();
        String keyInString = String.join((CharSequence)",", keys);
        jsonResponse.put("Keys", keyInString);
        jsonResponse.put("Primary_Set", primarySet);
        jsonResponse.put("Summary_Of_Coverage", summaryCoverage);
        ObjectMapper mapper = new ObjectMapper();
        String response = "";
        try {
            response = mapper.writeValueAsString(jsonResponse);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
        return Response.ok((Object)response).build();
    }

    @Path(value="/{primarySet}/exportToFile")
    @GET
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Post Dispo Set export directory given a primary Set")
    @Tags(value={@Tag(name="export"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response postDispoSetExportDirectory(@Parameter(description="Primary Set", required=true) @Encoded @PathParam(value="primarySet") String primarySet, @Parameter(description="Option", required=true) @QueryParam(value="option") String option, final @Parameter(description="Expo file name", required=true) @HeaderParam(value="expoFileName") String expoFileName) {
        final DispoSet dispoSet = this.dispoApi.getDispoSetById(this.branch, primarySet);
        final ExportSet writer = new ExportSet(this.dispoApi);
        final String options = option;
        Date date = new Date();
        String newstring = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String fileName = String.format("Coverage_%s", newstring);
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream outputStream) throws WebApplicationException, IOException {
                String dispoType = dispoSet.getDispoType();
                if (dispoType.equals("testScript")) {
                    writer.runDispoReport(DispoAdminEndpoint.this.branch, dispoSet, options, outputStream, expoFileName);
                } else {
                    writer.runCoverageReport(DispoAdminEndpoint.this.branch, dispoSet, options, outputStream, expoFileName);
                }
                outputStream.flush();
            }
        };
        String contentDisposition = String.format("attachment; filename=\"%s.xml\"; creation-date=\"%s\"", fileName, new Date());
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)contentDisposition).type("application/xml").build();
    }

    @Path(value="/copyCoverage")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Dispo Set copy coverage given a destination Set")
    @Tags(value={@Tag(name="copy"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response getDispoSetCopyCoverage(@Parameter(description="Destination Set", required=true) @QueryParam(value="destinationSet") String destinationSet, @Parameter(description="Source Branch", required=true) @QueryParam(value="sourceBranch") BranchId sourceBranch, @Parameter(description="Source Package", required=true) @QueryParam(value="sourcePackage") Long sourcePackage, CopySetParams params, @QueryParam(value="userName") String userName) {
        this.dispoApi.copyDispoSetCoverage(sourceBranch, sourcePackage, this.branch, destinationSet, params, userName);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="/copy")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Dispo Set copy given a destination Set")
    @Tags(value={@Tag(name="copy"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response getDispoSetCopy(@Parameter(description="Destination Set", required=true) @QueryParam(value="destinationSet") String destinationSet, @Parameter(description="Source Program", required=true) @QueryParam(value="sourceProgram") BranchId sourceBranch, @Parameter(description="Source Set", required=true) @QueryParam(value="sourceSet") String sourceSet, CopySetParams params, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        this.dispoApi.copyDispoSet(this.branch, destinationSet, sourceBranch, sourceSet, params, userName);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="/multiItemEdit")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Operation(summary="Multi Item edit")
    @Tag(name="edit")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response multiItemEdit(MassTeamAssignParams params, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        this.dispoApi.massEditTeam(this.branch, params.getSetId(), params.getNamesList(), params.getTeam(), String.format("Mult Item Edit by: %s", params.getUserName()), userName);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="/rerun")
    @GET
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/xml"})
    @Operation(summary="Get rerun report")
    @Tags(value={@Tag(name="report"), @Tag(name="rerun")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response getRerunReport(@Parameter(description="Primary Set", required=true) @QueryParam(value="primarySet") String primarySet) {
        DispoSet set = this.dispoApi.getDispoSetById(this.branch, primarySet);
        final String rerunList = set.getRerunList();
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                BufferedWriter out = new BufferedWriter(writer);
                try {
                    out.write(rerunList);
                }
                finally {
                    Lib.close((AutoCloseable)out);
                }
                outputStream.flush();
            }
        };
        String contentDisposition = String.format("attachment; filename=\"%s.xml\"; creation-date=\"%s\"", "batch-list", new Date());
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)contentDisposition).type("application/xml").build();
    }
}

