/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.disposition.rest.internal.importer.IBaseSaxElementListener;
import org.xml.sax.Attributes;

public abstract class ElementHandlers {
    private final String name;
    private final List<IBaseSaxElementListener> listeners = new ArrayList<IBaseSaxElementListener>();

    public ElementHandlers(String name) {
        this.name = name;
    }

    public final String getElementName() {
        return this.name;
    }

    public final void addListener(IBaseSaxElementListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(IBaseSaxElementListener listener) {
        this.listeners.remove(listener);
    }

    void endElementFound(String uri, String localName, String name, String content) throws Exception {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object obj = this.createEndElementFoundObject(uri, localName, name, content);
        for (IBaseSaxElementListener listener : this.listeners) {
            listener.onEndElement(obj);
        }
    }

    void startElementFound(String uri, String localName, String name, Attributes attributes) throws Exception {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object obj = this.createStartElementFoundObject(uri, localName, name, attributes);
        for (IBaseSaxElementListener listener : this.listeners) {
            listener.onStartElement(obj);
        }
    }

    public abstract Object createStartElementFoundObject(String var1, String var2, String var3, Attributes var4);

    public Object createEndElementFoundObject(String uri, String localName, String name, String content) {
        return content;
    }
}

