/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.access.IAtsAccessService;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileSprintHtmlOperation;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.column.IAtsColumnService;
import org.eclipse.osee.ats.api.config.IAtsConfigurationsService;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueService;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.event.IAtsEventService;
import org.eclipse.osee.ats.api.notify.IAtsNotificationService;
import org.eclipse.osee.ats.api.program.IAtsProgramService;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.query.IAtsSearchDataProvider;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.task.create.IAtsTaskSetDefinitionProviderService;
import org.eclipse.osee.ats.api.task.related.IAtsTaskRelatedService;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinitionService;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.IArtifactResolver;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.util.ISequenceProvider;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionProviderService;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.ats.api.workflow.IAtsActionService;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsImplementerService;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemMetricsService;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.core.access.AtsAccessService;
import org.eclipse.osee.ats.core.action.AtsActionService;
import org.eclipse.osee.ats.core.agile.AgileService;
import org.eclipse.osee.ats.core.config.AbstractAtsConfigurationService;
import org.eclipse.osee.ats.core.config.TeamDefinitionServiceImpl;
import org.eclipse.osee.ats.core.internal.AtsWorkItemMetricsServiceImpl;
import org.eclipse.osee.ats.core.internal.column.ev.AtsColumnService;
import org.eclipse.osee.ats.core.internal.log.AtsLogFactory;
import org.eclipse.osee.ats.core.program.AtsProgramService;
import org.eclipse.osee.ats.core.review.AtsReviewServiceImpl;
import org.eclipse.osee.ats.core.task.internal.AtsTaskSetDefinitionProviderService;
import org.eclipse.osee.ats.core.version.AtsVersionServiceImpl;
import org.eclipse.osee.ats.core.workdef.AtsWorkDefinitionServiceImpl;
import org.eclipse.osee.ats.core.workflow.AtsImplementersService;
import org.eclipse.osee.ats.core.workflow.AtsWorkItemServiceImpl;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.framework.core.OseeApiBase;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.osgi.service.event.EventAdmin;

public abstract class AtsApiImpl
extends OseeApiBase
implements AtsApi {
    private final List<IAtsSearchDataProvider> searchDataProviders;
    protected Log logger;
    protected JdbcService jdbcService;
    protected IAtsWorkDefinitionService workDefinitionService;
    protected IAtsUserService userService;
    protected IAtsConfigurationsService configurationsService;
    protected IAtsEarnedValueService earnedValueService;
    protected TeamWorkflowProviders teamWorkflowProvidersLazy;
    protected IAttributeResolver attributeResolverService;
    protected IAtsActionService actionService;
    protected IAtsImplementerService implementerService;
    protected IAtsWorkItemService workItemService;
    protected IAtsWorkItemMetricsService workItemMetricsService;
    protected ISequenceProvider sequenceProvider;
    protected IAtsProgramService programService;
    protected IArtifactResolver artifactResolver;
    protected IAtsBranchService branchService;
    protected IAtsReviewService reviewService;
    protected IAtsColumnService columnServices;
    protected IAtsActionableItemService actionableItemManager;
    protected IRelationResolver relationResolver;
    protected IAtsVersionService versionService;
    protected IAtsTaskService taskService;
    protected IAtsTeamDefinitionService teamDefinitionService;
    protected IAtsQueryService queryService;
    protected IAtsStoreService storeService;
    protected IAtsTaskRelatedService taskRelatedService;
    protected IAtsWorkDefinitionProviderService workDefinitionProviderService;
    protected IAtsEventService eventService;
    protected EventAdmin eventAdmin;
    protected IAtsLogFactory logFactory;
    protected IAtsTaskSetDefinitionProviderService taskSetDefinitionProviderService;
    protected IAtsNotificationService notificationService;
    protected IAtsAccessService atsAccessService;
    protected IAgileService agileService;
    Collection<IAgileSprintHtmlOperation> agileSprintHtmlReportOperations = new LinkedList<IAgileSprintHtmlOperation>();

    public AtsApiImpl() {
        this.searchDataProviders = new ArrayList<IAtsSearchDataProvider>();
    }

    public void setAtsEventService(IAtsEventService eventService) {
        this.eventService = eventService;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setWorkDefinitionProviderService(IAtsWorkDefinitionProviderService workDefinitionProviderService) {
        this.workDefinitionProviderService = workDefinitionProviderService;
    }

    public void setAtsUserService(IAtsUserService userServiceClient) {
        this.userService = userServiceClient;
    }

    public void addSearchDataProvider(IAtsSearchDataProvider provider) {
        this.searchDataProviders.add(provider);
    }

    public void removeSearchDataProvider(IAtsSearchDataProvider provider) {
        this.searchDataProviders.remove(provider);
    }

    public void setTaskSetDefinitionProviderService(IAtsTaskSetDefinitionProviderService taskSetDefinitionProviderService) {
        this.taskSetDefinitionProviderService = taskSetDefinitionProviderService;
    }

    public void start() {
        this.teamWorkflowProvidersLazy = new TeamWorkflowProviders();
        this.workItemService = new AtsWorkItemServiceImpl(this, this.teamWorkflowProvidersLazy);
        this.workItemMetricsService = new AtsWorkItemMetricsServiceImpl(this);
        this.programService = new AtsProgramService(this);
        this.teamDefinitionService = new TeamDefinitionServiceImpl(this);
        this.versionService = new AtsVersionServiceImpl(this, this.eventAdmin);
        this.reviewService = new AtsReviewServiceImpl(this);
        this.workDefinitionService = new AtsWorkDefinitionServiceImpl(this, this.teamWorkflowProvidersLazy);
        this.logFactory = new AtsLogFactory();
        this.actionService = new AtsActionService(this);
        this.agileService = new AgileService(this.logger, this);
    }

    public void stop() {
        this.workDefinitionService = null;
        this.jdbcService = null;
    }

    public void clearCaches() {
        this.userService.reloadCache();
    }

    public String getAtsId(ArtifactToken artifact) {
        return AtsApiImpl.getAtsId(this.getAttributeResolver(), artifact);
    }

    public String getAtsId(IAtsObject atsObject) {
        return AtsApiImpl.getAtsId(this.getAttributeResolver(), atsObject.getStoreObject());
    }

    protected static String getAtsId(IAttributeResolver attrResolver, IAtsObject atsObject) {
        return AtsApiImpl.getAtsId(attrResolver, atsObject.getStoreObject());
    }

    protected static String getAtsId(IAttributeResolver attrResolver, ArtifactToken artifact) {
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        String toReturn = (String)attrResolver.getSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)AtsAttributeTypes.AtsId, null);
        if (toReturn == null) {
            toReturn = artifact.getIdString();
        }
        return toReturn;
    }

    public String getConfigValue(String key, String defaultValue) {
        String value;
        try {
            value = this.getConfigValue(key);
            if (Strings.isInValid((String)value)) {
                value = defaultValue;
            }
        }
        catch (Exception exception) {
            value = defaultValue;
        }
        return value;
    }

    public void setUserConfigValue(String key, String value) {
        AtsUser userArt = this.getUserService().getCurrentUser();
        IAtsChangeSet changes = this.storeService.createAtsChangeSet("Set User AtsConfig Value", this.getUserService().getCurrentUser());
        if (userArt != null) {
            String keyValue = String.format("%s=%s", key, value);
            boolean found = false;
            Collection attributes = this.getAttributeResolver().getAttributes((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.AtsUserConfig);
            for (IAttribute attr : attributes) {
                String str = (String)attr.getValue();
                if (!str.startsWith(key)) continue;
                changes.setAttribute((ArtifactId)userArt, (AttributeId)attr, (Object)keyValue);
                found = true;
                break;
            }
            if (!found) {
                changes.addAttribute((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.AtsUserConfig, (Object)keyValue);
            }
            changes.executeIfNeeded();
        }
    }

    public void setConfigValue(String key, String value) {
        ArtifactToken atsConfig = this.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        IAtsChangeSet changes = this.storeService.createAtsChangeSet("Set AtsConfig Value", this.getUserService().getCurrentUser());
        if (atsConfig != null) {
            String keyValue = String.format("%s=%s", key, value);
            boolean found = false;
            Collection attributes = this.getAttributeResolver().getAttributes((ArtifactId)atsConfig, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
            for (IAttribute attr : attributes) {
                String str = (String)attr.getValue();
                if (!str.startsWith(key)) continue;
                changes.setAttribute((ArtifactId)atsConfig, (AttributeId)attr, (Object)keyValue);
                found = true;
                break;
            }
            if (!found) {
                changes.addAttribute((ArtifactId)atsConfig, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)keyValue);
            }
            changes.executeIfNeeded();
        }
    }

    public BranchToken getAtsBranch() {
        return CoreBranches.COMMON;
    }

    public IAtsSearchDataProvider getSearchDataProvider(String namespace) {
        for (IAtsSearchDataProvider provider : this.searchDataProviders) {
            if (!provider.supportsNamespace(namespace)) continue;
            return provider;
        }
        throw new OseeArgumentException("Namespace [%s] is not supported by any of the providers %s", new Object[]{namespace, this.searchDataProviders});
    }

    public IAgileService getAgileService() {
        return this.agileService;
    }

    public Log getLogger() {
        return this.logger;
    }

    public IAtsEarnedValueService getEarnedValueService() {
        return this.earnedValueService;
    }

    public IAtsWorkDefinitionService getWorkDefinitionService() {
        return this.workDefinitionService;
    }

    public IAtsUserService getUserService() {
        return this.userService;
    }

    public IAttributeResolver getAttributeResolver() {
        return this.attributeResolverService;
    }

    public IAtsEarnedValueServiceProvider getEarnedValueServiceProvider() {
        return this;
    }

    public ITeamWorkflowProvidersLazy getTeamWorkflowProviders() {
        return this.teamWorkflowProvidersLazy;
    }

    public IAtsActionService getActionService() {
        return this.actionService;
    }

    public IAtsImplementerService getImplementerService() {
        if (this.implementerService == null) {
            this.implementerService = new AtsImplementersService();
        }
        return this.implementerService;
    }

    public IAtsWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public IAtsWorkItemMetricsService getWorkItemMetricsService() {
        return this.workItemMetricsService;
    }

    public void setWorkItemService(IAtsWorkItemService workItemService) {
        this.workItemService = workItemService;
    }

    public ISequenceProvider getSequenceProvider() {
        if (this.sequenceProvider == null) {
            this.sequenceProvider = new ISequenceProvider(){

                public long getNext(String sequenceName) {
                    return AtsApiImpl.this.jdbcService.getClient().getNextSequence(sequenceName, false);
                }
            };
        }
        return this.sequenceProvider;
    }

    public IAtsProgramService getProgramService() {
        return this.programService;
    }

    public IAtsReviewService getReviewService() {
        return this.reviewService;
    }

    public IAtsLogFactory getLogFactory() {
        return this.logFactory;
    }

    public IArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public IRelationResolver getRelationResolver() {
        return this.relationResolver;
    }

    public IAtsBranchService getBranchService() {
        return this.branchService;
    }

    public IAtsColumnService getColumnService() {
        if (this.columnServices == null) {
            this.columnServices = new AtsColumnService(this);
        }
        return this.columnServices;
    }

    public IAtsVersionService getVersionService() {
        return this.versionService;
    }

    public void setVersionService(IAtsVersionService versionService) {
        this.versionService = versionService;
    }

    public IAtsTaskService getTaskService() {
        return this.taskService;
    }

    public IAtsTeamDefinitionService getTeamDefinitionService() {
        return this.teamDefinitionService;
    }

    public IAtsQueryService getQueryService() {
        return this.queryService;
    }

    public IAtsStoreService getStoreService() {
        return this.storeService;
    }

    public IAtsChangeSet createChangeSet(String comment, AtsUser user) {
        return this.storeService.createAtsChangeSet(comment, user);
    }

    public JdbcService getJdbcService() {
        return this.jdbcService;
    }

    public Collection<IAgileSprintHtmlOperation> getAgileSprintHtmlReportOperations() {
        return this.agileSprintHtmlReportOperations;
    }

    public boolean isSingleServerDeployment() {
        return "true".equals(this.getConfigValue("single_server_deployment"));
    }

    public IAtsConfigurationsService getConfigService() {
        return this.configurationsService;
    }

    public IAtsWorkDefinitionProviderService getWorkDefinitionProviderService() {
        return this.workDefinitionProviderService;
    }

    public String getUserConfigValue(String key) {
        String result = null;
        UserToken userArt = this.userService().getUser();
        if (userArt != null) {
            for (String configKeyValueStr : this.getAttributeResolver().getAttributesToStringList((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.AtsUserConfig)) {
                if (!configKeyValueStr.startsWith(key)) continue;
                result = configKeyValueStr.replaceFirst(String.valueOf(key) + "=", "");
                break;
            }
        }
        return result;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public IAtsEventService getEventService() {
        return this.eventService;
    }

    public IAtsTaskSetDefinitionProviderService getTaskSetDefinitionProviderService() {
        if (this.taskSetDefinitionProviderService == null) {
            this.taskSetDefinitionProviderService = new AtsTaskSetDefinitionProviderService();
        }
        return this.taskSetDefinitionProviderService;
    }

    public IAtsChangeSet createChangeSet(String comment, BranchToken branch) {
        return this.storeService.createAtsChangeSet(comment, branch, this.userService.getCurrentUser());
    }

    public IAtsChangeSet createChangeSet(String comment, BranchToken branch, AtsUser asUser) {
        return this.storeService.createAtsChangeSet(comment, branch, asUser);
    }

    public IAtsChangeSet createChangeSet(String comment) {
        return this.storeService.createAtsChangeSet(comment, this.userService.getCurrentUser());
    }

    public String getConfigValue(String key) {
        return this.getConfigService().getConfigurations().getConfigValue(key);
    }

    public String getConfigValueNoCache(String key) {
        ArtifactToken atsConfig = this.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        if (atsConfig != null) {
            for (String keyValue : this.getAttributeResolver().getAttributesToStringList((ArtifactId)atsConfig, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData)) {
                String fndKey;
                Matcher m = AbstractAtsConfigurationService.keyValuePattern.matcher(keyValue);
                if (!m.find() || !key.equals(fndKey = m.group(1))) continue;
                String value = m.group(2);
                return value;
            }
        }
        return "";
    }

    public IAtsNotificationService getNotificationService() {
        return this.notificationService;
    }

    public IAtsAccessService getAtsAccessService() {
        if (this.atsAccessService == null) {
            this.atsAccessService = new AtsAccessService(this);
        }
        return this.atsAccessService;
    }
}

