/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.task.CreateTasksOption;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class CreateTasksWorkflow {
    protected final Collection<CreateTasksOption> createTasksOptions;
    protected final boolean createWorkflow;
    protected final boolean reportOnly;
    protected final XResultData resultData;
    protected final IAtsChangeSet changes;
    protected final Date createdDate;
    protected final AtsUser createdBy;
    protected final IAtsTeamWorkflow sourceTeamWf;
    protected final CommitConfigItem commitConfigItem;
    protected final WorkType workType;
    protected IAtsTeamWorkflow destTeam;
    protected final String pcrNumber;
    protected final AtsApi atsApi;
    protected IAtsActionableItem actionableItem;
    protected final List<INewActionListener> newActionListeners = new ArrayList<INewActionListener>();

    public CreateTasksWorkflow(String pcrNumber, Collection<CreateTasksOption> createTasksOptions, Collection<String> taskNamesMissingTaskArtifact, boolean reportOnly, XResultData resultData, IAtsChangeSet changes, Date createdDate, AtsUser createdBy, IAtsTeamWorkflow sourceTeamWf, CommitConfigItem commitConfigArt, WorkType workType, IAtsTeamWorkflow destTeam, IAtsProgram program) {
        this(pcrNumber, createTasksOptions, (!taskNamesMissingTaskArtifact.isEmpty() || createTasksOptions.contains(CreateTasksOption.WorkflowsOnly)) && destTeam == null, reportOnly, resultData, changes, createdDate, createdBy, sourceTeamWf, commitConfigArt, workType, destTeam, program);
    }

    public CreateTasksWorkflow(String pcrNumber, Collection<CreateTasksOption> createTasksOptions, boolean createWorkflow, boolean reportOnly, XResultData resultData, IAtsChangeSet changes, Date createdDate, AtsUser createdBy, IAtsTeamWorkflow sourceTeamWf, CommitConfigItem commitConfigItem, WorkType workType, IAtsTeamWorkflow destTeam, IAtsProgram program) {
        this.pcrNumber = pcrNumber;
        this.createTasksOptions = createTasksOptions;
        this.createWorkflow = createWorkflow;
        this.reportOnly = reportOnly;
        this.resultData = resultData;
        this.changes = changes;
        this.createdDate = createdDate;
        this.createdBy = createdBy;
        this.sourceTeamWf = sourceTeamWf;
        this.commitConfigItem = commitConfigItem;
        this.workType = workType;
        this.destTeam = destTeam;
        this.atsApi = AtsApiService.get();
    }

    protected void logWorkflowCreation() {
        this.resultData.logf("Create [%s] Workflow\n", new Object[]{this.workType.name()});
    }

    public boolean isSourceTeamWfEqualDestination() {
        return false;
    }

    public IAtsActionableItem getActionableItem() {
        return this.actionableItem;
    }

    public Collection<INewActionListener> getNewActionListeners() {
        return this.newActionListeners;
    }

    public IAtsTeamWorkflow createMissingWorkflow() {
        if (this.createWorkflow) {
            this.logWorkflowCreation();
            if (this.isSourceTeamWfEqualDestination()) {
                this.destTeam = this.sourceTeamWf;
            } else {
                IAtsAction action = this.sourceTeamWf.getParentAction();
                HashSet<IAtsActionableItem> actionableItems = new HashSet<IAtsActionableItem>();
                List<AtsUser> assignees = this.getAssignees();
                IAtsActionableItem aia = this.getActionableItem();
                if (aia != null) {
                    actionableItems.add(aia);
                    IAtsTeamWorkflow newTeamWf = this.atsApi.getActionService().createTeamWorkflow(action, (IAtsTeamDefinition)AtsApiService.get().getTeamDefinitionService().getImpactedTeamDefs(actionableItems).iterator().next(), actionableItems, assignees, this.changes, this.createdDate, this.createdBy, this.getNewActionListeners(), new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
                    if (this.createTasksOptions.contains(CreateTasksOption.CreateWorkflowsAsOseeSystem)) {
                        this.changes.setCreatedBy((IAtsWorkItem)newTeamWf, AtsCoreUsers.SYSTEM_USER, false, null);
                    }
                    this.destTeam = newTeamWf;
                }
            }
        }
        return this.destTeam;
    }

    protected List<AtsUser> getAssignees() {
        LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
        assignees.add(AtsCoreUsers.UNASSIGNED_USER);
        return assignees;
    }

    public void setTargetedVersion() {
        if (this.commitConfigItem instanceof IAtsVersion) {
            IAtsVersion targetedVersion = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)this.destTeam);
            IAtsVersion commitConfigVer = (IAtsVersion)this.commitConfigItem;
            if (targetedVersion == null || !targetedVersion.equals(commitConfigVer)) {
                if (targetedVersion != null) {
                    this.changes.unrelateAll((Object)this.destTeam, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
                }
                this.changes.relate((Object)this.destTeam, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (Object)commitConfigVer);
            }
        }
    }

    public void setActionableItem(IAtsActionableItem ai) {
        this.actionableItem = ai;
    }
}

