/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.internal.state.WorkState;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLog;

public class StateManager
implements IAtsStateManager {
    private final IAtsWorkItem workItem;
    private List<WorkState> states;
    private TransactionId transaction;
    private final AtsApi atsApi;

    public StateManager(IAtsWorkItem workItem, AtsApi atsApi) {
        this.workItem = workItem;
        this.atsApi = atsApi;
        this.transaction = atsApi.getStoreService().getTransactionId(workItem);
    }

    public void transitionHelper(IStateToken fromState, IStateToken toState) {
        this.ensureLoaded();
        this.getOrCreateState(toState.getName());
    }

    private WorkState getStateOrNull(String stateName) {
        Conditions.assertNotNullOrEmpty((String)stateName, (String)"state can not be null for %s", (Object[])new Object[]{this.workItem.toStringWithId()});
        this.ensureLoaded();
        for (WorkState state : this.states) {
            if (!state.getName().equals(stateName)) continue;
            return state;
        }
        return null;
    }

    public Collection<AtsUser> getAssignees(String stateName) {
        this.ensureLoaded();
        WorkState state = this.getStateOrNull(stateName);
        if (state != null) {
            return state.getAssignees();
        }
        return Collections.emptyList();
    }

    private WorkState getOrCreateState(String stateName) {
        Conditions.assertNotNullOrEmpty((String)stateName, (String)"stateName can not be null for %s", (Object[])new Object[]{this.workItem.toStringWithId()});
        this.ensureLoaded();
        WorkState state = this.getStateOrNull(stateName);
        if (state == null) {
            state = WorkState.create(this.workItem, stateName, false);
            this.addState(state);
        }
        return state;
    }

    public void setCurrentState(String stateName) {
        Conditions.assertNotNullOrEmpty((String)stateName, (String)"state can not be null for %s", (Object[])new Object[]{this.workItem.toStringWithId()});
        this.ensureLoaded();
        for (WorkState state : this.states) {
            if (state.getName().equals(stateName)) {
                state.setCurrentState(true);
                continue;
            }
            state.setCurrentState(false);
        }
    }

    public Collection<AtsUser> getAssignees(IStateToken state) {
        this.ensureLoaded();
        return this.getAssignees(state.getName());
    }

    public void addState(WorkState workState) {
        this.ensureLoaded();
        this.addState(workState, true);
    }

    protected void addState(WorkState state, boolean logError) {
        WorkState state2 = this.getStateOrNull(state.getName());
        if (state2 != null) {
            String errorStr = String.format("Error: State [%s] already exists for [%s]", state.getName(), this.workItem.getAtsId());
            if (logError) {
                OseeLog.log(StateManager.class, (Level)Level.SEVERE, (String)errorStr);
            }
            return;
        }
        this.states.add(state);
    }

    private synchronized void ensureLoaded() {
        TransactionId currTransactionId = TransactionId.SENTINEL;
        if (this.states != null && !(currTransactionId = this.atsApi.getStoreService().getTransactionId(this.workItem)).equals(this.transaction)) {
            this.states = null;
        }
        if (this.states == null) {
            this.states = new ArrayList<WorkState>();
            for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState)) {
                WorkState currentState = WorkState.create(this.workItem, (IAttribute<Object>)attr, true);
                this.states.add(currentState);
            }
            for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.State)) {
                WorkState state = WorkState.create(this.workItem, (IAttribute<Object>)attr, false);
                this.states.add(state);
            }
            this.transaction = currTransactionId;
        }
    }

    public void createOrUpdateState(String stateName, Collection<AtsUser> assignees) {
        Conditions.assertNotNullOrEmpty((String)stateName, (String)"state can not be null for %s", (Object[])new Object[]{this.workItem.toStringWithId()});
        this.ensureLoaded();
        WorkState state = this.getOrCreateState(stateName);
        if (assignees != null) {
            state.setAssignees(assignees);
        }
    }

    public void clearCaches() {
        this.states = null;
        this.transaction = TransactionId.SENTINEL;
    }

    public void addAssignee(AtsUser user) {
        this.ensureLoaded();
        WorkState state = this.getOrCreateState(this.workItem.getCurrentStateName());
        state.addAssignee(user);
    }

    public void createOrUpdateState(IStateToken state) {
        Conditions.checkNotNull((Object)state, (String)"state");
        Conditions.assertNotNullOrEmpty((String)state.getName(), (String)"state can not be null for %s", (Object[])new Object[]{this.workItem.toStringWithId()});
        this.ensureLoaded();
        this.getOrCreateState(state.getName());
    }

    public void writeToStore(IAtsChangeSet changes) {
        WorkState currWorkState = this.getCurrentState();
        if (currWorkState == null) {
            throw new OseeStateException("Current WorkState can not be null for %s", new Object[]{this.workItem.toStringWithId()});
        }
        for (WorkState state : this.states) {
            if (state.isCurrentState()) {
                if (state.getAttr() != null && state.getAttr().getAttributeType().equals(AtsAttributeTypes.State)) {
                    changes.deleteAttribute(this.workItem, state.getAttr());
                }
                changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, state.getStoreStr());
                continue;
            }
            if (state.getAttr() == null || state.getAttr().getAttributeType().equals(AtsAttributeTypes.CurrentState)) {
                changes.addAttribute((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.State, (Object)state.getStoreStr());
                continue;
            }
            changes.setAttribute(this.workItem, state.getAttr(), (Object)state.getStoreStr());
        }
        this.clearCaches();
    }

    private WorkState getCurrentState() {
        this.ensureLoaded();
        for (WorkState state : this.states) {
            if (!state.isCurrentState()) continue;
            return state;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction: ");
        sb.append(this.transaction.toString());
        sb.append(" - ");
        if (this.states == null) {
            sb.append(" (not loaded)");
        } else {
            for (WorkState state : this.states) {
                if (state.isCurrentState()) {
                    sb.append("Curr ");
                }
                sb.append("State: ");
                sb.append(state.toString());
                sb.append(" - ");
            }
        }
        return sb.toString();
    }
}

