/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreTypeTokenProvider;

public interface CoreArtifactTypes {
    public static final ArtifactTypeToken Artifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)1L, "Artifact", false, new ArtifactTypeToken[0]).any(CoreAttributeTypes.Annotation).zeroOrOne(CoreAttributeTypes.ContentUrl).any(CoreAttributeTypes.DataClassification).any(CoreAttributeTypes.DataRightsCuiLimitedDisseminationControl).any(CoreAttributeTypes.DataRightsTrigraphCountryCode).zeroOrOne(CoreAttributeTypes.DataClassificationRationale).zeroOrOne(CoreAttributeTypes.Description).exactlyOne(CoreAttributeTypes.Name, "unnamed").zeroOrOne(CoreAttributeTypes.RelationOrder).any(CoreAttributeTypes.StaticId));
    public static final ArtifactTypeToken Markdown = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3432564532423888L, "Markdown", true, Artifact).exactlyOne(CoreAttributeTypes.MarkdownContent, "## Enter Markdown Here\n").exactlyOne(CoreAttributeTypes.Extension, "md").zeroOrOne(CoreAttributeTypes.ParagraphNumber));
    public static final ArtifactTypeToken AbstractAccessControlled = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)17L, "Abstract Access Controlled", true, Artifact).any(CoreAttributeTypes.AccessContextId));
    public static final ArtifactTypeToken AbstractHeading = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)805L, "Abstract Heading", true, Artifact).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId).any(CoreAttributeTypes.DoorsModId).zeroOrOne(CoreAttributeTypes.MarkdownContent).zeroOrOne(CoreAttributeTypes.Extension));
    public static final ArtifactTypeToken AbstractImplementationDetails = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)921211884L, "Abstract Implementation Details", true, Artifact).zeroOrOne(CoreAttributeTypes.DataRightsBasis).any(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified).atLeastOne(CoreAttributeTypes.Partition, CoreAttributeTypes.Partition.Unspecified).zeroOrOne(CoreAttributeTypes.PotentialSecurityImpact).zeroOrOne(CoreAttributeTypes.SubjectMatterExpert).exactlyOne(CoreAttributeTypes.Subsystem, CoreAttributeTypes.Subsystem.Unspecified).zeroOrOne(CoreAttributeTypes.MarkdownContent).zeroOrOne(CoreAttributeTypes.Extension));
    public static final ArtifactTypeToken AbstractTestResult = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)38L, "Abstract Test Result", true, Artifact));
    public static final ArtifactTypeToken BranchView = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5849078277209560034L, "Branch View", false, Artifact).any(CoreAttributeTypes.ProductApplicability, "Unspecified"));
    public static final ArtifactTypeToken Breaker = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)188458869981236L, "Breaker", false, Artifact).exactlyOne(CoreAttributeTypes.CircuitBreakerId).exactlyOne(CoreAttributeTypes.DisplayText, "unset").zeroOrOne(CoreAttributeTypes.FunctionalGrouping, CoreAttributeTypes.FunctionalGrouping.Avionics).exactlyOne(CoreAttributeTypes.MaintainerText, "unset").exactlyOne(CoreAttributeTypes.RequireConfirmation));
    public static final ArtifactTypeToken CertificationBaselineEvent = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)99L, "Certification Baseline Event", false, Artifact).zeroOrOne(CoreAttributeTypes.BaselinedBy).zeroOrOne(CoreAttributeTypes.BaselinedTimestamp).zeroOrOne(CoreAttributeTypes.GitChangeId).zeroOrOne(CoreAttributeTypes.ReviewId).zeroOrOne(CoreAttributeTypes.ReviewStoryId));
    public static final ArtifactTypeToken CodeUnit = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)58L, "Code Unit", false, Artifact).zeroOrOne(CoreAttributeTypes.DataRightsBasis).any(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified).exactlyOne(CoreAttributeTypes.FileSystemPath).zeroOrOne(CoreAttributeTypes.SubjectMatterExpert));
    public static final ArtifactTypeToken Component = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)57L, "Component", false, Artifact).exactlyOne(CoreAttributeTypes.Developmental, Boolean.TRUE).exactlyOne(CoreAttributeTypes.GfeCfe, CoreAttributeTypes.GfeCfe.Unspecified).exactlyOne(CoreAttributeTypes.IDAL, CoreAttributeTypes.IDAL.Unspecified).zeroOrOne(CoreAttributeTypes.FACEProfile, CoreAttributeTypes.FACEProfile.Unspecified).zeroOrOne(CoreAttributeTypes.FACESegment, CoreAttributeTypes.FACESegment.Unspecified).zeroOrOne(CoreAttributeTypes.FACEVersion, CoreAttributeTypes.FACEVersion.Unspecified));
    public static final ArtifactTypeToken DataRightsConfiguration = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)1679213104L, "Data Rights Configuration", false, Artifact).any(CoreAttributeTypes.DataClassification).any(CoreAttributeTypes.DataRightsCuiLimitedDisseminationControl).any(CoreAttributeTypes.DataRightsTrigraphCountryCode).any(CoreAttributeTypes.DataRightsRequiredIndicator));
    public static final ArtifactTypeToken DataRightsRequiredIndicatorConfiguration = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)1747427168L, "Required Indicator Configuration", false, Artifact).exactlyOne(CoreAttributeTypes.DataRightsRequiredIndicatorTitleStatement).exactlyOne(CoreAttributeTypes.DataRightsRequiredIndicatorHeaderStatement).exactlyOne(CoreAttributeTypes.DataRightsRequiredIndicatorFooterStatement).any(CoreAttributeTypes.DataRightsRequiredIndicatorFrequency));
    public static final ArtifactTypeToken EnumeratedArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)4619295485563766003L, "Enumerated Artifact", false, Artifact));
    public static final ArtifactTypeToken Feature = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)87L, "Feature", false, Artifact).zeroOrOne(CoreAttributeTypes.DefaultValue).any(CoreAttributeTypes.ProductApplicability, "Unspecified").exactlyOne(CoreAttributeTypes.FeatureMultivalued).exactlyOne(CoreAttributeTypes.FeatureValueType, CoreAttributeTypes.FeatureValueType.String).any(CoreAttributeTypes.Value));
    public static final ArtifactTypeToken Folder = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)11L, "Folder", false, Artifact));
    public static final ArtifactTypeToken GeneralData = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)12L, "General Data", false, Artifact).any(CoreAttributeTypes.GeneralStringData).zeroOrOne(CoreAttributeTypes.PublishInline));
    public static final ArtifactTypeToken AccessControlModel = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2L, "Access Control Model", false, GeneralData));
    public static final ArtifactTypeToken FeatureDefinition = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5849078290088170402L, "Feature Definition", false, GeneralData));
    public static final ArtifactTypeToken GitCommit = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)100L, "Git Commit", false, Artifact).zeroOrOne(CoreAttributeTypes.GitChangeId).zeroOrOne(CoreAttributeTypes.GitCommitAuthorDate).zeroOrOne(CoreAttributeTypes.GitCommitMessage).zeroOrOne(CoreAttributeTypes.GitCommitSha).zeroOrOne(CoreAttributeTypes.UserArtifactId));
    public static final ArtifactTypeToken GitRepository = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)97L, "Git Repository", false, Artifact).zeroOrOne(CoreAttributeTypes.DefaultTrackingBranch).any(CoreAttributeTypes.ExcludePath).zeroOrOne(CoreAttributeTypes.FileSystemPath).zeroOrOne(CoreAttributeTypes.RepositoryUrl));
    public static final ArtifactTypeToken GlobalPreferences = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3L, "Global Preferences", false, Artifact).zeroOrOne(CoreAttributeTypes.DefaultMailServer).zeroOrOne(CoreAttributeTypes.Dictionary).any(CoreAttributeTypes.GeneralStringData).zeroOrOne(CoreAttributeTypes.ProductLinePreferences).zeroOrOne(CoreAttributeTypes.WebPreferences));
    public static final ArtifactTypeToken GroupArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6L, "Group Artifact", false, Artifact));
    public static final ArtifactTypeToken HtmlArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)798L, "HTML Artifact", false, Artifact).any(CoreAttributeTypes.HtmlContent).any(CoreAttributeTypes.ImageContent).zeroOrOne(CoreAttributeTypes.ParagraphNumber).zeroOrOne(CoreAttributeTypes.PublishInline));
    public static final ArtifactTypeToken HeadingHtml = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)804L, "Heading - HTML", false, AbstractHeading, HtmlArtifact));
    public static final ArtifactTypeToken ImageArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)800L, "Image Artifact", false, Artifact).any(CoreAttributeTypes.ImageContent).zeroOrOne(CoreAttributeTypes.ParagraphNumber));
    public static final ArtifactTypeToken ModelDiagram = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)98L, "Model Diagram", false, Artifact).exactlyOne(CoreAttributeTypes.GraphitiDiagram, "<?xml version= \"1.0\" encoding= \"ASCII\"?><pi:Diagram xmi:version= \"2.0\" xmlns:xmi= \"http://www.omg.org/XMI\" xmlns:xsi= \"http://www.w3.org/2001/XMLSchema-instance\" xmlns:al= \"http://eclipse.org/graphiti/mm/algorithms\" xmlns:pi= \"http://eclipse.org/graphiti/mm/pictograms\" visible= \"true\" gridUnit= \"10\" diagramTypeId= \"mbse\" name= \"mbse basic\" snapToGrid= \"true\" version= \"0.11.0\"><graphicsAlgorithm xsi:type= \"al:Rectangle\" background= \"//@colors.1\" foreground= \"//@colors.0\" lineWidth= \"1\" transparency= \"0.0\" width= \"1000\" height= \"1000\"/><colors red= \"227\" green= \"238\" blue= \"249\"/><colors red= \"255\" green= \"255\" blue= \"255\"/></pi:Diagram>"));
    public static final ArtifactTypeToken MsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)16L, "MS Word", true, Artifact).zeroOrOne(CoreAttributeTypes.ParagraphNumber));
    public static final ArtifactTypeToken MsWordTemplate = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)19L, "MS Word Template", false, MsWord).zeroOrOne(CoreAttributeTypes.PageOrientation, CoreAttributeTypes.PageOrientation.Portrait).zeroOrOne(CoreAttributeTypes.PublishInline).zeroOrOne(CoreAttributeTypes.WordOleData).zeroOrOne(CoreAttributeTypes.WordTemplateContent, "<w:p xmlns:w= \"http://schemas.microsoft.com/office/word/2003/wordml\"><w:r><w:t></w:t></w:r></w:p>"));
    public static final ArtifactTypeToken DesignMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)346L, "Design - MS Word", false, MsWordTemplate).zeroOrOne(CoreAttributeTypes.DataRightsBasis).any(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId).any(CoreAttributeTypes.DoorsModId).zeroOrOne(CoreAttributeTypes.IaPlan).zeroOrOne(CoreAttributeTypes.LegacyDal, CoreAttributeTypes.LegacyDal.Unspecified).zeroOrOne(CoreAttributeTypes.PotentialSecurityImpact).exactlyOne(CoreAttributeTypes.SeverityCategory, CoreAttributeTypes.SeverityCategory.Unspecified).zeroOrOne(CoreAttributeTypes.SubjectMatterExpert));
    public static final ArtifactTypeToken DesignDescriptionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)810L, "Design Description - MS Word", false, MsWordTemplate, AbstractHeading));
    public static final ArtifactTypeToken DocumentDescriptionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)806L, "Document Description - MS Word", false, MsWordTemplate, AbstractHeading));
    public static final ArtifactTypeToken FunctionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)34L, "Function - MS Word", true, MsWordTemplate).exactlyOne(CoreAttributeTypes.FDAL, CoreAttributeTypes.FDAL.Unspecified).zeroOrOne(CoreAttributeTypes.FdalRationale).exactlyOne(CoreAttributeTypes.SeverityCategory, CoreAttributeTypes.SeverityCategory.Unspecified).zeroOrOne(CoreAttributeTypes.SoftwareSafetyImpact));
    public static final ArtifactTypeToken HeadingMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)56L, "Heading - MS Word", false, MsWordTemplate, AbstractHeading).zeroOrOne(CoreAttributeTypes.DataRightsBasis).any(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified));
    public static final ArtifactTypeToken ImplementationDetailsMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)26L, "Implementation Details - MS Word", false, MsWordTemplate, AbstractImplementationDetails));
    public static final ArtifactTypeToken ImplementationDetailsDataDefinitionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)279578L, "Implementation Details Data Definition - MS Word", false, ImplementationDetailsMsWord));
    public static final ArtifactTypeToken ImplementationDetailsDrawingMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)209690L, "Implementation Details Drawing - MS Word", false, ImplementationDetailsMsWord));
    public static final ArtifactTypeToken ImplementationDetailsFunctionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)139802L, "Implementation Details Function - MS Word", false, ImplementationDetailsMsWord));
    public static final ArtifactTypeToken ImplementationDetailsProcedureMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)69914L, "Implementation Details Procedure - MS Word", false, ImplementationDetailsMsWord));
    public static final ArtifactTypeToken MsWordWholeDocument = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)18L, "MS Word Whole Document", false, MsWord).zeroOrOne(CoreAttributeTypes.IaPlan).zeroOrOne(CoreAttributeTypes.WholeWordContent, "<?xml version= '1.0' encoding= 'UTF-8' standalone= 'yes'?><?mso-application progid= 'Word.Document'?><w:wordDocument xmlns:w= 'http://schemas.microsoft.com/office/word/2003/wordml' xmlns:v= 'urn:schemas-microsoft-com:vml' xmlns:w10= 'urn:schemas-microsoft-com:office:word' xmlns:sl= 'http://schemas.microsoft.com/schemaLibrary/2003/core' xmlns:aml= 'http://schemas.microsoft.com/aml/2001/core' xmlns:wx= 'http://schemas.microsoft.com/office/word/2003/auxHint' xmlns:o= 'urn:schemas-microsoft-com:office:office' xmlns:dt= 'uuid:C2F41010-65B3-11d1-A29F-00AA00C14882' xmlns:wsp= 'http://schemas.microsoft.com/office/word/2003/wordml/sp2' xmlns:ns0= 'http://www.w3.org/2001/XMLSchema' xmlns:ns1= 'http://eclipse.org/artifact.xsd' xmlns:st1= 'urn:schemas-microsoft-com:office:smarttags' w:macrosPresent= 'no' w:embeddedObjPresent= 'no' w:ocxPresent= 'no' xml:space= 'preserve'><w:body></w:body></w:wordDocument>"));
    public static final ArtifactTypeToken MsWordStyles = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2578L, "MS Word Styles", false, MsWordWholeDocument));
    public static final ArtifactTypeToken NativeArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)20L, "Native Artifact", true, Artifact).zeroOrOne(CoreAttributeTypes.Extension).zeroOrOne(CoreAttributeTypes.NativeContent));
    public static final ArtifactTypeToken GeneralDocument = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)14L, "General Document", false, NativeArtifact));
    public static final ArtifactTypeToken OseeApp = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)89L, "OSEE App", false, Artifact).zeroOrOne(CoreAttributeTypes.OseeAppDefinition));
    public static final ArtifactTypeToken OseeTypeDefinition = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)60L, "Osee Type Definition", false, Artifact).exactlyOne(CoreAttributeTypes.Active, Boolean.TRUE).any(CoreAttributeTypes.UriGeneralStringData));
    public static final ArtifactTypeToken OseeTypeEnum = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5447805027409642344L, "Osee Type Enum", false, EnumeratedArtifact).any(CoreAttributeTypes.IdValue));
    public static final ArtifactTypeToken PlainText = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)784L, "Plain Text", false, Artifact).zeroOrOne(CoreAttributeTypes.ParagraphNumber).zeroOrOne(CoreAttributeTypes.PlainTextContent));
    public static final ArtifactTypeToken AcronymPlainText = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5034328852220100337L, "Acronym Plain Text", false, PlainText).zeroOrOne(CoreAttributeTypes.Acronym).any(CoreAttributeTypes.DoorsId));
    public static final ArtifactTypeToken ImplementationDetailsPlainText = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)638269899L, "Implementation Details Plain Text", false, PlainText, AbstractImplementationDetails));
    public static final ArtifactTypeToken PlainTextDataRights = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)4527862492986312222L, "Plain Text With Data Rights", false, PlainText).zeroOrOne(CoreAttributeTypes.DataRightsBasis).any(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId).zeroOrOne(CoreAttributeTypes.PageOrientation, CoreAttributeTypes.PageOrientation.Portrait));
    public static final ArtifactTypeToken ReferenceDocument = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2084059074565751746L, "Reference Document", false, GeneralDocument).any(CoreAttributeTypes.DoorsId));
    public static final ArtifactTypeToken RendererTemplateWholeWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)9L, "Renderer Template - Whole Word", false, MsWordWholeDocument).exactlyOne(CoreAttributeTypes.RendererOptions, "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"*\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}").any(CoreAttributeTypes.TemplateMatchCriteria).exactlyOne(CoreAttributeTypes.PublishingTemplateDataRightsConfigurationNameReference));
    public static final ArtifactTypeToken ReportTemplate = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)63228787744062L, "Report Template", false, Artifact).zeroOrOne(CoreAttributeTypes.JavaCode));
    public static final ArtifactTypeToken Requirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)21L, "Requirement", false, Artifact).zeroOrOne(CoreAttributeTypes.DataRightsBasis).any(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified).zeroOrOne(CoreAttributeTypes.SubjectMatterExpert).zeroOrOne(CoreAttributeTypes.MarkdownContent).zeroOrOne(CoreAttributeTypes.Extension));
    public static final ArtifactTypeToken AbstractSpecRequirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)58551193202327573L, "Abstract Spec Requirement", false, Requirement).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId).any(CoreAttributeTypes.DoorsModId).zeroOrOne(CoreAttributeTypes.LegacyDal, CoreAttributeTypes.LegacyDal.Unspecified).zeroOrOne(CoreAttributeTypes.LegacyId).zeroOrOne(CoreAttributeTypes.PotentialSecurityImpact).atLeastOne(CoreAttributeTypes.QualificationMethod, CoreAttributeTypes.QualificationMethod.Unspecified).zeroOrOne(CoreAttributeTypes.SafetyImpact).zeroOrOne(CoreAttributeTypes.SafetySeverity, CoreAttributeTypes.SafetySeverity.Unspecified).zeroOrOne(CoreAttributeTypes.SoftwareControlCategory, CoreAttributeTypes.SoftwareControlCategory.Unspecified).zeroOrOne(CoreAttributeTypes.SoftwareControlCategoryRationale).zeroOrOne(CoreAttributeTypes.SwCI).exactlyOne(CoreAttributeTypes.Subsystem, CoreAttributeTypes.Subsystem.Unspecified).zeroOrOne(CoreAttributeTypes.TechnicalPerformanceParameter).computed(CoreAttributeTypes.SoftwareCriticalityIndex));
    public static final ArtifactTypeToken AbstractSoftwareRequirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)23L, "Abstract Software Requirement", true, AbstractSpecRequirement).any(CoreAttributeTypes.CSCI, CoreAttributeTypes.CSCI.Unspecified).zeroOrOne(CoreAttributeTypes.Category).atLeastOne(CoreAttributeTypes.Partition, CoreAttributeTypes.Partition.Unspecified));
    public static final ArtifactTypeToken AbstractSubsystemRequirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)797L, "Abstract Subsystem Requirement", true, AbstractSpecRequirement).zeroOrOne(CoreAttributeTypes.Effectivity, "Unspecified").exactlyOne(CoreAttributeTypes.IDAL, CoreAttributeTypes.IDAL.Unspecified).zeroOrOne(CoreAttributeTypes.IdalRationale).zeroOrOne(CoreAttributeTypes.LegacyId).atLeastOne(CoreAttributeTypes.VerificationEvent, CoreAttributeTypes.VerificationEvent.Unspecified).zeroOrOne(CoreAttributeTypes.VerificationLevel, CoreAttributeTypes.VerificationLevel.Unspecified));
    public static final ArtifactTypeToken AbstractSystemRequirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)796L, "Abstract System Requirement", true, AbstractSpecRequirement).zeroOrOne(CoreAttributeTypes.Effectivity, "Unspecified").zeroOrOne(CoreAttributeTypes.IaPlan).zeroOrOne(CoreAttributeTypes.LegacyId).zeroOrOne(CoreAttributeTypes.VerificationAcceptanceCriteria).atLeastOne(CoreAttributeTypes.VerificationEvent, CoreAttributeTypes.VerificationEvent.Unspecified).zeroOrOne(CoreAttributeTypes.VerificationLevel, CoreAttributeTypes.VerificationLevel.Unspecified));
    public static final ArtifactTypeToken CustomerRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)809L, "Customer Requirement - MS Word", false, MsWordTemplate, AbstractSpecRequirement));
    public static final ArtifactTypeToken DirectSoftwareRequirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)22L, "Direct Software Requirement", true, AbstractSoftwareRequirement));
    public static final ArtifactTypeToken SoftwareRequirement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)22000000000L, "Software Requirement", false, DirectSoftwareRequirement).exactlyOne(CoreAttributeTypes.IDAL, CoreAttributeTypes.IDAL.Unspecified).zeroOrOne(CoreAttributeTypes.IaPlan).zeroOrOne(CoreAttributeTypes.IdalRationale).zeroOrOne(CoreAttributeTypes.SoftwareControlCategory, CoreAttributeTypes.SoftwareControlCategory.Unspecified).zeroOrOne(CoreAttributeTypes.SoftwareControlCategoryRationale));
    public static final ArtifactTypeToken SoftwareRequirementMarkdown = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3525883482323L, "Software Requirement - Markdown", false, SoftwareRequirement, Markdown));
    public static final ArtifactTypeToken HardwareRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)33L, "Hardware Requirement - MS Word", false, MsWordTemplate, AbstractSpecRequirement));
    public static final ArtifactTypeToken InterfaceArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)54733032508193943L, "Interface Artifact", true, Artifact));
    public static final ArtifactTypeToken InterfaceNode = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6039606571486514295L, "Interface Node", false, InterfaceArtifact).zeroOrOne(CoreAttributeTypes.InterfaceNodeAddress).exactlyOne(CoreAttributeTypes.InterfaceNodeNumber).zeroOrOne(CoreAttributeTypes.InterfaceNodeGroupId).zeroOrOne(CoreAttributeTypes.NameAbbrev).zeroOrOne(CoreAttributeTypes.InterfaceNodeCodeGenName).zeroOrOne(CoreAttributeTypes.InterfaceNodeType).zeroOrOne(CoreAttributeTypes.InterfaceNodeBackgroundColor).zeroOrOne(CoreAttributeTypes.InterfaceNodeCodeGen).zeroOrOne(CoreAttributeTypes.InterfaceNodeBuildCodeGen).zeroOrOne(CoreAttributeTypes.InterfaceNodeToolUse).zeroOrOne(CoreAttributeTypes.Notes));
    public static final ArtifactTypeToken InterfaceConnection = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)126164394421696910L, "Interface Connection", false, InterfaceArtifact).exactlyOne(CoreAttributeTypes.InterfaceTransportType));
    public static final ArtifactTypeToken InterfaceMessage = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2455059983007225775L, "Interface Message", false, InterfaceArtifact).exactlyOne(CoreAttributeTypes.InterfaceMessageNumber).exactlyOne(CoreAttributeTypes.InterfaceMessagePeriodicity).zeroOrOne(CoreAttributeTypes.InterfaceMessageRate).exactlyOne(CoreAttributeTypes.InterfaceMessageWriteAccess).exactlyOne(CoreAttributeTypes.InterfaceMessageType).zeroOrOne(CoreAttributeTypes.InterfaceMessageExclude).zeroOrOne(CoreAttributeTypes.InterfaceMessageIoMode).zeroOrOne(CoreAttributeTypes.InterfaceMessageModeCode).zeroOrOne(CoreAttributeTypes.InterfaceMessageRateVer).zeroOrOne(CoreAttributeTypes.InterfaceMessagePriority).zeroOrOne(CoreAttributeTypes.InterfaceMessageProtocol).zeroOrOne(CoreAttributeTypes.InterfaceMessageRptWordCount).zeroOrOne(CoreAttributeTypes.InterfaceMessageRptCmdWord).zeroOrOne(CoreAttributeTypes.InterfaceMessageRunBeforeProc).zeroOrOne(CoreAttributeTypes.InterfaceMessageVer));
    public static final ArtifactTypeToken InterfaceSubMessage = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)126164394421696908L, "Interface SubMessage", false, InterfaceArtifact).exactlyOne(CoreAttributeTypes.InterfaceSubMessageNumber));
    public static final ArtifactTypeToken InterfaceStructure = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2455059983007225776L, "Interface Structure", false, InterfaceArtifact).zeroOrOne(CoreAttributeTypes.NameAbbrev).zeroOrOne(CoreAttributeTypes.InterfaceStructureCategory).zeroOrOne(CoreAttributeTypes.InterfaceMinSimultaneity).zeroOrOne(CoreAttributeTypes.InterfaceMaxSimultaneity).zeroOrOne(CoreAttributeTypes.InterfaceTaskFileType).zeroOrOne(CoreAttributeTypes.GeneralStringData));
    public static final ArtifactTypeToken InterfaceDataElement = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2455059983007225765L, "Interface DataElement", false, InterfaceArtifact).zeroOrOne(CoreAttributeTypes.InterfaceDefaultValue).zeroOrOne(CoreAttributeTypes.InterfaceElementAlterable).zeroOrOne(CoreAttributeTypes.Notes).zeroOrOne(CoreAttributeTypes.InterfaceElementEnumLiteral).zeroOrOne(CoreAttributeTypes.InterfaceElementIndexStart).zeroOrOne(CoreAttributeTypes.InterfaceElementIndexEnd));
    public static final ArtifactTypeToken InterfaceDataElementArray = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6360154518785980502L, "Interface DataElement Array", false, InterfaceDataElement));
    public static final ArtifactTypeToken InterfacePlatformType = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6360154518785980503L, "Interface Platform Type", false, InterfaceArtifact).exactlyOne(CoreAttributeTypes.InterfaceLogicalType).exactlyOne(CoreAttributeTypes.InterfacePlatformTypeBitSize).exactlyOne(CoreAttributeTypes.InterfacePlatformType2sComplement).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeMinval).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeMaxval).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeUnits).zeroOrOne(CoreAttributeTypes.InterfaceDefaultValue).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeMsbValue).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeBitsResolution).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeCompRate).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeAnalogAccuracy).zeroOrOne(CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription));
    public static final ArtifactTypeToken InterfaceEnum = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2455059983007225793L, "Interface Enumeration", false, InterfaceArtifact).exactlyOne(CoreAttributeTypes.InterfaceEnumOrdinal).exactlyOne(CoreAttributeTypes.InterfaceEnumOrdinalType));
    public static final ArtifactTypeToken InterfaceEnumSet = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2455059983007225791L, "Interface Enumeration Set", false, InterfaceArtifact));
    public static final ArtifactTypeToken InterfaceRate = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2434833974449324686L, "Interface Transmission Rate", false, InterfaceArtifact));
    public static final ArtifactTypeToken InterfaceUnit = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)8314622128828217343L, "Interface Unit", false, InterfaceArtifact));
    public static final ArtifactTypeToken InterfaceMessageTypeEnum = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)8893121862470164649L, "Interface Message Type Enum", false, InterfaceArtifact));
    public static final ArtifactTypeToken CrossReference = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5198407772394384771L, "Cross Reference", false, Artifact).exactlyOne(CoreAttributeTypes.CrossReferenceValue).zeroOrOne(CoreAttributeTypes.CrossReferenceArrayValues).zeroOrOne(CoreAttributeTypes.CrossReferenceAdditionalContent));
    public static final ArtifactTypeToken TransportType = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6663383168705248989L, "Transport Type", false, Artifact).exactlyOne(CoreAttributeTypes.ByteAlignValidation).zeroOrOne(CoreAttributeTypes.ByteAlignValidationSize).exactlyOne(CoreAttributeTypes.MessageGeneration).zeroOrOne(CoreAttributeTypes.MessageGenerationType).any(CoreAttributeTypes.MessageGenerationPosition).zeroOrOne(CoreAttributeTypes.MinimumSubscriberMultiplicity).zeroOrOne(CoreAttributeTypes.MaximumSubscriberMultiplicity).zeroOrOne(CoreAttributeTypes.MinimumPublisherMultiplicity).zeroOrOne(CoreAttributeTypes.MaximumPublisherMultiplicity).zeroOrOne(CoreAttributeTypes.InterfaceLevelsToUse).zeroOrOne(CoreAttributeTypes.AvailableMessageHeaders).zeroOrOne(CoreAttributeTypes.AvailableSubmessageHeaders).zeroOrOne(CoreAttributeTypes.AvailableStructureHeaders).zeroOrOne(CoreAttributeTypes.AvailableElementHeaders).zeroOrOne(CoreAttributeTypes.DashedPresentation));
    public static final ArtifactTypeToken IndirectSoftwareRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)25L, "Indirect Software Requirement - MS Word", false, MsWordTemplate, AbstractSoftwareRequirement));
    public static final ArtifactTypeToken InterfaceRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)32L, "Interface Requirement - MS Word", false, MsWordTemplate, AbstractSpecRequirement).exactlyOne(CoreAttributeTypes.Component, CoreAttributeTypes.Component.Unspecified));
    public static final ArtifactTypeToken HelpPage = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5728426866732962911L, "Help Page", false, Artifact).exactlyOne(CoreAttributeTypes.MarkdownContent).exactlyOne(CoreAttributeTypes.ApplicationName).exactlyOne(CoreAttributeTypes.IsHelpPageHeader).exactlyOne(CoreAttributeTypes.IsTrainingPage));
    public static final ArtifactTypeToken OseeReport = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3379299200905896452L, "OSEE Report", false, Artifact).exactlyOne(CoreAttributeTypes.HttpMethod).exactlyOne(CoreAttributeTypes.FileExtension).exactlyOne(CoreAttributeTypes.FileNamePrefix).exactlyOne(CoreAttributeTypes.ProducesMediaType).exactlyOne(CoreAttributeTypes.DiffAvailable).exactlyOne(CoreAttributeTypes.EndpointUrl));
    public static final ArtifactTypeToken MimReport = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)1112907634879895453L, "MIM Report", false, OseeReport));
    public static final ArtifactTypeToken MimImport = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2807814791345263165L, "MIM Import", false, Artifact).zeroOrOne(CoreAttributeTypes.ImportTransportType).exactlyOne(CoreAttributeTypes.EndpointUrl).exactlyOne(CoreAttributeTypes.ConnectionRequired));
    public static final ArtifactTypeToken DiffReportEndPoint = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)8247460208362207697L, "DIFF Report End Point", false, Artifact).exactlyOne(CoreAttributeTypes.EndpointUrl));
    public static final ArtifactTypeToken ProductType = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)7274800616985881194L, "Product Type", false, Artifact));
    public static final ArtifactTypeToken RootArtifact = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)10L, "Root Artifact", false, Artifact));
    public static final ArtifactTypeToken SafetyAssessment = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)59L, "Safety Assessment", false, Artifact).zeroOrOne(CoreAttributeTypes.ParagraphNumber).zeroOrOne(CoreAttributeTypes.SFHA));
    public static final ArtifactTypeToken SoftwareDesignMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)45L, "Software Design - MS Word", false, DesignMsWord));
    public static final ArtifactTypeToken SoftwareRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)24L, "Software Requirement - MS Word", false, MsWordTemplate, SoftwareRequirement));
    public static final ArtifactTypeToken SoftwareRequirementDataDefinitionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)793L, "Software Requirement Data Definition - MS Word", false, IndirectSoftwareRequirementMsWord));
    public static final ArtifactTypeToken SoftwareRequirementDrawingMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)29L, "Software Requirement Drawing - MS Word", false, IndirectSoftwareRequirementMsWord));
    public static final ArtifactTypeToken SoftwareRequirementFunctionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)28L, "Software Requirement Function - MS Word", false, IndirectSoftwareRequirementMsWord));
    public static final ArtifactTypeToken SoftwareRequirementHtml = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)42L, "Software Requirement - HTML", false, AbstractSoftwareRequirement, HtmlArtifact));
    public static final ArtifactTypeToken SoftwareRequirementPlainText = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)792L, "Software Requirement Plain Text", false, PlainText, DirectSoftwareRequirement));
    public static final ArtifactTypeToken SoftwareRequirementProcedureMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)27L, "Software Requirement Procedure - MS Word", false, IndirectSoftwareRequirementMsWord));
    public static final ArtifactTypeToken SubsystemDesignMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)43L, "Subsystem Design - MS Word", false, DesignMsWord).exactlyOne(CoreAttributeTypes.Subsystem, CoreAttributeTypes.Subsystem.Unspecified));
    public static final ArtifactTypeToken SubsystemFunctionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)36L, "Subsystem Function - MS Word", false, FunctionMsWord, SubsystemDesignMsWord));
    public static final ArtifactTypeToken SubsystemRequirementMarkdown = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2257709917691903205L, "Subsystem Requirement - Markdown", false, AbstractSubsystemRequirement, Markdown));
    public static final ArtifactTypeToken SubsystemRequirementHtml = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)795L, "Subsystem Requirement - HTML", false, AbstractSubsystemRequirement, HtmlArtifact));
    public static final ArtifactTypeToken SubsystemRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)31L, "Subsystem Requirement - MS Word", false, MsWordTemplate, AbstractSubsystemRequirement).zeroOrOne(CoreAttributeTypes.Hazard));
    public static final ArtifactTypeToken SupportDocumentMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)13L, "Support Document - MS Word", false, MsWordTemplate).zeroOrOne(CoreAttributeTypes.DataRightsBasis).zeroOrOne(CoreAttributeTypes.DataRightsClassification, CoreAttributeTypes.DataRightsClassification.Unspecified));
    public static final ArtifactTypeToken SystemDesignMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)44L, "System Design - MS Word", false, DesignMsWord));
    public static final ArtifactTypeToken SystemFunctionMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)35L, "System Function - MS Word", false, FunctionMsWord, SystemDesignMsWord).zeroOrOne(CoreAttributeTypes.FunctionalCategory));
    public static final ArtifactTypeToken SystemRequirementMarkdown = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)4135720862433165231L, "System Requirement - Markdown", false, AbstractSystemRequirement, Markdown));
    public static final ArtifactTypeToken SystemRequirementHtml = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)794L, "System Requirement - HTML", false, AbstractSystemRequirement, HtmlArtifact));
    public static final ArtifactTypeToken SystemRequirementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)30L, "System Requirement - MS Word", false, MsWordTemplate, AbstractSystemRequirement).zeroOrOne(CoreAttributeTypes.Hazard));
    public static final ArtifactTypeToken TestPlanElementMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)37L, "Test Plan Element - MS Word", false, MsWordTemplate));
    public static final ArtifactTypeToken TestResultNative = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)39L, "Test Result Native", false, NativeArtifact, AbstractTestResult));
    public static final ArtifactTypeToken TestResultWholeWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)40L, "Test Result - Whole Word", false, MsWordWholeDocument, AbstractTestResult));
    public static final ArtifactTypeToken TestUnit = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)4L, "Test Unit", true, Artifact));
    public static final ArtifactTypeToken IntegrationTestProcedureMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)443398723457743215L, "Integration Test Procedure - MS Word", false, MsWordTemplate, TestUnit).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId));
    public static final ArtifactTypeToken SoftwareTestProcedurePlainText = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)564397212436322878L, "Software Test Procedure Plain Text", false, PlainText, TestUnit).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId));
    public static final ArtifactTypeToken IntegrationTestProcedureWholeWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)443398723457743216L, "Integration Test Procedure - Whole Word", false, MsWordWholeDocument, TestUnit).zeroOrOne(CoreAttributeTypes.DoorsHierarchy).any(CoreAttributeTypes.DoorsId));
    public static final ArtifactTypeToken TestCase = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)82L, "Test Case", false, TestUnit));
    public static final ArtifactTypeToken TestInformationSheetMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)41L, "Test Information Sheet - MS Word", false, MsWordTemplate, TestUnit).exactlyOne(CoreAttributeTypes.TisTestCategory, CoreAttributeTypes.TisTestCategory.DEV).zeroOrOne(CoreAttributeTypes.TisTestNumber).atLeastOne(CoreAttributeTypes.TisTestType, CoreAttributeTypes.TisTestType.StationaryVehicle));
    public static final ArtifactTypeToken TestProcedure = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)46L, "Test Procedure", false, TestUnit).exactlyOne(CoreAttributeTypes.Subsystem, CoreAttributeTypes.Subsystem.Unspecified).zeroOrOne(CoreAttributeTypes.TestProcedureStatus, CoreAttributeTypes.TestProcedureStatus.NotPerformed));
    public static final ArtifactTypeToken TestProcedureMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)2349L, "Test Procedure - MS Word", false, MsWordTemplate, TestProcedure));
    public static final ArtifactTypeToken TestProcedureNative = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)48L, "Test Procedure Native", false, NativeArtifact, TestProcedure));
    public static final ArtifactTypeToken TestProcedureWholeWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)47L, "Test Procedure - Whole Word", false, MsWordWholeDocument, TestProcedure));
    public static final ArtifactTypeToken TestSupport = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)83L, "Test Support", false, TestUnit));
    public static final ArtifactTypeToken UniversalGroup = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)8L, "Universal Group", false, GroupArtifact));
    public static final ArtifactTypeToken Url = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)15L, "Url", false, Artifact));
    public static final ArtifactTypeToken SupportingContent = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)49L, "Supporting Content", false, Url));
    public static final ArtifactTypeToken User = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5L, "User", false, Artifact).exactlyOne(CoreAttributeTypes.Active, Boolean.TRUE).any(CoreAttributeTypes.AtsActionSearch).any(CoreAttributeTypes.AtsUserConfig).zeroOrOne(CoreAttributeTypes.City).zeroOrOne(CoreAttributeTypes.Company).zeroOrOne(CoreAttributeTypes.CompanyTitle).zeroOrOne(CoreAttributeTypes.Country).zeroOrOne(CoreAttributeTypes.Dictionary).zeroOrOne(CoreAttributeTypes.Email).any(CoreAttributeTypes.FavoriteBranch).zeroOrOne(CoreAttributeTypes.FaxPhone).zeroOrOne(CoreAttributeTypes.MobilePhone).any(CoreAttributeTypes.LoginId).any(CoreAttributeTypes.Notes).zeroOrOne(CoreAttributeTypes.Phone).zeroOrOne(CoreAttributeTypes.State).zeroOrOne(CoreAttributeTypes.Street).zeroOrOne(CoreAttributeTypes.UserId).zeroOrOne(CoreAttributeTypes.UserSettings).zeroOrOne(CoreAttributeTypes.WebPreferences).zeroOrOne(CoreAttributeTypes.Website).any(CoreAttributeTypes.XViewerCustomization).any(CoreAttributeTypes.XViewerDefaults).zeroOrOne(CoreAttributeTypes.Zip).any(CoreAttributeTypes.MimBranchPreferences).any(CoreAttributeTypes.MimColumnPreferences));
    public static final ArtifactTypeToken UserGroup = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)7L, "User Group", false, AbstractAccessControlled, GroupArtifact).zeroOrOne(CoreAttributeTypes.DefaultGroup).any(CoreAttributeTypes.Email));
    public static final ArtifactTypeToken MimUserGlobalPreferences = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5935321910901176667L, "MIM User Global Preferences", false, Artifact).exactlyOne(CoreAttributeTypes.MimSettingWordWrap));
    public static final ArtifactTypeToken SoftwareTestProcedureWholeWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)554486323432951757L, "Software Test Procedure - Whole Word", false, MsWordWholeDocument, TestUnit).any(CoreAttributeTypes.DoorsId).zeroOrOne(CoreAttributeTypes.DoorsHierarchy));
    public static final ArtifactTypeToken SoftwareTestProcedureMsWord = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)554486323432951758L, "Software Test Procedure - MS Word", false, MsWordTemplate, TestUnit).any(CoreAttributeTypes.DoorsId).zeroOrOne(CoreAttributeTypes.DoorsHierarchy));
    public static final ArtifactTypeToken SubscriptionGroup = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6753071794573299176L, "Subscription Group", false, UserGroup));
    public static final ArtifactTypeToken WorkItemDefinition = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)50L, "Work Item Definition", true, Artifact).any(CoreAttributeTypes.WorkData).zeroOrOne(CoreAttributeTypes.WorkDescription).zeroOrOne(CoreAttributeTypes.WorkId).zeroOrOne(CoreAttributeTypes.WorkParentId).zeroOrOne(CoreAttributeTypes.WorkType));
    public static final ArtifactTypeToken WorkFlowDefinition = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)52L, "Work Flow Definition", false, WorkItemDefinition).zeroOrOne(CoreAttributeTypes.StartPage).any(CoreAttributeTypes.WorkTransition));
    public static final ArtifactTypeToken XViewerGlobalCustomization = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)55L, "XViewer Global Customization", false, Artifact).any(CoreAttributeTypes.XViewerCustomization));
    public static final ArtifactTypeToken Context = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3962411134691320126L, "Context", false, Artifact).zeroOrOne(CoreAttributeTypes.Description, "", "A context hint that will be visible in the UI"));
    public static final ArtifactTypeToken Command = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3605711044364389729L, "Command", false, Artifact).exactlyOne(CoreAttributeTypes.CustomCommand, Boolean.valueOf(false), "This is a custom command").zeroOrOne(CoreAttributeTypes.Description, "", "A description of the command").zeroOrOne(CoreAttributeTypes.ContentUrl, "", "A Rest Call endpoint to call to execute templated with parameters").zeroOrOne(CoreAttributeTypes.HttpMethod, CoreAttributeTypes.HttpMethod.Get, "HTTP method for request"));
    public static final ArtifactTypeToken ExecutedCommand = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3605721345366379123L, "ExecutedCommand", false, Artifact).exactlyOne(CoreAttributeTypes.ExecutionFrequency, Integer.valueOf(0), "Frequency of parameterized command execution").exactlyOne(CoreAttributeTypes.CommandTimestamp, AttributeTypeToken.DEFAULT_DATE, "The timestamp of the last execution of this command").exactlyOne(CoreAttributeTypes.ParameterizedCommand, "", "The JSON representation of the command with its parameterized attributes/values").exactlyOne(CoreAttributeTypes.Favorite, Boolean.valueOf(false), "Is executed command a favorite").exactlyOne(CoreAttributeTypes.IsValidated, Boolean.valueOf(true), "Flags if the executed command was valid or not"));
    public static final ArtifactTypeToken ExecutedCommandHistory = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3102324341367389724L, "ExecutedCommand History", false, Artifact));
    public static final ArtifactTypeToken Parameter = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)5334063606392099440L, "Parameter", true, Artifact).zeroOrOne(CoreAttributeTypes.DefaultValue).zeroOrOne(CoreAttributeTypes.Description, "", "A description of valid parameter inputs").zeroOrOne(CoreAttributeTypes.UseValidator, Boolean.valueOf(false), "Is a validator used for this parameter").zeroOrOne(CoreAttributeTypes.ValidatorType, "", "Type of validator"));
    public static final ArtifactTypeToken ParameterInteger = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)3007766441141267760L, "ParameterInteger", false, Parameter));
    public static final ArtifactTypeToken ParameterBranch = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)4683538775178036503L, "ParameterBranch", false, Parameter));
    public static final ArtifactTypeToken ParameterBoolean = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)9092244262700990331L, "ParameterBoolean", false, Parameter));
    public static final ArtifactTypeToken ParameterString = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)6057500041616318960L, "ParameterString", false, Parameter));
    public static final ArtifactTypeToken ParameterSingleSelect = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)9154803029373920500L, "ParameterSingleSelect", false, Parameter));
    public static final ArtifactTypeToken ParameterMultipleSelect = CoreTypeTokenProvider.osee.add(CoreTypeTokenProvider.osee.artifactType((Long)1937883426323978299L, "ParameterMultipleSelect", false, Parameter));
}

