/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.templatemanager;

import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osee.define.api.publishing.templatemanager.InvalidWordMlTemplateException;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateKeyType;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateScalarKey;
import org.eclipse.osee.define.api.publishing.templatemanager.PublishingTemplateVectorKey;
import org.eclipse.osee.define.operations.publishing.templatemanager.PublishingTemplateInternal;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.publishing.InvalidRendererOptionsException;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.RendererOptions;
import org.eclipse.osee.framework.core.publishing.TemplateContent;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.xml.sax.SAXParseException;

class ArtifactPublishingTemplate
implements PublishingTemplateInternal {
    private final EnumMap<PublishingTemplateKeyType, Iterable<PublishingTemplateScalarKey>> keyExtractors;
    private final ArtifactReadable artifactReadable;
    private final PublishingTemplateScalarKey identifier;
    private final PublishingTemplateScalarKey name;
    private final RendererOptions rendererOptions;
    private final TemplateContent templateContent;
    private final PublishingTemplateVectorKey matchCriteria;
    private final PublishingTemplateScalarKey safeName;

    ArtifactPublishingTemplate(ArtifactReadable artifactReadable) {
        this.artifactReadable = Objects.requireNonNull(artifactReadable, "ArtifactPublishingTemplate::new, parameter \"artifactReadable\" cannot be null.");
        String styles = null;
        try {
            List templateRelatedArtifacts = this.artifactReadable.getRelated(CoreRelationTypes.SupportingInfo_SupportingInfo).getList();
            styles = templateRelatedArtifacts.size() == 1 ? ((ArtifactReadable)templateRelatedArtifacts.get(0)).getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent) : null;
        }
        catch (Exception exception2) {
            styles = null;
        }
        this.keyExtractors = new EnumMap(PublishingTemplateKeyType.class);
        this.keyExtractors.put(PublishingTemplateKeyType.IDENTIFIER, this.getIdentifierKeyExtractor());
        this.keyExtractors.put(PublishingTemplateKeyType.MATCH_CRITERIA, this.getMatchCriteriaKeyExtractor());
        this.keyExtractors.put(PublishingTemplateKeyType.NAME, this.getNameKeyExtractor());
        this.keyExtractors.put(PublishingTemplateKeyType.SAFE_NAME, this.getSafeNameKeyExtractor());
        this.identifier = new PublishingTemplateScalarKey("AT-" + this.artifactReadable.getIdString(), PublishingTemplateKeyType.IDENTIFIER);
        this.matchCriteria = this.buildTemplateMatchCriteriaList();
        this.name = new PublishingTemplateScalarKey(this.artifactReadable.getName(), PublishingTemplateKeyType.NAME);
        this.safeName = new PublishingTemplateScalarKey(this.artifactReadable.getSafeName(), PublishingTemplateKeyType.SAFE_NAME);
        try {
            this.rendererOptions = RendererOptions.create((String)this.artifactReadable.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.RendererOptions));
        }
        catch (InvalidRendererOptionsException e) {
            e.setPublishingTemplateInformation(this.identifier.getKey(), this.name.getKey());
            throw e;
        }
        CharSequence templateXml = this.artifactReadable.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent);
        if (Objects.nonNull(styles)) {
            templateXml = WordCoreUtil.replaceStyles((CharSequence)templateXml, (CharSequence)styles);
        }
        this.templateContent = new TemplateContent(templateXml);
        Optional documentOptional = this.templateContent.getTemplateXml();
        if (documentOptional.isEmpty()) {
            String message = this.templateContent.getTemplateXmlParseError().map(exception -> exception instanceof SAXParseException ? new Message().title((CharSequence)"Template Word ML XML parsing failed.").indentInc().title((CharSequence)exception.getMessage()).indentInc().segment((CharSequence)"LineNumber", (Object)((SAXParseException)exception).getLineNumber()).segment((CharSequence)"Column Number", (Object)((SAXParseException)exception).getColumnNumber()).toString() : exception.getMessage()).orElse("Template Word ML XML parsing failed.");
            throw new InvalidWordMlTemplateException(this.identifier.getKey(), this.name.getKey(), message, templateXml.toString());
        }
    }

    private PublishingTemplateVectorKey buildTemplateMatchCriteriaList() {
        try {
            List matchCriteriaObjectList = this.artifactReadable.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria);
            List matchCriteriaList = matchCriteriaObjectList.stream().map(matchCriteria -> new PublishingTemplateScalarKey(matchCriteria.toString(), PublishingTemplateKeyType.MATCH_CRITERIA)).collect(Collectors.toUnmodifiableList());
            return new PublishingTemplateVectorKey(matchCriteriaList);
        }
        catch (Exception exception) {
            return new PublishingTemplateVectorKey(List.of());
        }
    }

    @Override
    public PublishingTemplate getBean() {
        return new PublishingTemplate(this.identifier.getKey(), this.name.getKey(), this.rendererOptions, this.templateContent);
    }

    @Override
    public PublishingTemplateScalarKey getIdentifier() {
        return this.identifier;
    }

    @Override
    public Iterable<PublishingTemplateScalarKey> getKeyIterable(PublishingTemplateKeyType keyType) {
        return this.keyExtractors.get(keyType);
    }

    @Override
    public PublishingTemplateScalarKey getName() {
        return this.name;
    }

    @Override
    public RendererOptions getRendererOptions() {
        return this.rendererOptions;
    }

    @Override
    public PublishingTemplateScalarKey getSafeName() {
        return this.safeName;
    }

    @Override
    public TemplateContent getTemplateContent() {
        return this.templateContent;
    }

    @Override
    public PublishingTemplateVectorKey getMatchCriteria() {
        return this.matchCriteria;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"ArtifactPublishingTemplate").indentInc().segment((CharSequence)"Class", (Object)this.getClass().getSimpleName()).segment((CharSequence)"Artifact Readable", (Object)this.artifactReadable).segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).segment((CharSequence)"Template Match Criteria", (Object)this.matchCriteria).toMessage((ToMessage)this.rendererOptions).toMessage((ToMessage)this.templateContent);
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

