/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class TransportType
extends PLGenericDBObject {
    public static final TransportType SENTINEL = new TransportType();
    private boolean byteAlignValidation;
    private boolean messageGeneration;
    private int byteAlignValidationSize;
    private String messageGenerationType;
    private String messageGenerationPosition;
    private int minimumSubscriberMultiplicity = 0;
    private int maximumSubscriberMultiplicity = 0;
    private int minimumPublisherMultiplicity = 0;
    private int maximumPublisherMultiplicity = 0;
    private boolean isDashed = false;
    private List<String> interfaceLevelsToUse = new LinkedList<String>();
    private List<String> availableMessageHeaders = new LinkedList<String>();
    private List<String> availableSubmessageHeaders = new LinkedList<String>();
    private List<String> availableStructureHeaders = new LinkedList<String>();
    private List<String> availableElementHeaders = new LinkedList<String>();
    private ApplicabilityToken applicability;

    public TransportType(ArtifactToken art) {
        super(art);
    }

    public TransportType(ArtifactReadable art) {
        super(art);
        if (art.isValid()) {
            this.setByteAlignValidation((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ByteAlignValidation, (Object)false));
            this.setMessageGeneration((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MessageGeneration, (Object)false));
            this.setByteAlignValidationSize(this.isByteAlignValidation() ? (Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ByteAlignValidationSize, (Object)0) : 0);
            this.setMessageGenerationType(this.isMessageGeneration() ? (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MessageGenerationType, (Object)"") : "");
            this.setMessageGenerationPosition(this.isMessageGeneration() ? (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MessageGenerationPosition, (Object)"") : "");
            String minSubMultiplicity = art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.MinimumSubscriberMultiplicity, "");
            String maxSubMultiplicity = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MaximumSubscriberMultiplicity, (Object)"");
            String minPubMultiplicity = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MinimumPublisherMultiplicity, (Object)"");
            String maxPubMultiplicity = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MaximumPublisherMultiplicity, (Object)"");
            if (Strings.isNumeric((String)minSubMultiplicity)) {
                this.setMinimumSubscriberMultiplicity(Integer.valueOf(minSubMultiplicity));
            } else {
                this.setMinimumSubscriberMultiplicity(0);
            }
            if (Strings.isNumeric((String)maxSubMultiplicity)) {
                this.setMaximumSubscriberMultiplicity(Integer.valueOf(maxSubMultiplicity));
            } else {
                this.setMaximumSubscriberMultiplicity(0);
            }
            if (Strings.isNumeric((String)minPubMultiplicity)) {
                this.setMinimumPublisherMultiplicity(Integer.valueOf(minPubMultiplicity));
            } else {
                this.setMinimumPublisherMultiplicity(0);
            }
            if (Strings.isNumeric((String)maxPubMultiplicity)) {
                this.setMaximumPublisherMultiplicity(Integer.valueOf(maxPubMultiplicity));
            } else {
                this.setMaximumPublisherMultiplicity(0);
            }
            this.setInterfaceLevelsToUse(this.getJSONContents((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceLevelsToUse, (Object)"[]")));
            this.setAvailableMessageHeaders(this.getJSONContents((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.AvailableMessageHeaders, (Object)"[]")));
            this.setAvailableSubmessageHeaders(this.getJSONContents((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.AvailableSubmessageHeaders, (Object)"[]")));
            this.setAvailableStructureHeaders(this.getJSONContents((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.AvailableStructureHeaders, (Object)"[]")));
            this.setAvailableElementHeaders(this.getJSONContents((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.AvailableElementHeaders, (Object)"[]")));
            this.setDashedPresentation((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DashedPresentation, (Object)false));
            this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        } else {
            this.setByteAlignValidation(false);
            this.setMessageGeneration(false);
            this.setByteAlignValidationSize(0);
            this.setMessageGenerationType("");
            this.setMessageGenerationPosition("");
            this.setMinimumPublisherMultiplicity(0);
            this.setMinimumSubscriberMultiplicity(0);
            this.setMaximumPublisherMultiplicity(0);
            this.setMaximumSubscriberMultiplicity(0);
            this.setDashedPresentation(false);
            this.setApplicability(ApplicabilityToken.SENTINEL);
        }
    }

    public TransportType(Long id, String name) {
        super(id, name);
    }

    public TransportType() {
    }

    public String getMessageGenerationType() {
        return this.messageGenerationType;
    }

    public void setMessageGenerationType(String messageGenerationType) {
        this.messageGenerationType = messageGenerationType;
    }

    public String getMessageGenerationPosition() {
        return this.messageGenerationPosition;
    }

    public void setMessageGenerationPosition(String messageGenerationPosition) {
        this.messageGenerationPosition = messageGenerationPosition;
    }

    public int getByteAlignValidationSize() {
        return this.byteAlignValidationSize;
    }

    public void setByteAlignValidationSize(int byteAlignValidationSize) {
        this.byteAlignValidationSize = byteAlignValidationSize;
    }

    public boolean isMessageGeneration() {
        return this.messageGeneration;
    }

    public void setMessageGeneration(boolean messageGeneration) {
        this.messageGeneration = messageGeneration;
    }

    public boolean isByteAlignValidation() {
        return this.byteAlignValidation;
    }

    public void setByteAlignValidation(boolean byteAlignValidation) {
        this.byteAlignValidation = byteAlignValidation;
    }

    public int getMinimumSubscriberMultiplicity() {
        return this.minimumSubscriberMultiplicity;
    }

    public void setMinimumSubscriberMultiplicity(int minimumSubscriberMultiplicity) {
        this.minimumSubscriberMultiplicity = minimumSubscriberMultiplicity;
    }

    public int getMaximumSubscriberMultiplicity() {
        return this.maximumSubscriberMultiplicity;
    }

    public void setMaximumSubscriberMultiplicity(int maximumSubscriberMultiplicity) {
        this.maximumSubscriberMultiplicity = maximumSubscriberMultiplicity;
    }

    public int getMinimumPublisherMultiplicity() {
        return this.minimumPublisherMultiplicity;
    }

    public void setMinimumPublisherMultiplicity(int minimumPublisherMultiplicity) {
        this.minimumPublisherMultiplicity = minimumPublisherMultiplicity;
    }

    public int getMaximumPublisherMultiplicity() {
        return this.maximumPublisherMultiplicity;
    }

    public void setMaximumPublisherMultiplicity(int maximumPublisherMultiplicity) {
        this.maximumPublisherMultiplicity = maximumPublisherMultiplicity;
    }

    public List<String> getInterfaceLevelsToUse() {
        return this.interfaceLevelsToUse;
    }

    public void setInterfaceLevelsToUse(List<String> interfaceLevelsToUse) {
        this.interfaceLevelsToUse = interfaceLevelsToUse;
    }

    public List<String> getAvailableMessageHeaders() {
        return this.availableMessageHeaders;
    }

    public void setAvailableMessageHeaders(List<String> availableMessageHeaders) {
        this.availableMessageHeaders = availableMessageHeaders;
    }

    public List<String> getAvailableSubmessageHeaders() {
        return this.availableSubmessageHeaders;
    }

    public void setAvailableSubmessageHeaders(List<String> availableSubmessageHeaders) {
        this.availableSubmessageHeaders = availableSubmessageHeaders;
    }

    public List<String> getAvailableStructureHeaders() {
        return this.availableStructureHeaders;
    }

    public void setAvailableStructureHeaders(List<String> availableStructureHeaders) {
        this.availableStructureHeaders = availableStructureHeaders;
    }

    public List<String> getAvailableElementHeaders() {
        return this.availableElementHeaders;
    }

    public void setAvailableElementHeaders(List<String> availableElementHeaders) {
        this.availableElementHeaders = availableElementHeaders;
    }

    public boolean isDirectConnection() {
        return this.getMinimumPublisherMultiplicity() == 1 && this.getMaximumPublisherMultiplicity() == 1 && this.getMinimumSubscriberMultiplicity() == 1 && this.getMaximumSubscriberMultiplicity() == 1;
    }

    @JsonIgnore
    private List<String> getJSONContents(String jsonToParse) {
        String innerString = jsonToParse.substring(jsonToParse.indexOf("[") + 1, jsonToParse.indexOf("]"));
        List<String> innerStrings = Arrays.asList(innerString.split(","));
        return innerStrings.stream().filter(s -> !s.isEmpty()).map(s -> s.replaceAll("'", "")).collect(Collectors.toList());
    }

    public boolean getDashedPresentation() {
        return this.isDashed;
    }

    public void setDashedPresentation(boolean isDashed) {
        this.isDashed = isDashed;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }
}

