/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.mim.types.InterfaceEnumOrdinalType;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class InterfaceEnumeration
extends PLGenericDBObject {
    public static final InterfaceEnumeration SENTINEL = new InterfaceEnumeration();
    private ApplicabilityToken applicability = ApplicabilityToken.SENTINEL;
    private Long ordinal = 0L;
    private InterfaceEnumOrdinalType ordinalType;
    private ArtifactReadable artifactReadable = ArtifactReadable.SENTINEL;

    public InterfaceEnumeration(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceEnumeration(ArtifactReadable art) {
        super(art);
        this.setOrdinal((Long)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal, (Object)0L));
        this.setOrdinalType(InterfaceEnumOrdinalType.valueOf(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinalType, "LONG")));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        this.artifactReadable = art;
    }

    public InterfaceEnumeration(Long id, String name) {
        super(id, name);
    }

    public InterfaceEnumeration() {
        this(Id.SENTINEL, "");
    }

    @JsonIgnore
    public String getFormattedOrdinal() {
        if (InterfaceEnumOrdinalType.HEX.equals((Object)this.getOrdinalType())) {
            return "0x" + Long.toHexString(this.getOrdinal()).toUpperCase();
        }
        return this.getOrdinal().toString();
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public Long getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Long ordinal) {
        this.ordinal = ordinal;
    }

    public InterfaceEnumOrdinalType getOrdinalType() {
        return this.ordinalType;
    }

    public void setOrdinalType(InterfaceEnumOrdinalType ordinalType) {
        this.ordinalType = ordinalType;
    }

    @JsonIgnore
    public ArtifactReadable getArtifactReadable() {
        return this.artifactReadable;
    }

    public String toString() {
        return String.valueOf(this.getFormattedOrdinal()) + " = " + this.getName();
    }
}

