/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.publishing;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.HasArtifactType;
import org.eclipse.osee.framework.core.publishing.WordMLProducer;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;

public class PublishingArtifactError {
    private final List<Object> things;
    private final String errorDescription;

    public <T extends Id> PublishingArtifactError(T thing, String errorDescription) {
        this.things = List.of(thing);
        this.errorDescription = errorDescription;
    }

    public <T extends Id> PublishingArtifactError(List<T> things, String errorDescription) {
        this.things = List.of(things);
        this.errorDescription = errorDescription;
    }

    public void publish(StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder, "PublishingArtifactError::publish, parameter \"stringBuilder\" cannot be null.");
        String indent1 = IndentedString.indentString((int)1);
        String indent2 = IndentedString.indentString((int)2);
        stringBuilder.append(indent1).append("Error: ").append("\n").append(indent2).append(this.errorDescription).append("\n");
        for (Object thing : this.things) {
            String identifier = ((Id)thing).getId().toString();
            String name = thing instanceof NamedId ? ((NamedId)thing).getName() : "(no name information)";
            String artifactTypeName = thing instanceof HasArtifactType ? ((HasArtifactType)thing).getArtifactType().getName() : "(no type information)";
            stringBuilder.append(indent1).append("Artifact:").append("\n").append(indent2).append("Identifier: ").append(identifier).append("\n").append(indent2).append("Name:       ").append(name).append("\n").append(indent2).append("Type:       ").append(artifactTypeName).append("\n");
        }
    }

    public void publish(WordMLProducer WordMLProducer2) {
        Objects.requireNonNull(WordMLProducer2, "PublishingArtifactError::publish, parameter \"WordMLProducer\" cannot be null.");
        String thingIdentifiers = this.things.stream().map(thing -> ((Id)thing).getId().toString()).collect(Collectors.joining("\n"));
        String thingNames = this.things.stream().map(thing -> thing instanceof NamedId ? ((NamedId)thing).getName() : "(no name information)").collect(Collectors.joining("\n"));
        String thingArtifactTypes = this.things.stream().map(thing -> thing instanceof HasArtifactType ? ((HasArtifactType)thing).getArtifactType().getName() : "(no type information)").collect(Collectors.joining("\n"));
        WordMLProducer2.addErrorRow((CharSequence)thingIdentifiers, (CharSequence)thingNames, (CharSequence)thingArtifactTypes, (CharSequence)this.errorDescription);
    }
}

