/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.KeyValueStore;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.data.ArtifactReadableImpl;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ApplicabilityDsQueryImpl;
import org.eclipse.osee.orcs.db.internal.search.engines.Attribute;
import org.eclipse.osee.orcs.db.internal.search.engines.ObjectQueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.TupleQueryImpl;
import org.eclipse.osee.orcs.db.internal.sql.SelectiveArtifactSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.ArtifactTable;
import org.eclipse.osee.orcs.search.ArtifactTableOptions;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;

public class QueryEngineImpl
implements QueryEngine {
    private static final int DefaultArtifactNum = 500;
    private static final int DefaultMapCapacity = 667;
    private final ObjectQueryCallableFactory artifactQueryEngineFactory;
    private final QuerySqlContextFactory branchSqlContextFactory;
    private final QuerySqlContextFactory txSqlContextFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory sqlJoinFactory;
    private final SqlObjectLoader sqlObjectLoader;
    private final KeyValueStore keyValue;
    private final SqlHandlerFactory handlerFactory;
    private final OrcsTokenService tokenService;
    private final IResourceManager resourceManager;

    public QueryEngineImpl(ObjectQueryCallableFactory artifactQueryEngineFactory, QuerySqlContextFactory branchSqlContextFactory, QuerySqlContextFactory txSqlContextFactory, JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory, SqlHandlerFactory handlerFactory, SqlObjectLoader sqlObjectLoader, OrcsTokenService tokenService, KeyValueStore keyValue, IResourceManager resourceManager) {
        this.artifactQueryEngineFactory = artifactQueryEngineFactory;
        this.branchSqlContextFactory = branchSqlContextFactory;
        this.txSqlContextFactory = txSqlContextFactory;
        this.jdbcClient = jdbcClient;
        this.sqlJoinFactory = sqlJoinFactory;
        this.sqlObjectLoader = sqlObjectLoader;
        this.tokenService = tokenService;
        this.keyValue = keyValue;
        this.handlerFactory = handlerFactory;
        this.resourceManager = resourceManager;
    }

    public int getArtifactCount(QueryData queryData) {
        if (this.isPostProcessRequired(queryData)) {
            return this.artifactQueryEngineFactory.getArtifactCount(queryData);
        }
        QueryData rootQueryData = queryData.getRootQueryData();
        return new SelectiveArtifactSqlWriter(this.sqlJoinFactory, this.jdbcClient, rootQueryData).getCount(this.handlerFactory);
    }

    private boolean isPostProcessRequired(QueryData queryData) {
        return queryData.hasCriteriaType(CriteriaAttributeKeywords.class);
    }

    public void runArtifactQuery(QueryData queryData, LoadDataHandler handler) {
        try {
            try {
                this.artifactQueryEngineFactory.createQuery(null, queryData, handler).call();
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
                queryData.reset();
            }
        }
        finally {
            queryData.reset();
        }
    }

    public int getBranchCount(QueryData queryData) {
        return this.getCount(this.branchSqlContextFactory, queryData);
    }

    public void runBranchQuery(QueryData queryData, List<? super Branch> branches) {
        QuerySqlContext queryContext = this.branchSqlContextFactory.createQueryContext(null, queryData, QueryType.SELECT);
        this.sqlObjectLoader.loadBranches(branches, queryContext);
        queryData.reset();
    }

    public int getTxCount(QueryData queryData) {
        return this.getCount(this.txSqlContextFactory, queryData);
    }

    private int getCount(QuerySqlContextFactory sqlContextFactory, QueryData queryData) {
        QuerySqlContext queryContext = sqlContextFactory.createQueryContext(null, queryData, QueryType.COUNT);
        int count = this.sqlObjectLoader.getCount(queryContext);
        queryData.reset();
        return count;
    }

    public void runTxQuery(UserService userService, QueryData queryData, List<? super TransactionReadable> txs) {
        QuerySqlContext queryContext = this.txSqlContextFactory.createQueryContext(null, queryData, QueryType.SELECT);
        this.sqlObjectLoader.loadTransactions(userService, txs, queryContext);
        queryData.reset();
    }

    public TupleQuery createTupleQuery() {
        return new TupleQueryImpl(this.jdbcClient, this.sqlJoinFactory, this.keyValue, this.tokenService);
    }

    public List<ArtifactToken> asArtifactTokens(QueryData queryData) {
        ArrayList<ArtifactToken> tokens = new ArrayList<ArtifactToken>(100);
        this.selectiveArtifactLoad(queryData, 500, stmt -> {
            boolean bl = tokens.add(ArtifactToken.valueOf((long)stmt.getLong("art_id"), (String)stmt.getString("value"), (BranchToken)queryData.getBranch(), (ArtifactTypeToken)this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id")))));
        });
        return tokens;
    }

    public Map<ArtifactId, ArtifactReadable> asArtifactMap(QueryData queryData, QueryFactory queryFactory) {
        HashMap<ArtifactId, ArtifactReadable> artifacts = new HashMap<ArtifactId, ArtifactReadable>(667);
        this.loadArtifactsInto(queryData, queryFactory, a -> {
            ArtifactReadable artifactReadable = artifacts.put((ArtifactId)a, (ArtifactReadable)a);
        }, 500);
        return artifacts;
    }

    public List<ArtifactReadable> asArtifacts(QueryData queryData, QueryFactory queryFactory) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>(500);
        this.loadArtifactsInto(queryData, queryFactory, a -> {
            boolean bl = artifacts.add((ArtifactReadable)a);
        }, 500);
        return artifacts;
    }

    public List<ArtifactReadable> asArtifact(QueryData queryData, QueryFactory queryFactory) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>(1);
        this.loadArtifactsInto(queryData, queryFactory, a -> {
            boolean bl = artifacts.add((ArtifactReadable)a);
        }, 1);
        return artifacts;
    }

    private void loadArtifactsInto(QueryData queryData, QueryFactory queryFactory, Consumer<ArtifactReadable> artifactConsumer, int numArtifacts) {
        HashMap artifactMap = new HashMap((int)((double)numArtifacts / 0.75) + 1);
        Consumer<JdbcStatement> jdbcConsumer = stmt -> {
            Long artId = stmt.getLong("art_id");
            ArtifactReadableImpl artifact = (ArtifactReadableImpl)artifactMap.get(ArtifactId.valueOf((Long)artId));
            if (artifact == null) {
                artifact = this.createArtifact((JdbcStatement)stmt, artId, stmt.getLong("art_type_id"), queryData, queryFactory);
                artifactMap.put(artifact, artifact);
                if (stmt.getLong("top") == 1L) {
                    artifactConsumer.accept((ArtifactReadable)artifact);
                }
            } else {
                Long applicId = stmt.getLong("app_id");
                ((ArtifactReadable)artifactMap.get(ArtifactId.valueOf((Long)artId))).getApplicabilityToken().setId(applicId);
                if (OptionsUtil.getIncludeApplicabilityTokens((Options)queryData.getRootQueryData().getOptions())) {
                    String applicValue = stmt.getString("app_value");
                    ((ArtifactReadable)artifactMap.get(ArtifactId.valueOf((Long)artId))).getApplicabilityToken().setName(applicValue);
                }
            }
            Long typeId = stmt.getLong("type_id");
            Long otherArtId = stmt.getLong("other_art_id");
            String value = stmt.getString("value");
            String uri = stmt.getString("uri");
            if (otherArtId == 0L) {
                AttributeTypeGeneric attributeType = this.tokenService.getAttributeTypeOrCreate(typeId);
                Attribute attribute = new Attribute(stmt.getLong("attr_id"), attributeType, value, uri, this.resourceManager);
                if (queryData.hasCriteriaType(CriteriaRelationTypeFollow.class)) {
                    if (artifact.getSoleAttributeId((AttributeTypeToken)attributeType, Long.valueOf(-1L)) == -1L) {
                        artifact.putAttributeValue(attributeType, attribute);
                    }
                } else {
                    artifact.putAttributeValue(attributeType, attribute);
                }
            } else {
                Long otherArtType = stmt.getLong("other_art_type_id");
                RelationSide side = value.equals("A") ? RelationSide.SIDE_A : RelationSide.SIDE_B;
                ArtifactReadableImpl otherArtifact = (ArtifactReadableImpl)artifactMap.get(ArtifactId.valueOf((Long)otherArtId));
                if (otherArtifact == null) {
                    otherArtifact = this.createArtifact((JdbcStatement)stmt, otherArtId, otherArtType, queryData, queryFactory);
                    artifactMap.put(otherArtifact, otherArtifact);
                }
                artifact.putRelation(this.tokenService.getRelationTypeOrCreate(typeId), side, (ArtifactReadable)otherArtifact);
            }
        };
        this.selectiveArtifactLoad(queryData, numArtifacts, jdbcConsumer);
    }

    private ArtifactReadableImpl createArtifact(JdbcStatement stmt, Long artId, Long artifactTypeId, QueryData queryData, QueryFactory queryFactory) {
        TransactionId txId = TransactionId.valueOf((Long)stmt.getLong("transaction_id"));
        ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
        ArtifactTypeToken artifactType = this.tokenService.getArtifactTypeOrCreate(artifactTypeId);
        String appValue = "";
        if (queryData.mainTableAliasExists(OseeDb.OSEE_KEY_VALUE_TABLE)) {
            appValue = stmt.getString("app_value");
        }
        ApplicabilityToken applic = ApplicabilityToken.valueOf((long)stmt.getLong("app_id"), (String)appValue);
        return new ArtifactReadableImpl(artId, artifactType, queryData.getBranch(), queryData.getView(), applic, txId, modType, queryFactory);
    }

    public List<Map<String, Object>> asArtifactMaps(QueryData queryData) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(500);
        HashCollection attributes = new HashCollection();
        Long[] artifactId = new Long[]{Id.SENTINEL};
        Long[] applicability = new Long[]{Id.SENTINEL};
        ArtifactTypeToken[] artifactType = new ArtifactTypeToken[]{ArtifactTypeToken.SENTINEL};
        Consumer<JdbcStatement> consumer = stmt -> {
            Long newArtId = stmt.getLong("art_id");
            if (artifactId[0].equals(Id.SENTINEL)) {
                longArray[0] = newArtId;
                longArray2[0] = stmt.getLong("app_id");
                artifactTypeTokenArray[0] = this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id")));
            } else if (!artifactId[0].equals(newArtId)) {
                maps.add(this.createFieldMap(artifactType[0], artifactId[0], applicability[0], (HashCollection<AttributeTypeToken, Object>)attributes));
                attributes.clear();
                longArray[0] = newArtId;
                longArray2[0] = stmt.getLong("app_id");
                artifactTypeTokenArray[0] = this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id")));
            }
            attributes.put((Object)this.tokenService.getAttributeTypeOrCreate(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getString("value"));
        };
        this.selectiveArtifactLoad(queryData, 500, consumer);
        if (!artifactId[0].equals(Id.SENTINEL)) {
            maps.add(this.createFieldMap(artifactType[0], artifactId[0], applicability[0], (HashCollection<AttributeTypeToken, Object>)attributes));
        }
        return maps;
    }

    private Map<String, Object> createFieldMap(ArtifactTypeToken artifactType, Long artifactId, Long applicability, HashCollection<AttributeTypeToken, Object> attributes) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Name", attributes.getValues((Object)CoreAttributeTypes.Name));
        map.put("Artifact Type", artifactType.getIdString());
        map.put("Artifact Id", artifactId.toString());
        map.put("Applicability Id", applicability.toString());
        ArrayList attributeTypes = new ArrayList(attributes.keySet());
        Collections.sort(attributeTypes);
        for (AttributeTypeToken attributeType : attributeTypes) {
            List attributeValues = (List)attributes.getValues((Object)attributeType);
            if (attributeValues.size() == 1) {
                map.put(attributeType.getName(), attributeValues.get(0));
                continue;
            }
            map.put(attributeType.getName(), attributeValues);
        }
        return map;
    }

    public Map<ArtifactId, ArtifactToken> asArtifactTokenMap(QueryData queryData) {
        HashMap<ArtifactId, ArtifactToken> tokens = new HashMap<ArtifactId, ArtifactToken>(667);
        Consumer<JdbcStatement> consumer = stmt -> {
            ArtifactToken token = ArtifactToken.valueOf((long)stmt.getLong("art_id"), (String)stmt.getString("value"), (BranchToken)queryData.getBranch(), (ArtifactTypeToken)this.tokenService.getArtifactTypeOrCreate(Long.valueOf(stmt.getLong("art_type_id"))));
            tokens.put((ArtifactId)token, token);
        };
        this.selectiveArtifactLoad(queryData, 500, consumer);
        return tokens;
    }

    public List<ArtifactId> asArtifactIds(QueryData queryData) {
        final ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>(500);
        if (this.isPostProcessRequired(queryData)) {
            LoadDataHandlerAdapter handler = new LoadDataHandlerAdapter(){

                public void onData(ArtifactData data) {
                    ids.add(data);
                }
            };
            OptionsUtil.setLoadLevel((Options)queryData.getOptions(), (LoadLevel)LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA);
            try {
                this.runArtifactQuery(queryData, (LoadDataHandler)handler);
                return ids;
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.selectiveArtifactLoad(queryData, 500, stmt -> {
            boolean bl = ids.add(ArtifactId.valueOf((Long)stmt.getLong("art_id")));
        });
        return ids;
    }

    private void selectiveArtifactLoad(QueryData queryData, int numArtifacts, Consumer<JdbcStatement> consumer) {
        QueryData rootQueryData = queryData.getRootQueryData();
        new SelectiveArtifactSqlWriter(this.sqlJoinFactory, this.jdbcClient, rootQueryData).runSql(consumer, this.handlerFactory, numArtifacts);
    }

    public ApplicabilityDsQuery createApplicabilityDsQuery() {
        return new ApplicabilityDsQueryImpl(this.jdbcClient, this.sqlJoinFactory);
    }

    public boolean isArchived(BranchId branchId) {
        String SELECT_IS_BRANCH_ARCHIVED = "select archived from osee_branch where branch_id = ?";
        Integer result = (Integer)this.jdbcClient.fetchOrException(Integer.class, () -> new OseeCoreException("Failed to get Branch archived state for %s", new Object[]{branchId}), SELECT_IS_BRANCH_ARCHIVED, new Object[]{branchId});
        return BranchArchivedState.valueOf((int)result).isArchived();
    }

    public void getBranchCategoryGammaIds(Consumer<GammaId> consumer, BranchId branchId, BranchCategoryToken category) {
        String SELECT_BRANCH_CATEGORY_GAMMA = "SELECT gamma_id FROM osee_branch_category WHERE branch_id=? AND category = ?";
        this.jdbcClient.runQuery(stmt -> consumer.accept(GammaId.valueOf((Long)stmt.getLong("gamma_id"))), SELECT_BRANCH_CATEGORY_GAMMA, new Object[]{branchId, category});
    }

    public void getBranchCategories(Consumer<BranchCategoryToken> consumer, BranchId branchId) {
        this.jdbcClient.runQuery(stmt -> consumer.accept(BranchCategoryToken.valueOf((Long)stmt.getLong("category"))), OseeSql.GET_CURRENT_BRANCH_CATEGORIES.getSql(), new Object[]{branchId});
    }

    public ArtifactTable asArtifactsTable(QueryData queryData, QueryFactory queryFactory) {
        ArrayList artifacts = new ArrayList(500);
        this.loadArtifactsInto(queryData, queryFactory, a -> {
            boolean bl = artifacts.add(a);
        }, 500);
        int fixedColumnNum = 3;
        ArtifactTableOptions tableOptions = queryData.getTableoptions();
        List attributeColumns = tableOptions.getAttributeColumns();
        String[][] data = new String[artifacts.size()][attributeColumns.size() + fixedColumnNum];
        if (attributeColumns.isEmpty()) {
            HashSet columnMap = new HashSet();
            for (ArtifactReadable artifact : artifacts) {
                columnMap.addAll(artifact.getArtifactType().getValidAttributeTypes());
            }
            attributeColumns.addAll(columnMap);
            Collections.sort(attributeColumns);
        }
        int i = 0;
        while (i < artifacts.size()) {
            ArtifactReadable artifact;
            artifact = (ArtifactReadable)artifacts.get(i);
            data[i][0] = artifact.getIdString();
            data[i][1] = artifact.getArtifactType().getName();
            data[i][2] = artifact.getApplicability().getIdString();
            int j = fixedColumnNum;
            while (j < data[i].length) {
                data[i][j] = artifact.getAttributeValuesAsString((AttributeTypeToken)attributeColumns.get(j - fixedColumnNum));
                ++j;
            }
            ++i;
        }
        return new ArtifactTable(tableOptions, data);
    }
}

