/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.api.synchronization.ExportRequest;
import org.eclipse.osee.define.api.synchronization.ImportMapping;
import org.eclipse.osee.define.api.synchronization.ImportRequest;
import org.eclipse.osee.define.api.synchronization.Root;
import org.eclipse.osee.define.api.synchronization.SynchronizationOperations;
import org.eclipse.osee.define.operations.synchronization.Direction;
import org.eclipse.osee.define.operations.synchronization.IsSynchronizationArtifactBuilder;
import org.eclipse.osee.define.operations.synchronization.RootList;
import org.eclipse.osee.define.operations.synchronization.SynchronizationArtifact;
import org.eclipse.osee.define.operations.synchronization.SynchronizationArtifactBuilder;
import org.eclipse.osee.define.operations.synchronization.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.define.util.OsgiUtils;
import org.eclipse.osee.define.util.Validation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.orcs.OrcsApi;

public class SynchronizationOperationsImpl
implements SynchronizationOperations {
    private static SynchronizationOperationsImpl synchronizationOperationsImpl = null;
    private final OrcsApi orcsApi;
    private Map<String, Class<SynchronizationArtifactBuilder>> synchronizationArtifactBuilderClassMap;

    private SynchronizationOperationsImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.synchronizationArtifactBuilderClassMap = null;
    }

    public static synchronized SynchronizationOperationsImpl create(OrcsApi orcsApi) {
        return Objects.isNull(synchronizationOperationsImpl) ? (synchronizationOperationsImpl = new SynchronizationOperationsImpl(Objects.requireNonNull(orcsApi))) : synchronizationOperationsImpl;
    }

    private static String buildExceptionMessage(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return new StringBuilder(2048).append("\n").append("<---S-E-R-V-E-R---E-X-C-E-P-T-I-O-N--->").append("\n").append(e.getMessage()).append("\n").append(stringWriter.toString()).append("\n").toString();
    }

    private void findSynchronizationArtifactBuilders() {
        this.synchronizationArtifactBuilderClassMap = OsgiUtils.findImplementations("org/eclipse/osee/define/operations/synchronization", IsSynchronizationArtifactBuilder.class, "artifactType", SynchronizationArtifactBuilder.class);
    }

    public SynchronizationArtifactBuilder getSynchronizationArtifactBuilder(String artifactType) throws UnknownSynchronizationArtifactTypeException {
        if (Objects.isNull(this.synchronizationArtifactBuilderClassMap)) {
            this.findSynchronizationArtifactBuilders();
        }
        try {
            return this.synchronizationArtifactBuilderClassMap.get(artifactType).getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            throw new UnknownSynchronizationArtifactTypeException(artifactType, e);
        }
    }

    public InputStream exporter(ExportRequest exportRequest) {
        Root[] rootsArray;
        Message message = null;
        if (Objects.nonNull(message = Validation.verifyParameter(exportRequest, "exportRequest", message, "is invalid", p -> !p.isValid()))) {
            throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "exporter", message));
        }
        String synchronizationArtifactType = exportRequest.getSynchronizationArtifactType();
        SynchronizationArtifactBuilder synchronizationArtifactBuilder = this.getSynchronizationArtifactBuilder(synchronizationArtifactType);
        RootList rootList = RootList.create(this.orcsApi, Direction.EXPORT, synchronizationArtifactBuilder);
        Root[] rootArray = rootsArray = exportRequest.getRoots();
        int n = rootsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Root root = rootArray[n2];
            rootList.add(root);
            ++n2;
        }
        rootList.validate();
        Throwable throwable = null;
        Object var8_11 = null;
        try (SynchronizationArtifact synchronizationArtifact = SynchronizationArtifact.create(rootList);){
            synchronizationArtifact.build();
            return synchronizationArtifact.serialize();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void importer(ImportRequest importRequest, InputStream inputStream) {
        boolean complete = false;
        try {
            Message message = null;
            message = Validation.verifyParameter(importRequest, "importRequest", message, "is invalid", p -> !p.isValid());
            message = Validation.verifyParameter(inputStream, "inputStream", message);
            if (Objects.nonNull(message)) {
                throw new IllegalArgumentException(Validation.buildIllegalArgumentExceptionMessage(this.getClass().getSimpleName(), "importer", message));
            }
            String synchronizationArtifactType = importRequest.getSynchronizationArtifactType();
            SynchronizationArtifactBuilder synchronizationArtifactBuilder = this.getSynchronizationArtifactBuilder(synchronizationArtifactType);
            ImportMapping[] importMappingsArray = importRequest.getImportMappings();
            RootList rootList = RootList.create(this.orcsApi, Direction.IMPORT, synchronizationArtifactBuilder);
            ImportMapping[] importMappingArray = importMappingsArray;
            int n = importMappingsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportMapping importMapping = importMappingArray[n2];
                rootList.add(importMapping.getRoot());
                ++n2;
            }
            rootList.validate();
            Throwable throwable = null;
            Object var10_13 = null;
            try (SynchronizationArtifact synchronizationArtifact = SynchronizationArtifact.create(rootList);){
                synchronizationArtifact.deserialize(inputStream);
                synchronizationArtifact.buildForeign();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            complete = true;
        }
        finally {
            block21: {
                if (Objects.nonNull(inputStream)) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        if (!complete) break block21;
                        throw new OseeCoreException("SynchronizationOperationsImpl::importer, failed to close \"inputStream\".", (Throwable)e);
                    }
                }
            }
        }
    }
}

