/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNote;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteType;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteXml;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteXmlType;
import org.eclipse.osee.ats.rest.internal.convert.AbstractConvertGuidToId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConvertStateNotesFromXmlToJson
extends AbstractConvertGuidToId {
    public static final String LOG_ITEM_TAG = "Item";
    public static final String ATS_NOTE_TAG = "AtsNote";
    private XResultData rd;
    private boolean reportOnly;

    public ConvertStateNotesFromXmlToJson(Log logger, JdbcClient jdbcClient, OrcsApi orcsApi, AtsApi atsApi) {
        super(logger, jdbcClient, orcsApi, atsApi);
    }

    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        this.rd = rd;
        this.reportOnly = reportOnly;
        if (reportOnly) {
            rd.log("REPORT ONLY - Changes not persisted\n");
        }
        IAtsChangeSet changes = atsApi.createChangeSet(this.getName());
        int numChanges = 0;
        Collection workItems = atsApi.getQueryService().getWorkItemsAtrTypeExists((AttributeTypeToken)AtsAttributeTypes.StateNotes);
        rd.logf("Found %s attributes\n\n", new Object[]{workItems.size()});
        StringBuilder sb = new StringBuilder();
        for (IAtsWorkItem workItem : workItems) {
            sb.append(workItem.getIdString());
            sb.append(",");
            Collection attributes = atsApi.getAttributeResolver().getAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes);
            for (IAttribute stateNoteAttr : attributes) {
                String stateNoteVal = (String)stateNoteAttr.getValue();
                if (!((String)stateNoteAttr.getValue()).startsWith("<")) continue;
                rd.logf("Need to convert xml state notes for %s value %s\n", new Object[]{workItem.getAtsId(), stateNoteVal});
                ++numChanges;
                List<AtsStateNoteXml> xmlNotes = this.getNoteItems(workItem, stateNoteVal);
                this.convertToJsonAndStore(workItem, xmlNotes, (IAttribute<Object>)stateNoteAttr, changes);
            }
        }
        rd.log("\nWorkItems: " + sb.toString() + "\n");
        if (reportOnly) {
            rd.log("\n" + numChanges + " Need to be Changed");
        } else {
            rd.log("\n" + numChanges + " Changes Persisted");
            changes.executeIfNeeded();
        }
    }

    private List<AtsStateNote> convertToJsonAndStore(IAtsWorkItem workItem, List<AtsStateNoteXml> xmlNotes, IAttribute<Object> stateNoteAttr, IAtsChangeSet changes) {
        ArrayList<AtsStateNote> notes = new ArrayList<AtsStateNote>();
        for (AtsStateNoteXml xNote : xmlNotes) {
            try {
                AtsStateNoteXmlType oldType = xNote.getType();
                AtsStateNoteType newType = AtsStateNoteType.Other;
                if (oldType == AtsStateNoteXmlType.Comment || oldType == AtsStateNoteXmlType.Question) {
                    newType = AtsStateNoteType.Info;
                } else if (oldType == AtsStateNoteXmlType.Error) {
                    newType = AtsStateNoteType.Problem;
                }
                AtsStateNote note = new AtsStateNote(newType.name(), xNote.getState(), String.valueOf(xNote.getDate().getTime()), (UserId)xNote.getUser(), xNote.getMsg());
                if (this.reportOnly) {
                    this.rd.logf("--- Needed Note: [%s]\n", new Object[]{note.toString()});
                    continue;
                }
                String json = this.atsApi.jaxRsApi().toJson((Object)note);
                changes.addAttribute((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.StateNotes, (Object)json);
                this.rd.logf("--- Converted to Note: [%s]\n", new Object[]{note.toString()});
            }
            catch (Exception ex) {
                this.rd.errorf("Exception converting %s", new Object[]{ex.getLocalizedMessage()});
            }
        }
        if (!this.reportOnly) {
            changes.deleteAttribute(workItem, stateNoteAttr);
        }
        return notes;
    }

    public List<AtsStateNoteXml> getNoteItems(IAtsWorkItem workItem, String stateNoteXml) {
        try {
            if (Strings.isValid((String)stateNoteXml)) {
                return ConvertStateNotesFromXmlToJson.fromXml(stateNoteXml, "id", this.atsApi);
            }
        }
        catch (Exception ex) {
            this.atsApi.getLogger().error((Throwable)ex, "Error extracting note", new Object[0]);
        }
        return Collections.emptyList();
    }

    public static List<AtsStateNoteXml> fromXml(String xml, String atsId, AtsApi atsApi) {
        ArrayList<AtsStateNoteXml> logItems;
        block5: {
            logItems = new ArrayList<AtsStateNoteXml>();
            try {
                if (!Strings.isValid((String)xml)) break block5;
                NodeList nodes = Jaxp.readXmlDocument((String)xml).getElementsByTagName(LOG_ITEM_TAG);
                int i = 0;
                while (i < nodes.getLength()) {
                    AtsStateNoteXml item;
                    Element element = (Element)nodes.item(i);
                    try {
                        UserToken user = atsApi.userService().getUserByUserId(element.getAttribute("userId"));
                        item = new AtsStateNoteXml(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), user, element.getAttribute("msg"));
                        logItems.add(item);
                    }
                    catch (UserNotInDatabase ex) {
                        atsApi.getLogger().error((Throwable)ex, "Error parsing notes for [%s]", new Object[]{atsId});
                        item = new AtsStateNoteXml(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), SystemUser.OseeSystem, element.getAttribute("msg"));
                        logItems.add(item);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                atsApi.getLogger().error((Throwable)ex, "Error reading AtsNote", new Object[0]);
            }
        }
        return logItems;
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("ConvertStateNotesFromXmlToJson (required conversion)\n\n");
        data.append("Necessary for upgrading from OSEE 0.65 to 0.66\n");
        data.append("Items not converted will remain but not show in ATS UI\n");
        data.append("- Converts ats.State Note attr that stores 1..n notes in single xml attr to attrs that stores one json note per attr.\n");
        data.append("NOTE: This operation can be run multiple times\n");
        return data.toString();
    }

    public String getName() {
        return "Convert ats.State Notes From Xml To Json";
    }
}

