/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class Message {
    private static final String lineEnding = "\n";
    private static final int lineEndingSize = "\n".length();
    private String cachedResult = null;
    private int indent = 0;
    private final List<Line> lines = new LinkedList<Line>();

    private static CharSequence copy(CharSequence otherText) {
        if (Objects.isNull(otherText)) {
            return "";
        }
        if (otherText instanceof String) {
            return otherText;
        }
        return new StringBuilder(Message.newSize(otherText.length())).append(otherText);
    }

    private static int newSize(int textSize) {
        int newSize = textSize * 2;
        newSize = newSize < 256 ? 256 : newSize;
        return newSize;
    }

    private static String objectToString(Object object) {
        return Objects.nonNull(object) ? object.toString() : "(null)";
    }

    public Message append(CharSequence text) {
        this.cachedResult = null;
        int size = this.lines.size();
        if (size <= 0) {
            return this;
        }
        Line lastLine = this.lines.get(size - 1);
        if (LineType.TITLE.equals((Object)lastLine.getLineType())) {
            lastLine.appendTitle(text);
        }
        return this;
    }

    public Message blank() {
        this.cachedResult = null;
        this.lines.add(new Line());
        return this;
    }

    public Message block(CharSequence block) {
        this.cachedResult = null;
        this.lines.add(new Line(block));
        return this;
    }

    public Message copy(Message otherMessage) {
        this.cachedResult = null;
        otherMessage.lines.forEach(otherLine -> {
            Line line = new Line(this.indent, (Line)otherLine);
        });
        return this;
    }

    public Message indent(int indent) {
        this.indent = indent > 0 ? indent : 0;
        return this;
    }

    public Message indentDec() {
        this.indent = this.indent > 0 ? this.indent - 1 : 0;
        return this;
    }

    public Message indentInc() {
        ++this.indent;
        return this;
    }

    public boolean isEmpty() {
        return this.lines.size() == 0;
    }

    public <T> Message segment(CharSequence title, List<T> valueList) {
        return this.segment(title, (T)valueList, (Function<T, Object>)Function.identity());
    }

    public <T> Message segment(CharSequence title, List<T> valueList, Function<T, Object> valueExtractor) {
        this.cachedResult = null;
        String valueString = Objects.isNull(valueList) ? "(null)" : (valueList.isEmpty() ? "(empty)" : valueList.stream().map(valueExtractor).map(Message::objectToString).collect(Collectors.joining(", ", "[ ", " ]")));
        this.lines.add(new Line(this.indent, title, valueString));
        return this;
    }

    public <T> Message segment(CharSequence title, T value) {
        return this.segment(title, value, Function.identity());
    }

    public <T> Message segment(CharSequence title, T value, Function<T, Object> valueExtractor) {
        this.cachedResult = null;
        String valueString = Objects.isNull(value) ? "(null)" : Message.objectToString(valueExtractor.apply(value));
        this.lines.add(new Line(this.indent, title, valueString));
        return this;
    }

    public <T> Message segmentIndexedArray(CharSequence title, T[] valueArray) {
        return this.segmentIndexedArray(title, valueArray, t -> t);
    }

    public <T> Message segmentIndexedArray(CharSequence title, T[] valueArray, Function<T, Object> valueExtractor) {
        this.cachedResult = null;
        if (Objects.isNull(valueArray)) {
            this.lines.add(new Line(this.indent, title, "(null)"));
            return this;
        }
        if (valueArray.length <= 0) {
            this.lines.add(new Line(this.indent, title, "(empty)"));
            return this;
        }
        this.lines.add(new Line(this.indent++, title));
        int i = 0;
        StringBuilder listElementTitle = new StringBuilder();
        T[] TArray = valueArray;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            Object displayValue = valueExtractor.apply(value);
            listElementTitle.setLength(0);
            listElementTitle.append("[").append(i).append("]");
            if (value instanceof ToMessage) {
                this.lines.add(new Line(this.indent, listElementTitle));
                ((ToMessage)value).toMessage(this.indent + 1, this);
            } else {
                this.lines.add(new Line(this.indent, listElementTitle.toString(), Message.objectToString(displayValue)));
            }
            ++n2;
        }
        --this.indent;
        return this;
    }

    public <T> Message segmentIndexedList(CharSequence title, List<T> valueList) {
        return this.segmentIndexedList(title, valueList, t -> t);
    }

    public <T> Message segmentIndexedList(CharSequence title, List<T> valueList, Function<T, Object> valueExtractor) {
        this.cachedResult = null;
        if (Objects.isNull(valueList)) {
            this.lines.add(new Line(this.indent, title, "(null)"));
            return this;
        }
        if (valueList.isEmpty()) {
            this.lines.add(new Line(this.indent, title, "(empty)"));
            return this;
        }
        this.lines.add(new Line(this.indent++, title));
        int i = 0;
        StringBuilder listElementTitle = new StringBuilder();
        for (T value : valueList) {
            Object displayValue = valueExtractor.apply(value);
            listElementTitle.setLength(0);
            listElementTitle.append("[").append(i).append("]");
            if (value instanceof ToMessage) {
                this.lines.add(new Line(this.indent, listElementTitle));
                ((ToMessage)value).toMessage(this.indent + 1, this);
                continue;
            }
            this.lines.add(new Line(this.indent, listElementTitle.toString(), Message.objectToString(displayValue)));
        }
        --this.indent;
        return this;
    }

    public Message title(CharSequence title) {
        this.cachedResult = null;
        this.lines.add(new Line(this.indent, title));
        return this;
    }

    public Message toMessage(ToMessage value) {
        return value.toMessage(-1, this);
    }

    public String toString() {
        return Objects.nonNull(this.cachedResult) ? this.cachedResult : (this.cachedResult = this.toStringBuilder(null).toString());
    }

    public StringBuilder toStringBuilder(StringBuilder message) {
        int maxIndent = this.lines.stream().mapToInt(Line::getIndent).max().orElse(0);
        int[] indentColumnStartArray = new int[maxIndent + 1];
        this.lines.stream().filter(line -> LineType.SEGMENT.equals((Object)line.getLineType())).forEach(line -> {
            int titleLength;
            int indent = line.getIndent();
            int n = indentColumnStartArray[indent] > (titleLength = line.getSegmentTitleLength() + 2) ? indentColumnStartArray[indent] : titleLength;
            nArray[indent] = n;
        });
        int estimatedSize = this.lines.stream().mapToInt(line -> line.size(indentColumnStartArray)).sum();
        StringBuilder outMessage = Objects.nonNull(message) ? message : new StringBuilder(estimatedSize);
        this.lines.forEach(line -> line.append(outMessage, indentColumnStartArray));
        return outMessage;
    }

    private class Line {
        private final int indent;
        private final LineType lineType;
        private CharSequence title;
        private final CharSequence value;

        Line() {
            this.lineType = LineType.BLANK;
            this.indent = 0;
            this.title = "";
            this.value = "";
        }

        Line(CharSequence title) {
            this.lineType = LineType.BLOCK;
            this.indent = -1;
            this.title = Message.copy(title);
            this.value = "";
        }

        Line(int indent, CharSequence title) {
            this.lineType = LineType.TITLE;
            this.indent = indent;
            this.title = Message.copy(title);
            this.value = "";
        }

        Line(int indent, CharSequence title, CharSequence value) {
            this.lineType = LineType.SEGMENT;
            this.indent = indent;
            this.title = Message.copy(title);
            this.value = Message.copy(value);
        }

        Line(int indent, Line otherLine) {
            this.lineType = otherLine.lineType;
            this.indent = indent + (otherLine.indent >= 0 ? otherLine.indent : 0);
            this.title = Message.copy(otherLine.title);
            this.value = Message.copy(otherLine.value);
        }

        void append(StringBuilder message, int[] indentColumnStartArray) {
            switch (this.lineType) {
                case BLANK: {
                    message.append(Message.lineEnding);
                    return;
                }
                case BLOCK: {
                    message.append(this.getTitle()).append(Message.lineEnding);
                    return;
                }
                case SEGMENT: {
                    message.append(IndentedString.indentString(this.getIndent()));
                    message.append(this.getTitle()).append(": ");
                    int space = indentColumnStartArray[this.getIndent()] - this.title.length();
                    int i = 0;
                    while (i < space) {
                        message.append(" ");
                        ++i;
                    }
                    message.append(this.getValue()).append(Message.lineEnding);
                    return;
                }
                case TITLE: {
                    message.append(IndentedString.indentString(this.getIndent()));
                    message.append(this.getTitle()).append(Message.lineEnding);
                    return;
                }
            }
        }

        void appendTitle(CharSequence text) {
            switch (this.lineType) {
                case TITLE: {
                    if (Objects.isNull(this.title)) {
                        this.title = new StringBuilder(Message.newSize(text.length()));
                    } else if (this.title instanceof String) {
                        this.title = new StringBuilder(Message.newSize(this.title.length() + text.length())).append(this.title);
                    }
                    ((StringBuilder)this.title).append(text);
                }
            }
        }

        int getIndent() {
            return this.indent;
        }

        LineType getLineType() {
            return this.lineType;
        }

        int getSegmentTitleLength() {
            switch (this.lineType) {
                case SEGMENT: {
                    return this.title.length();
                }
            }
            return 0;
        }

        CharSequence getTitle() {
            assert (Objects.nonNull(this.title)) : "Message.Line::getTitle, member \"title\" is null.";
            return this.title;
        }

        CharSequence getValue() {
            return this.value;
        }

        int size(int[] indentColumnStartArray) {
            switch (this.lineType) {
                case BLANK: {
                    return lineEndingSize;
                }
                case BLOCK: {
                    return this.title.length() + lineEndingSize;
                }
                case SEGMENT: {
                    return IndentedString.indentSize() * this.getIndent() + indentColumnStartArray[this.getIndent()] + this.value.length() + lineEndingSize;
                }
                case TITLE: {
                    return IndentedString.indentSize() * this.getIndent() + this.title.length() + lineEndingSize;
                }
            }
            return 0;
        }
    }

    private static enum LineType {
        BLANK,
        BLOCK,
        SEGMENT,
        TITLE;

    }
}

