/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateColor;
import org.eclipse.osee.ats.api.workdef.StateOption;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.AbstractWorkDefItem;
import org.eclipse.osee.ats.api.workdef.model.DecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.PeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.RuleManager;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class StateDefinition
extends AbstractWorkDefItem
implements IStateToken {
    private StateType StateType;
    private int ordinal = 0;
    private List<LayoutItem> stateItems = new ArrayList<LayoutItem>(5);
    private final RuleManager ruleMgr = new RuleManager();
    private final List<StateDefinition> toStates = new ArrayList<StateDefinition>(5);
    private final List<IAtsDecisionReviewDefinition> decisionReviews = new ArrayList<IAtsDecisionReviewDefinition>();
    private final List<IAtsPeerReviewDefinition> peerReviews = new ArrayList<IAtsPeerReviewDefinition>();
    private WorkDefinition workDefinition;
    private int stateWeight = 0;
    private Integer recommendedPercentComplete = null;
    private StateColor color = null;
    private final List<IAtsTransitionHook> transitionListeners = new ArrayList<IAtsTransitionHook>();
    private final List<IAtsWorkItemHook> workItemListeners = new ArrayList<IAtsWorkItemHook>();
    private List<StateOption> stateOptions = new ArrayList<StateOption>();

    public StateDefinition(String name) {
        super(Long.valueOf(name.hashCode()), name);
    }

    public List<LayoutItem> getLayoutItems() {
        return this.stateItems;
    }

    @Override
    public StateType getStateType() {
        return this.StateType;
    }

    public void setLayoutItems(List<LayoutItem> layoutToSet) {
        this.stateItems = layoutToSet;
    }

    public void setStateType(StateType StateType2) {
        this.StateType = StateType2;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public List<StateDefinition> getToStates() {
        return this.toStates;
    }

    public WorkDefinition getWorkDefinition() {
        return this.workDefinition;
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
    }

    public String toString() {
        return String.format("%s  - (%s)", new Object[]{this.getName(), this.getStateType()});
    }

    public String getFullName() {
        if (this.workDefinition != null) {
            return String.valueOf(this.workDefinition.getName()) + "." + this.getName();
        }
        return this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            StateDefinition other = (StateDefinition)obj;
            if (Strings.isValid((String)this.getName()) && Strings.isValid((String)other.getName()) && this.getName().equals(other.getName())) {
                equals = true;
            }
        }
        return equals;
    }

    public List<IAtsDecisionReviewDefinition> getDecisionReviews() {
        return this.decisionReviews;
    }

    public List<IAtsPeerReviewDefinition> getPeerReviews() {
        return this.peerReviews;
    }

    public int getStateWeight() {
        return this.stateWeight;
    }

    public void setStateWeight(int percentWeight) {
        this.stateWeight = percentWeight;
    }

    public void setRecommendedPercentComplete(int recommendedPercentComplete) {
        this.recommendedPercentComplete = recommendedPercentComplete;
    }

    public Integer getRecommendedPercentComplete() {
        return this.recommendedPercentComplete;
    }

    public void setColor(StateColor stateColor) {
        this.color = stateColor;
    }

    public StateColor getColor() {
        return this.color;
    }

    public void removeRule(String rule) {
        this.ruleMgr.removeRule(rule);
    }

    public List<String> getRules() {
        return this.ruleMgr.getRules();
    }

    public void addRule(String rule) {
        this.ruleMgr.addRule(rule);
    }

    public boolean hasRule(String rule) {
        return this.ruleMgr.hasRule(rule);
    }

    public void addDecisionReview(DecisionReviewDefinition reviewDefinition) {
        this.decisionReviews.add(reviewDefinition);
    }

    public void addPeerReview(PeerReviewDefinition reviewDefinition) {
        this.peerReviews.add(reviewDefinition);
    }

    public void addTransitionListener(IAtsTransitionHook transitionListener) {
        this.transitionListeners.add(transitionListener);
    }

    public void addWorkItemListener(IAtsWorkItemHook workItemHook) {
        this.workItemListeners.add(workItemHook);
    }

    public List<IAtsTransitionHook> getTransitionListeners() {
        return this.transitionListeners;
    }

    public List<StateOption> getStateOptions() {
        return this.stateOptions;
    }

    public void setStateOptions(List<StateOption> stateOptions) {
        this.stateOptions = stateOptions;
    }

    public List<IAtsWorkItemHook> getWorkItemListeners() {
        return this.workItemListeners;
    }
}

