/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private IShellProvider shellProvider;
    private boolean deleteContent;
    protected boolean fTestingMode;
    private String[] modelProviderIds;

    @Deprecated
    public DeleteResourceAction(Shell shell) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)shell);
        this.initAction();
        this.setShellProvider(() -> shell);
    }

    public DeleteResourceAction(IShellProvider provider) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)provider);
        this.initAction();
        this.setShellProvider(provider);
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.DeleteResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
    }

    private void setShellProvider(IShellProvider provider) {
        this.shellProvider = provider;
    }

    private boolean canDelete(List<? extends IResource> resources) {
        if (resources.isEmpty()) {
            return false;
        }
        if (!this.containsOnlyProjects(resources) && !this.containsOnlyNonProjects(resources)) {
            return false;
        }
        for (IResource iResource : resources) {
            if (!iResource.isPhantom() && iResource.getType() != 8) continue;
            return false;
        }
        return true;
    }

    private boolean containsLinkedResource(List<? extends IResource> resources) {
        int i = 0;
        while (i < resources.size()) {
            IResource resource = resources.get(i);
            if (resource.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsOnlyNonProjects(List<? extends IResource> resources) {
        int types = this.getSelectedResourceTypes(resources);
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    private boolean containsOnlyProjects(List<? extends IResource> resources) {
        int types = this.getSelectedResourceTypes(resources);
        return types == 4;
    }

    private boolean confirmDelete(List<? extends IResource> resources) {
        if (this.containsOnlyProjects(resources)) {
            return this.confirmDeleteProjects(resources);
        }
        return this.confirmDeleteNonProjects(resources);
    }

    private boolean confirmDeleteNonProjects(List<? extends IResource> resources) {
        String msg;
        String title;
        if (resources.size() == 1) {
            title = IDEWorkbenchMessages.DeleteResourceAction_title1;
            IResource resource = resources.get(0);
            msg = resource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResource1, (Object)resource.getName()) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirm1, (Object)resource.getName());
        } else {
            title = IDEWorkbenchMessages.DeleteResourceAction_titleN;
            msg = this.containsLinkedResource(resources) ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResourceN, (Object)resources.size()) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmN, (Object)resources.size());
        }
        return MessageDialog.openQuestion((Shell)this.shellProvider.getShell(), (String)title, (String)msg);
    }

    private boolean confirmDeleteProjects(List<? extends IResource> resources) {
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.shellProvider.getShell(), resources);
        dialog.setTestingMode(this.fTestingMode);
        int code = dialog.open();
        this.deleteContent = dialog.getDeleteContent();
        return code == 0;
    }

    private int getSelectedResourceTypes(List<? extends IResource> resources) {
        int types = 0;
        int i = 0;
        while (i < resources.size()) {
            types |= resources.get(i).getType();
            ++i;
        }
        return types;
    }

    public void run() {
        final List<? extends IResource> resources = this.getSelectedResources();
        if (resources.isEmpty()) {
            return;
        }
        if (!this.fTestingMode && LTKLauncher.openDeleteWizard(this.getStructuredSelection())) {
            CloseResourceAction.closeMatchingEditors(resources, true);
            return;
        }
        if (!this.confirmDelete(resources)) {
            return;
        }
        Job deletionCheckJob = new Job(IDEWorkbenchMessages.DeleteResourceAction_checkJobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (resources.isEmpty()) {
                    return Status.CANCEL_STATUS;
                }
                DeleteResourceAction.this.scheduleDeleteJob(resources);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deletionCheckJob.schedule();
    }

    private void scheduleDeleteJob(final List<? extends IResource> resourcesToDelete) {
        Job deleteJob = new Job(IDEWorkbenchMessages.DeleteResourceAction_jobName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    final DeleteResourcesOperation op = new DeleteResourcesOperation(resourcesToDelete.toArray(new IResource[resourcesToDelete.size()]), IDEWorkbenchMessages.DeleteResourceAction_operationLabel, DeleteResourceAction.this.deleteContent);
                    op.setModelProviderIds(DeleteResourceAction.this.getModelProviderIds());
                    if (DeleteResourceAction.this.deleteContent && DeleteResourceAction.this.containsOnlyProjects(resourcesToDelete)) {
                        WorkbenchJob statusJob = new WorkbenchJob("Status checking"){

                            public IStatus runInUIThread(IProgressMonitor m) {
                                return op.computeExecutionStatus(m);
                            }
                        };
                        statusJob.setSystem(true);
                        statusJob.schedule();
                        try {
                            statusJob.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (statusJob.getResult().isOK()) {
                            return op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter(DeleteResourceAction.this.shellProvider.getShell()));
                        }
                        return statusJob.getResult();
                    }
                    return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(DeleteResourceAction.this.shellProvider.getShell()));
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        return ((CoreException)e.getCause()).getStatus();
                    }
                    return new Status(4, "org.eclipse.ui.ide", e.getMessage(), (Throwable)e);
                }
            }

            public boolean belongsTo(Object family) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deleteJob.setUser(true);
        deleteJob.schedule();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete(this.getSelectedResources());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private final List<? extends IResource> projects;
        private boolean deleteContent;
        private boolean fIsTesting;
        private Button radio1;
        private Button radio2;
        private final SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    deleteContent = button == radio1;
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, List<? extends IResource> projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
            this.projects = projects;
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        static String getTitle(List<? extends IResource> projects) {
            if (projects.size() == 1) {
                return IDEWorkbenchMessages.DeleteResourceAction_titleProject1;
            }
            return IDEWorkbenchMessages.DeleteResourceAction_titleProjectN;
        }

        static String getMessage(List<? extends IResource> projects) {
            if (projects.size() == 1) {
                IProject project = (IProject)projects.get(0);
                return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProject1, (Object)project.getName());
            }
            return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProjectN, (Object)projects.size());
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            IProject project;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = this.projects.size() == 1 ? ((project = (IProject)this.projects.get(0)) == null || project.getLocation() == null ? IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_deleteContents1, (Object)project.getLocation().toOSString())) : IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN;
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            Label detailsLabel = new Label(composite, 16384);
            detailsLabel.setText(IDEWorkbenchMessages.DeleteResourceAction_deleteContentsDetails);
            detailsLabel.setFont(parent.getFont());
            GridData data = new GridData();
            data.horizontalIndent = 20;
            detailsLabel.setLayoutData((Object)data);
            detailsLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    deleteContent = true;
                    radio1.setSelection(deleteContent);
                    radio2.setSelection(!deleteContent);
                }
            });
            new Label(composite, 16384);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = IDEWorkbenchMessages.DeleteResourceAction_doNotDeleteContents;
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        boolean getDeleteContent() {
            return this.deleteContent;
        }

        public int open() {
            if (this.fIsTesting) {
                this.deleteContent = true;
                return 0;
            }
            return super.open();
        }

        void setTestingMode(boolean t) {
            this.fIsTesting = t;
        }
    }
}

