/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

final class KotlinJvmOverloadsFilter
implements IFilter {
    KotlinJvmOverloadsFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (methodNode.instructions.size() < 5) {
            return;
        }
        AbstractInsnNode i = methodNode.instructions.getLast();
        if (i.getType() == 8) {
            i = i.getPrevious();
        }
        if (i.getOpcode() != 177) {
            return;
        }
        if ((i = i.getPrevious()).getType() != 15) {
            return;
        }
        if ((i = i.getPrevious()) != ((LineNumberNode)i.getNext()).start) {
            return;
        }
        if (!KotlinJvmOverloadsFilter.invokeDefault(i = i.getPrevious())) {
            return;
        }
        while (i != null) {
            if (i.getType() == 15) {
                return;
            }
            i = i.getPrevious();
        }
        output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
    }

    private static boolean invokeDefault(AbstractInsnNode i) {
        if (i.getOpcode() == 184) {
            return ((MethodInsnNode)i).name.endsWith("$default");
        }
        if (i.getOpcode() == 183) {
            return ((MethodInsnNode)i).desc.endsWith("Lkotlin/jvm/internal/DefaultConstructorMarker;)V");
        }
        return false;
    }
}

