/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunnable;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.StateSet;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.automaton.TransitionAccessor;

public class NFARunAutomaton
implements ByteRunnable,
TransitionAccessor,
Accountable {
    private static final int MISSING = -1;
    private static final int NOT_COMPUTED = -2;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(NFARunAutomaton.class);
    private final Automaton automaton;
    private final int[] points;
    private final Map<DState, Integer> dStateToOrd = new HashMap<DState, Integer>();
    private DState[] dStates;
    private final int alphabetSize;
    final int[] classmap;
    private final Operations.PointTransitionSet transitionSet = new Operations.PointTransitionSet();
    private final StateSet statesSet = new StateSet(5);

    public NFARunAutomaton(Automaton automaton) {
        this(automaton, 0x110000);
    }

    public NFARunAutomaton(Automaton automaton, int alphabetSize) {
        this.automaton = automaton;
        this.points = automaton.getStartPoints();
        this.alphabetSize = alphabetSize;
        this.dStates = new DState[10];
        this.findDState(new DState(new int[]{0}));
        this.classmap = new int[Math.min(256, alphabetSize)];
        int i = 0;
        for (int j = 0; j < this.classmap.length; ++j) {
            if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                // empty if block
            }
            this.classmap[j] = ++i;
        }
    }

    @Override
    public int step(int state, int c) {
        assert (this.dStates[state] != null);
        return this.step(this.dStates[state], c);
    }

    @Override
    public boolean isAccept(int state) {
        assert (this.dStates[state] != null);
        return this.dStates[state].isAccept;
    }

    @Override
    public int getSize() {
        return this.dStates.length;
    }

    boolean run(int[] s) {
        int p = 0;
        for (int c : s) {
            if ((p = this.step(p, c)) != -1) continue;
            return false;
        }
        return this.dStates[p].isAccept;
    }

    private int step(DState dState, int c) {
        int charClass = this.getCharClass(c);
        return dState.nextState(charClass);
    }

    private int findDState(DState dState) {
        if (dState == null) {
            return -1;
        }
        int ord = this.dStateToOrd.getOrDefault(dState, -1);
        if (ord >= 0) {
            return ord;
        }
        ord = this.dStateToOrd.size();
        this.dStateToOrd.put(dState, ord);
        assert (ord >= this.dStates.length || this.dStates[ord] == null);
        if (ord >= this.dStates.length) {
            this.dStates = ArrayUtil.grow(this.dStates, ord + 1);
        }
        this.dStates[ord] = dState;
        return ord;
    }

    final int getCharClass(int c) {
        assert (c < this.alphabetSize);
        if (c < this.classmap.length) {
            return this.classmap[c];
        }
        int a = 0;
        int b = this.points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (this.points[d] > c) {
                b = d;
                continue;
            }
            if (this.points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    @Override
    public int initTransition(int state, Transition t) {
        t.source = state;
        t.transitionUpto = -1;
        return this.getNumTransitions(state);
    }

    @Override
    public void getNextTransition(Transition t) {
        assert (t.transitionUpto < this.points.length - 1 && t.transitionUpto >= -1);
        while (this.dStates[t.source].transitions[++t.transitionUpto] == -1) {
        }
        assert (this.dStates[t.source].transitions[t.transitionUpto] != -2);
        this.setTransitionAccordingly(t);
    }

    private void setTransitionAccordingly(Transition t) {
        t.dest = this.dStates[t.source].transitions[t.transitionUpto];
        t.min = this.points[t.transitionUpto];
        t.max = t.transitionUpto == this.points.length - 1 ? this.alphabetSize - 1 : this.points[t.transitionUpto + 1] - 1;
    }

    @Override
    public int getNumTransitions(int state) {
        this.dStates[state].determinize();
        return this.dStates[state].outgoingTransitions;
    }

    @Override
    public void getTransition(int state, int index, Transition t) {
        this.dStates[state].determinize();
        int outgoingTransitions = -1;
        t.transitionUpto = -1;
        t.source = state;
        while (outgoingTransitions < index && t.transitionUpto < this.points.length - 1) {
            if (this.dStates[t.source].transitions[++t.transitionUpto] == -1) continue;
            ++outgoingTransitions;
        }
        assert (outgoingTransitions == index);
        this.setTransitionAccordingly(t);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.automaton) + RamUsageEstimator.sizeOfObject(this.points) + RamUsageEstimator.sizeOfMap(this.dStateToOrd) + RamUsageEstimator.sizeOfObject(this.dStates) + RamUsageEstimator.sizeOfObject(this.classmap);
    }

    private class DState
    implements Accountable {
        private final int[] nfaStates;
        private int[] transitions;
        private final int hashCode;
        private final boolean isAccept;
        private final Transition stepTransition = new Transition();
        private Transition minimalTransition;
        private int computedTransitions;
        private int outgoingTransitions;

        private DState(int[] nfaStates) {
            assert (nfaStates != null && nfaStates.length > 0);
            this.nfaStates = nfaStates;
            int hashCode = nfaStates.length;
            boolean isAccept = false;
            for (int s : nfaStates) {
                hashCode += BitMixer.mix(s);
                if (!NFARunAutomaton.this.automaton.isAccept(s)) continue;
                isAccept = true;
            }
            this.isAccept = isAccept;
            this.hashCode = hashCode;
        }

        private int nextState(int charClass) {
            this.initTransitions();
            assert (charClass < this.transitions.length);
            if (this.transitions[charClass] == -2) {
                this.assignTransition(charClass, NFARunAutomaton.this.findDState(this.step(NFARunAutomaton.this.points[charClass])));
                if (this.minimalTransition != null) {
                    int cls = charClass;
                    while (cls > 0 && NFARunAutomaton.this.points[--cls] >= this.minimalTransition.min) {
                        assert (this.transitions[cls] == -2 || this.transitions[cls] == this.transitions[charClass]);
                        this.assignTransition(cls, this.transitions[charClass]);
                    }
                    cls = charClass;
                    while (cls < NFARunAutomaton.this.points.length - 1 && NFARunAutomaton.this.points[++cls] <= this.minimalTransition.max) {
                        assert (this.transitions[cls] == -2 || this.transitions[cls] == this.transitions[charClass]);
                        this.assignTransition(cls, this.transitions[charClass]);
                    }
                    this.minimalTransition = null;
                }
            }
            return this.transitions[charClass];
        }

        private void assignTransition(int charClass, int dest) {
            if (this.transitions[charClass] == -2) {
                ++this.computedTransitions;
                this.transitions[charClass] = dest;
                if (this.transitions[charClass] != -1) {
                    ++this.outgoingTransitions;
                }
            }
        }

        private DState step(int c) {
            NFARunAutomaton.this.statesSet.reset();
            int left = -1;
            int right = NFARunAutomaton.this.alphabetSize;
            block0: for (int nfaState : this.nfaStates) {
                int numTransitions = NFARunAutomaton.this.automaton.initTransition(nfaState, this.stepTransition);
                for (int i = 0; i < numTransitions; ++i) {
                    NFARunAutomaton.this.automaton.getNextTransition(this.stepTransition);
                    if (this.stepTransition.min <= c && this.stepTransition.max >= c) {
                        NFARunAutomaton.this.statesSet.incr(this.stepTransition.dest);
                        left = Math.max(this.stepTransition.min, left);
                        right = Math.min(this.stepTransition.max, right);
                    }
                    if (this.stepTransition.max < c) {
                        left = Math.max(this.stepTransition.max + 1, left);
                    }
                    if (this.stepTransition.min <= c) continue;
                    right = Math.min(this.stepTransition.min - 1, right);
                    continue block0;
                }
            }
            if (NFARunAutomaton.this.statesSet.size() == 0) {
                return null;
            }
            this.minimalTransition = new Transition();
            this.minimalTransition.min = left;
            this.minimalTransition.max = right;
            return new DState(NFARunAutomaton.this.statesSet.getArray());
        }

        private void determinize() {
            if (this.transitions != null && this.computedTransitions == this.transitions.length) {
                return;
            }
            this.initTransitions();
            NFARunAutomaton.this.transitionSet.reset();
            for (int nfaState : this.nfaStates) {
                int numTransitions = NFARunAutomaton.this.automaton.initTransition(nfaState, this.stepTransition);
                for (int i = 0; i < numTransitions; ++i) {
                    NFARunAutomaton.this.automaton.getNextTransition(this.stepTransition);
                    NFARunAutomaton.this.transitionSet.add(this.stepTransition);
                }
            }
            if (NFARunAutomaton.this.transitionSet.count == 0) {
                Arrays.fill(this.transitions, -1);
                this.computedTransitions = this.transitions.length;
                return;
            }
            NFARunAutomaton.this.transitionSet.sort();
            NFARunAutomaton.this.statesSet.reset();
            int lastPoint = -1;
            int charClass = 0;
            for (int i = 0; i < NFARunAutomaton.this.transitionSet.count; ++i) {
                int dest;
                int j;
                int point = NFARunAutomaton.this.transitionSet.points[i].point;
                if (NFARunAutomaton.this.statesSet.size() > 0) {
                    assert (lastPoint != -1);
                    int ord = NFARunAutomaton.this.findDState(new DState(NFARunAutomaton.this.statesSet.getArray()));
                    while (NFARunAutomaton.this.points[charClass] < lastPoint) {
                        this.assignTransition(charClass++, -1);
                    }
                    assert (NFARunAutomaton.this.points[charClass] == lastPoint);
                    while (charClass < NFARunAutomaton.this.points.length && NFARunAutomaton.this.points[charClass] < point) {
                        assert (this.transitions[charClass] == -2 || this.transitions[charClass] == ord);
                        this.assignTransition(charClass++, ord);
                    }
                    assert (charClass == NFARunAutomaton.this.points.length && point == NFARunAutomaton.this.alphabetSize || NFARunAutomaton.this.points[charClass] == point);
                }
                int[] transitions = NFARunAutomaton.this.transitionSet.points[i].ends.transitions;
                int limit = NFARunAutomaton.this.transitionSet.points[i].ends.next;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    NFARunAutomaton.this.statesSet.decr(dest);
                }
                NFARunAutomaton.this.transitionSet.points[i].ends.next = 0;
                transitions = NFARunAutomaton.this.transitionSet.points[i].starts.transitions;
                limit = NFARunAutomaton.this.transitionSet.points[i].starts.next;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    NFARunAutomaton.this.statesSet.incr(dest);
                }
                lastPoint = point;
                NFARunAutomaton.this.transitionSet.points[i].starts.next = 0;
            }
            assert (NFARunAutomaton.this.statesSet.size() == 0);
            assert (this.computedTransitions >= charClass);
            assert (charClass == this.transitions.length || this.transitions[charClass] == -1 || this.transitions[charClass] == -2);
            Arrays.fill(this.transitions, charClass, this.transitions.length, -1);
            this.computedTransitions = this.transitions.length;
        }

        private void initTransitions() {
            if (this.transitions == null) {
                this.transitions = new int[NFARunAutomaton.this.points.length];
                Arrays.fill(this.transitions, -2);
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DState dState = (DState)o;
            return this.hashCode == dState.hashCode && Arrays.equals(this.nfaStates, dState.nfaStates);
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.alignObjectSize(13L + Transition.BYTES_USED * 2L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 4L) + RamUsageEstimator.sizeOfObject(this.nfaStates) + RamUsageEstimator.sizeOfObject(this.transitions);
        }
    }
}

