/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class JDIElementImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDescriptor fBaseImage;
    private final int fFlags;
    private Point fSize;

    public JDIElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage((ImageDataProvider)this.createCachedImageDataProvider(this.fBaseImage), 0, 0);
        this.drawRightBottom();
    }

    private void drawRightBottom() {
        Point size = this.getSize();
        Point pos = new Point(size.x, size.y);
        if ((this.fFlags & 0x400000) != 0) {
            this.addRightBottomImage(DebugPluginImages.getImageDescriptor((String)"IMG_OVR_SHOW_LOGICAL_STRUCTURE"), pos);
        }
    }

    private void addRightBottomImage(ImageDescriptor desc, Point pos) {
        CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(desc);
        int x = pos.x - provider.getWidth();
        int y = pos.y - provider.getHeight();
        if (x >= 0 && y >= 0) {
            this.drawImage((ImageDataProvider)provider, x, y);
            pos.x = x;
        }
    }

    protected Point getSize() {
        if (this.fSize == null) {
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.fBaseImage);
            this.fSize = new Point(provider.getWidth(), provider.getHeight());
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDIElementImageDescriptor)) {
            return false;
        }
        JDIElementImageDescriptor other = (JDIElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags;
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags;
    }
}

