/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;

public class ProjectState
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8616641822921441882L;
    public static final int FORMAT_VERSION = 1;
    private Map<String, Collection<String>> mappings = new HashMap<String, Collection<String>>();
    private String path;
    private DSAnnotationVersion specVersion;
    private ValidationErrorLevel errorLevel;
    private ValidationErrorLevel missingUnbindMethodLevel;
    private Map<String, Collection<String>> types;
    private Map<String, String> files;
    private int formatVersion = 1;

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    public Collection<String> getCompilationUnits() {
        if (this.types == null) {
            return this.mappings.keySet().stream().map(k -> k.replace('.', '/') + ".java").collect(Collectors.toList());
        }
        return Collections.unmodifiableCollection(this.types.keySet());
    }

    public Collection<String> removeMappings(String cuKey) {
        if (this.types == null) {
            return this.mappings.remove(this.toLegacyCUKey(cuKey));
        }
        Collection<String> cuTypes = this.types.remove(cuKey);
        if (cuTypes == null) {
            return null;
        }
        HashSet<String> oldDSKeys = null;
        if (this.files != null) {
            oldDSKeys = new HashSet<String>(cuTypes.size());
            for (String type : cuTypes) {
                String dsKey = this.files.remove(type);
                if (dsKey == null) continue;
                oldDSKeys.add(dsKey);
            }
        }
        return oldDSKeys;
    }

    public Collection<String> getModelFiles(String cuKey) {
        if (this.types == null) {
            Collection<String> files = this.mappings.get(this.toLegacyCUKey(cuKey));
            return files == null ? null : Collections.unmodifiableCollection(files);
        }
        Collection<String> cuTypes = this.types.get(cuKey);
        if (cuTypes == null || this.files == null) {
            return null;
        }
        HashSet<String> cuFiles = new HashSet<String>(cuTypes.size());
        for (String type : cuTypes) {
            String dsKey = this.files.get(type);
            if (dsKey == null) continue;
            cuFiles.add(dsKey);
        }
        return Collections.unmodifiableCollection(cuFiles);
    }

    private Object toLegacyCUKey(String cuKey) {
        return JavaCore.removeJavaLikeExtension((String)cuKey).replace('.', '/');
    }

    public String getModelFile(String className) {
        return this.files == null ? null : this.files.get(className);
    }

    public Collection<String> updateMappings(String cuKey, HashMap<String, String> dsKeys) {
        Collection<String> oldDSKeys = this.removeMappings(cuKey);
        if (!dsKeys.isEmpty()) {
            this.getTypes().put(cuKey, new HashSet<String>(dsKeys.keySet()));
            this.getFiles().putAll(dsKeys);
        }
        return oldDSKeys;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DSAnnotationVersion getSpecVersion() {
        return this.specVersion == null ? DSAnnotationVersion.V1_3 : this.specVersion;
    }

    public void setSpecVersion(DSAnnotationVersion specVersion) {
        this.specVersion = specVersion;
    }

    public ValidationErrorLevel getErrorLevel() {
        return this.errorLevel == null ? ValidationErrorLevel.error : this.errorLevel;
    }

    public void setErrorLevel(ValidationErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    public ValidationErrorLevel getMissingUnbindMethodLevel() {
        return this.missingUnbindMethodLevel == null ? this.getErrorLevel() : this.missingUnbindMethodLevel;
    }

    public void setMissingUnbindMethodLevel(ValidationErrorLevel missingUnbindMethodLevel) {
        this.missingUnbindMethodLevel = missingUnbindMethodLevel;
    }

    private Map<String, Collection<String>> getTypes() {
        if (this.types == null) {
            this.types = new HashMap<String, Collection<String>>();
        }
        return this.types;
    }

    private Map<String, String> getFiles() {
        if (this.files == null) {
            this.files = new HashMap<String, String>();
        }
        return this.files;
    }

    public ProjectState clone() {
        ProjectState clone;
        try {
            clone = (ProjectState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException();
        }
        clone.mappings = new HashMap<String, Collection<String>>(this.mappings.size());
        for (Map.Entry<String, Collection<String>> entry : this.mappings.entrySet()) {
            clone.mappings.put(entry.getKey(), new HashSet<String>(entry.getValue()));
        }
        if (this.types != null) {
            clone.types = new HashMap<String, Collection<String>>(this.types.size());
            for (Map.Entry<String, Collection<String>> entry : this.types.entrySet()) {
                clone.types.put(entry.getKey(), new HashSet<String>(entry.getValue()));
            }
        }
        if (this.files != null) {
            clone.files = new HashMap<String, String>(this.files);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ProjectState o = (ProjectState)obj;
        return this.formatVersion == o.formatVersion && (this.path == null ? o.path == null : this.path.equals(o.path)) && this.specVersion == o.specVersion && this.errorLevel == o.errorLevel && this.missingUnbindMethodLevel == o.missingUnbindMethodLevel && this.mappings.equals(o.mappings) && (this.files == null ? o.files == null : this.files.equals(o.files)) && (this.types == null ? o.types == null : this.types.equals(o.types));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ProjectState[path=");
        buf.append(this.path).append(";mappings=");
        buf.append(this.mappings).append(";types=");
        buf.append(this.types).append(";files=");
        buf.append(this.files).append(";errorLevel=");
        buf.append((Object)this.specVersion).append(";specVersion=");
        buf.append((Object)this.errorLevel).append(";missingUnbindMethodLevel=");
        buf.append((Object)this.missingUnbindMethodLevel).append(";formatVersion=");
        buf.append(this.formatVersion).append(']');
        return buf.toString();
    }
}

