/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.jing.toremove;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.pattern.AnnotationsImpl;
import com.thaiopensource.relaxng.pattern.CommentListImpl;
import com.thaiopensource.relaxng.pattern.FeasibleTransform;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.IdTypeMapBuilder;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternDumper;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.validate.rng.impl.IdTypeMapSchema;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.eclipse.lemminx.extensions.relaxng.jing.toremove.MyCombineSchema;
import org.eclipse.lemminx.extensions.relaxng.jing.toremove.MyPatternSchema;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class MySchemaReaderImpl
extends AbstractSchemaReader {
    public static final PropertyId<SchemaPatternBuilder> SCHEMA_PATTERN_BUILDER = PropertyId.newInstance("SCHEMA_PATTERN_BUILDER", SchemaPatternBuilder.class);
    private static final PropertyId<?>[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, WrapProperty.ATTRIBUTE_OWNER, SCHEMA_PATTERN_BUILDER};

    @Override
    public Schema createSchema(SAXSource source, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder spb = properties.get(SCHEMA_PATTERN_BUILDER);
        if (spb == null) {
            spb = new SchemaPatternBuilder();
        }
        SAXResolver resolver2 = ResolverFactory.createResolver(properties);
        ErrorHandler eh = properties.get(ValidateProperty.ERROR_HANDLER);
        DatatypeLibraryFactory dlf = properties.get(RngProperty.DATATYPE_LIBRARY_FACTORY);
        if (dlf == null) {
            dlf = new DatatypeLibraryLoader();
        }
        try {
            Pattern start = SchemaBuilderImpl.parse(this.createParseable(source, resolver2, eh, properties), eh, dlf, spb, properties.contains(WrapProperty.ATTRIBUTE_OWNER));
            return MySchemaReaderImpl.wrapPattern(start, spb, properties);
        }
        catch (IllegalSchemaException e) {
            throw new IncorrectSchemaException();
        }
    }

    @Override
    public Option getOption(String uri) {
        return RngProperty.getOption(uri);
    }

    static Schema wrapPattern(Pattern start, SchemaPatternBuilder spb, PropertyMap properties) throws SAXException, IncorrectSchemaException {
        if (properties.contains(RngProperty.FEASIBLE)) {
            start = FeasibleTransform.transform(spb, start);
        }
        properties = new SimplifiedSchemaPropertyMap(AbstractSchema.filterProperties(properties, supportedPropertyIds), start);
        AbstractSchema schema = new MyPatternSchema(spb, start, properties);
        if (spb.hasIdTypes() && properties.contains(RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler eh = properties.get(ValidateProperty.ERROR_HANDLER);
            IdTypeMap idTypeMap = new IdTypeMapBuilder(eh, start).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema idSchema = properties.contains(RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, properties) : new IdTypeMapSchema(idTypeMap, properties);
            schema = new MyCombineSchema(schema, idSchema, properties);
        }
        return schema;
    }

    protected abstract Parseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> createParseable(SAXSource var1, SAXResolver var2, ErrorHandler var3, PropertyMap var4) throws SAXException;

    private static class SimplifiedSchemaPropertyMap
    implements PropertyMap {
        private final PropertyMap base;
        private final Pattern start;

        SimplifiedSchemaPropertyMap(PropertyMap base, Pattern start) {
            this.base = base;
            this.start = start;
        }

        @Override
        public <T> T get(PropertyId<T> pid) {
            if (pid == RngProperty.SIMPLIFIED_SCHEMA) {
                String simplifiedSchema = PatternDumper.toString(this.start);
                return pid.getValueClass().cast(simplifiedSchema);
            }
            return this.base.get(pid);
        }

        @Override
        public PropertyId<?> getKey(int i) {
            return i == this.base.size() ? RngProperty.SIMPLIFIED_SCHEMA : this.base.getKey(i);
        }

        @Override
        public int size() {
            return this.base.size() + 1;
        }

        @Override
        public boolean contains(PropertyId<?> pid) {
            return this.base.contains(pid) || pid == RngProperty.SIMPLIFIED_SCHEMA;
        }
    }
}

