/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.AbstractHnswGraphSearcher;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

final class SeededHnswGraphSearcher
extends AbstractHnswGraphSearcher {
    private final AbstractHnswGraphSearcher delegate;
    private final int[] seedOrds;

    static SeededHnswGraphSearcher fromEntryPoints(AbstractHnswGraphSearcher delegate, int numEps, DocIdSetIterator eps, int graphSize) throws IOException {
        if (numEps <= 0) {
            throw new IllegalArgumentException("The number of entry points must be > 0");
        }
        int[] entryPoints = new int[numEps];
        int idx = 0;
        while (idx < entryPoints.length) {
            int entryPointOrdInt = eps.nextDoc();
            if (entryPointOrdInt == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("The number of entry points provided is less than the number of entry points requested");
            }
            assert (entryPointOrdInt < graphSize);
            entryPoints[idx++] = entryPointOrdInt;
        }
        return new SeededHnswGraphSearcher(delegate, entryPoints);
    }

    SeededHnswGraphSearcher(AbstractHnswGraphSearcher delegate, int[] seedOrds) {
        this.delegate = delegate;
        this.seedOrds = seedOrds;
    }

    @Override
    void searchLevel(KnnCollector results, RandomVectorScorer scorer, int level, int[] eps, HnswGraph graph, Bits acceptOrds) throws IOException {
        this.delegate.searchLevel(results, scorer, level, eps, graph, acceptOrds);
    }

    @Override
    int[] findBestEntryPoint(RandomVectorScorer scorer, HnswGraph graph, KnnCollector collector) {
        return this.seedOrds;
    }
}

