/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.ArrayList;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.internal.core.codeassist.contexts.IClassMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class TraitConflictContext
extends StatementContext
implements IClassMemberContext {
    public static final int NONE = 0;
    public static final int TRAIT_NAME = 1;
    public static final int TRAIT_KEYWORD = 2;

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        ICompletionScope scope = this.getCompanion().getScope();
        return scope.getType() == ICompletionScope.Type.TRAIT_CONFLICT;
    }

    public int getUseTraitStatementContext() {
        return this.getUseTraitStatementContext(this.getCompanion().getOffset(), this.getCompanion().getStructuredDocumentRegion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUseTraitStatementContext(int offset, IStructuredDocumentRegion sdRegion) {
        String type;
        int documentOffset;
        ArrayList<String> types = new ArrayList<String>();
        if (sdRegion == null) {
            sdRegion = this.getCompanion().getStructuredDocumentRegion();
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPHPToken(0) : phpScriptRegion.getPHPToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return 0;
                    }
                    if (!PHPPartitionTypes.isPHPCommentState(startTokenRegion.getType()) && startTokenRegion.getType() != "WHITESPACE") {
                        types.add(startTokenRegion.getType());
                    }
                    if (startTokenRegion.getType() != "PHP_CURLY_OPEN" && startTokenRegion.getType() != "PHP_INSTEADOF" && startTokenRegion.getType() != "PHP_SEMICOLON" && startTokenRegion.getType() != "PHP_AS") {
                        startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - 1);
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (types.size() == 1) {
            type = (String)types.get(0);
            if (type == "PHP_CURLY_OPEN" || type == "PHP_INSTEADOF" || type == "PHP_SEMICOLON") {
                return 1;
            }
            if (type == "PHP_AS") {
                return 2;
            }
            if (type != "PHP_INSTEADOF") return 0;
            return 2;
        }
        if (types.size() == 2) {
            String type1 = (String)types.get(0);
            String type2 = (String)types.get(1);
            try {
                if (type2 == "PHP_SEMICOLON" && type1 == "PHP_LABEL" && Character.isWhitespace(this.getCompanion().getDocument().getChar(offset - 1))) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
            if (type2 != "PHP_CURLY_OPEN" && type2 != "PHP_INSTEADOF" && type2 != "PHP_SEMICOLON" && type1 != "PHP_LABEL") return 0;
            return 1;
        }
        if (types.size() == 3) {
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_LABEL" || type1 != "PHP_LABEL" || type2 != "PHP_SEMICOLON") return 0;
            return 2;
        } else {
            if (types.size() != 4) return 0;
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_LABEL" || type1 != "PHP_PAAMAYIM_NEKUDOTAYIM" || type2 != "PHP_LABEL") return 0;
            return 2;
        }
    }

    @Override
    public IClassMemberContext.Trigger getTriggerType() {
        return IClassMemberContext.Trigger.CLASS;
    }

    @Override
    public IType[] getLhsTypes() {
        return this.getCompanion().getLeftHandType(this, false);
    }
}

