/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;

public class SourceModuleInfoCache
implements ISourceModuleInfoCache,
IResourceChangeListener,
IResourceDeltaVisitor {
    final int capacity = 2500;
    private final ReferenceQueue<ISourceModuleInfoCache.ISourceModuleInfo> queue = new ReferenceQueue();
    private final Map<ISourceModule, CacheReference> map = new LinkedHashMap<ISourceModule, CacheReference>(16, 0.9f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ISourceModule, CacheReference> eldest) {
            return this.size() > 2500;
        }
    };
    private static final boolean DEBUG = false;

    public void start() {
        DLTKCore.addPreProcessingResourceChangedListener(this, 1);
    }

    public void stop() {
        DLTKCore.removePreProcessingResourceChangedListener(this);
    }

    private void expungeStaleEntries() {
        CacheReference r;
        while ((r = (CacheReference)this.queue.poll()) != null) {
            this.map.remove(r.module);
        }
    }

    @Override
    public synchronized ISourceModuleInfoCache.ISourceModuleInfo get(ISourceModule module) {
        ISourceModuleInfoCache.ISourceModuleInfo info;
        this.expungeStaleEntries();
        CacheReference ref = this.map.get(module);
        if (ref != null && (info = (ISourceModuleInfoCache.ISourceModuleInfo)ref.get()) != null && ref.isValid(module)) {
            return info;
        }
        info = new SourceModuleInfo();
        this.map.put(module, new CacheReference(module, info, this.queue));
        return info;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        this.expungeStaleEntries();
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            DLTKCore.error(e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        int kind = delta.getKind();
        if (kind == 1) {
            return false;
        }
        IResource resource = delta.getResource();
        switch (kind) {
            case 4: {
                switch (resource.getType()) {
                    case 4: {
                        IProject project;
                        if ((delta.getFlags() & 0x4000) != 0 && !(project = (IProject)resource).isOpen()) {
                            this.removeByProject(project);
                            return false;
                        }
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if ((delta.getFlags() & 0x100) == 0) break;
                        this.remove((IFile)resource);
                    }
                }
                break;
            }
            case 2: {
                switch (resource.getType()) {
                    case 4: {
                        this.removeByProject((IProject)resource);
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                    case 1: {
                        this.remove((IFile)resource);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void removeByProject(IProject project) {
        Iterator<ISourceModule> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            ISourceModule module = i.next();
            if (!project.equals((Object)module.getScriptProject().getProject())) continue;
            i.remove();
        }
    }

    public void remove(IFile file) {
        this.remove(DLTKCore.createSourceModuleFrom(file));
    }

    @Override
    public synchronized void remove(ISourceModule module) {
        this.map.remove(module);
    }

    @Override
    public synchronized void clear() {
        while (this.queue.poll() != null) {
        }
        this.map.clear();
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public int capacity() {
        return 2500;
    }

    private static class CacheReference
    extends SoftReference<ISourceModuleInfoCache.ISourceModuleInfo> {
        final long modificationStamp;
        final ISourceModule module;

        public CacheReference(ISourceModule module, ISourceModuleInfoCache.ISourceModuleInfo referent, ReferenceQueue<? super ISourceModuleInfoCache.ISourceModuleInfo> q) {
            super(referent, q);
            this.module = module;
            this.modificationStamp = CacheReference.getModificationStamp(module);
        }

        private static long getModificationStamp(ISourceModule module) {
            IResource resource = module.getResource();
            return resource != null ? resource.getModificationStamp() : -1L;
        }

        public boolean isValid(ISourceModule module) {
            IResource resource = module.getResource();
            return resource == null || resource.getModificationStamp() == this.modificationStamp;
        }
    }

    static class SourceModuleInfo
    implements ISourceModuleInfoCache.ISourceModuleInfo {
        private Map<Object, Object> map;

        SourceModuleInfo() {
        }

        @Override
        public synchronized Object get(String key) {
            if (this.map == null) {
                return null;
            }
            return this.map.get(key);
        }

        @Override
        public synchronized void put(String key, Object value) {
            if (this.map == null) {
                this.map = new HashMap<Object, Object>();
            }
            this.map.put(key, value);
        }

        @Override
        public synchronized void remove(String key) {
            if (this.map != null) {
                this.map.remove(key);
            }
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }
    }
}

