/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.terminal.connector.Logger;
import org.eclipse.terminal.internal.control.impl.TerminalPlugin;
import org.eclipse.terminal.model.TerminalColor;

public class TerminalStyle {
    private final TerminalColor fForegroundTerminalColor;
    private final TerminalColor fBackgroundTerminalColor;
    private final RGB fForegroundRGB;
    private final RGB fBackgroundRGB;
    private final boolean fBold;
    private final boolean fBlink;
    private final boolean fUnderline;
    private final boolean fReverse;
    private static final Map<TerminalStyle, TerminalStyle> fgStyles = Collections.synchronizedMap(new LinkedHashMap<TerminalStyle, TerminalStyle>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<TerminalStyle, TerminalStyle> eldest) {
            boolean removeEldest;
            int size = this.size();
            boolean bl = removeEldest = size >= 1000;
            if (TerminalPlugin.isOptionEnabled("org.eclipse.terminal.control/debug/log/VT100Backend")) {
                if (removeEldest) {
                    Logger.log("Removing eldest Style from style cache, size = " + size);
                } else {
                    Logger.log("Leaving eldest Style in style cache, size = " + size);
                }
            }
            return removeEldest;
        }
    });

    private TerminalStyle(TerminalColor foregroundTerminalColor, TerminalColor backgroundTerminalColor, RGB foregroundRGB, RGB backgroundRGB, boolean bold, boolean blink, boolean underline, boolean reverse) {
        Assert.isLegal((foregroundTerminalColor == null || foregroundRGB == null ? 1 : 0) != 0, (String)"Only one of ANSI or RGB colors can be specified as a foreground color");
        Assert.isLegal((backgroundTerminalColor == null || backgroundRGB == null ? 1 : 0) != 0, (String)"Only one of ANSI or RGB colors can be specified as a background color");
        this.fForegroundTerminalColor = foregroundTerminalColor;
        this.fBackgroundTerminalColor = backgroundTerminalColor;
        this.fForegroundRGB = foregroundRGB;
        this.fBackgroundRGB = backgroundRGB;
        this.fBold = bold;
        this.fBlink = blink;
        this.fUnderline = underline;
        this.fReverse = reverse;
    }

    public static TerminalStyle getStyle(TerminalColor foregroundTerminalColor, TerminalColor backgroundTerminalColor, RGB foregroundRGB, RGB backgroundRGB, boolean bold, boolean blink, boolean underline, boolean reverse) {
        TerminalStyle style = new TerminalStyle(foregroundTerminalColor, backgroundTerminalColor, foregroundRGB, backgroundRGB, bold, blink, underline, reverse);
        return fgStyles.computeIfAbsent(style, s -> style);
    }

    public static TerminalStyle getStyle(TerminalColor foregroundTerminalColor, TerminalColor backgroundTerminalColor, boolean bold, boolean blink, boolean underline, boolean reverse) {
        return TerminalStyle.getStyle(foregroundTerminalColor, backgroundTerminalColor, null, null, bold, blink, underline, reverse);
    }

    public static TerminalStyle getStyle(RGB foregroundRGB, RGB backgroundRGB, boolean bold, boolean blink, boolean underline, boolean reverse) {
        return TerminalStyle.getStyle(null, null, foregroundRGB, backgroundRGB, bold, blink, underline, reverse);
    }

    public static TerminalStyle getDefaultStyle() {
        return TerminalStyle.getStyle(TerminalColor.FOREGROUND, TerminalColor.BACKGROUND);
    }

    public static TerminalStyle getStyle(TerminalColor foregroundTerminalColor, TerminalColor backgroundTerminalColor) {
        return TerminalStyle.getStyle(foregroundTerminalColor, backgroundTerminalColor, null, null, false, false, false, false);
    }

    public TerminalStyle setForeground(TerminalColor foregroundTerminalColor) {
        return TerminalStyle.getStyle(foregroundTerminalColor, this.fBackgroundTerminalColor, null, this.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setBackground(TerminalColor backgroundTerminalColor) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, backgroundTerminalColor, this.fForegroundRGB, null, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setForeground(RGB foregroundRGB) {
        return TerminalStyle.getStyle(null, this.fBackgroundTerminalColor, foregroundRGB, this.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setBackground(RGB backgroundRGB) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, null, this.fForegroundRGB, backgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setForeground(TerminalStyle other) {
        return TerminalStyle.getStyle(other.fForegroundTerminalColor, this.fBackgroundTerminalColor, other.fForegroundRGB, this.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setBackground(TerminalStyle other) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, other.fBackgroundTerminalColor, this.fForegroundRGB, other.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setForeground(int eightBitindexedColor) {
        boolean isIndexTerminalColor = TerminalColor.isIndexedTerminalColor(eightBitindexedColor);
        if (isIndexTerminalColor) {
            TerminalColor foregroundTerminalColor = TerminalColor.getIndexedTerminalColor(eightBitindexedColor);
            return TerminalStyle.getStyle(foregroundTerminalColor, this.fBackgroundTerminalColor, null, this.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
        }
        RGB foregroundRGB = TerminalColor.getIndexedRGBColor(eightBitindexedColor);
        return TerminalStyle.getStyle(null, this.fBackgroundTerminalColor, foregroundRGB, this.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setBackground(int eightBitindexedColor) {
        boolean isIndexTerminalColor = TerminalColor.isIndexedTerminalColor(eightBitindexedColor);
        if (isIndexTerminalColor) {
            TerminalColor backgroundTerminalColor = TerminalColor.getIndexedTerminalColor(eightBitindexedColor);
            return TerminalStyle.getStyle(this.fForegroundTerminalColor, backgroundTerminalColor, this.fForegroundRGB, null, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
        }
        RGB backgroundRGB = TerminalColor.getIndexedRGBColor(eightBitindexedColor);
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, null, this.fForegroundRGB, backgroundRGB, this.fBold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setBold(boolean bold) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, this.fBackgroundTerminalColor, this.fForegroundRGB, this.fBackgroundRGB, bold, this.fBlink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setBlink(boolean blink) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, this.fBackgroundTerminalColor, this.fForegroundRGB, this.fBackgroundRGB, this.fBold, blink, this.fUnderline, this.fReverse);
    }

    public TerminalStyle setUnderline(boolean underline) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, this.fBackgroundTerminalColor, this.fForegroundRGB, this.fBackgroundRGB, this.fBold, this.fBlink, underline, this.fReverse);
    }

    public TerminalStyle setReverse(boolean reverse) {
        return TerminalStyle.getStyle(this.fForegroundTerminalColor, this.fBackgroundTerminalColor, this.fForegroundRGB, this.fBackgroundRGB, this.fBold, this.fBlink, this.fUnderline, reverse);
    }

    public TerminalColor getForegroundTerminalColor() {
        return this.fForegroundTerminalColor;
    }

    public TerminalColor getBackgroundTerminalColor() {
        return this.fBackgroundTerminalColor;
    }

    public RGB getForegroundRGB() {
        return this.fForegroundRGB;
    }

    public RGB getBackgroundRGB() {
        return this.fBackgroundRGB;
    }

    public boolean isBlink() {
        return this.fBlink;
    }

    public boolean isBold() {
        return this.fBold;
    }

    public boolean isReverse() {
        return this.fReverse;
    }

    public boolean isUnderline() {
        return this.fUnderline;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fBackgroundTerminalColor == null ? 0 : this.fBackgroundTerminalColor.hashCode());
        result = 31 * result + (this.fBackgroundRGB == null ? 0 : this.fBackgroundRGB.hashCode());
        result = 31 * result + (this.fBlink ? 1231 : 1237);
        result = 31 * result + (this.fBold ? 1231 : 1237);
        result = 31 * result + (this.fForegroundTerminalColor == null ? 0 : this.fForegroundTerminalColor.hashCode());
        result = 31 * result + (this.fForegroundRGB == null ? 0 : this.fForegroundRGB.hashCode());
        result = 31 * result + (this.fReverse ? 1231 : 1237);
        result = 31 * result + (this.fUnderline ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalStyle other = (TerminalStyle)obj;
        if (this.fBackgroundTerminalColor != other.fBackgroundTerminalColor) {
            return false;
        }
        if (this.fBackgroundRGB == null ? other.fBackgroundRGB != null : !this.fBackgroundRGB.equals((Object)other.fBackgroundRGB)) {
            return false;
        }
        if (this.fBlink != other.fBlink) {
            return false;
        }
        if (this.fBold != other.fBold) {
            return false;
        }
        if (this.fForegroundTerminalColor != other.fForegroundTerminalColor) {
            return false;
        }
        if (this.fForegroundRGB == null ? other.fForegroundRGB != null : !this.fForegroundRGB.equals((Object)other.fForegroundRGB)) {
            return false;
        }
        if (this.fReverse != other.fReverse) {
            return false;
        }
        return this.fUnderline == other.fUnderline;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Style(foreground=");
        if (this.fForegroundTerminalColor != null) {
            result.append((Object)this.fForegroundTerminalColor);
        } else {
            result.append(this.fForegroundRGB);
        }
        result.append(", background=");
        if (this.fForegroundTerminalColor != null) {
            result.append((Object)this.fBackgroundTerminalColor);
        } else {
            result.append(this.fBackgroundRGB);
        }
        if (this.fBlink) {
            result.append(", blink");
        }
        if (this.fBold) {
            result.append(", bold");
        }
        if (this.fBlink) {
            result.append(", blink");
        }
        if (this.fReverse) {
            result.append(", reverse");
        }
        if (this.fUnderline) {
            result.append(", underline");
        }
        result.append(")");
        return result.toString();
    }
}

