/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.markup.block;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class EclipseErrorDetailsBlock
extends Block {
    private static final Pattern START_PATTERN = Pattern.compile("\\s*-- Error Details --.*");
    private int blockLineCount = 0;

    @Override
    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && START_PATTERN.matcher(line).matches()) {
            this.blockLineCount = 0;
            return true;
        }
        return false;
    }

    @Override
    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            Attributes attributes = new Attributes();
            attributes.setCssClass("eclipseErrorDetails");
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, attributes);
        } else if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        this.builder.characters(offset > 0 ? line.substring(offset) : line);
        this.builder.characters("\n");
        return -1;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

