/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.DeleteBranchOperationUI;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class DeleteBranchOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Ref> branchesToDelete;
        List<Ref> branchesOfCommit;
        int totalBranchCount;
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        IStructuredSelection selection = this.getSelection(event);
        try {
            totalBranchCount = this.getBranchesOfCommit(selection, repository, false).size();
            branchesOfCommit = this.getBranchesOfCommit(selection, repository, true);
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.AbstractHistoryCommitHandler_cantGetBranches, (Throwable)e);
        }
        if (branchesOfCommit.isEmpty()) {
            return null;
        }
        Shell shell = this.getPart(event).getSite().getShell();
        if (totalBranchCount > 1) {
            BranchSelectionDialog<Ref> dlg = new BranchSelectionDialog<Ref>(shell, branchesOfCommit, UIText.DeleteBranchOnCommitHandler_DeleteBranchesDialogTitle, UIText.DeleteBranchOnCommitHandler_DeleteBranchesDialogMessage, UIText.DeleteBranchOnCommitHandler_DeleteBranchesDialogButton, 2);
            if (dlg.open() != 0) {
                return null;
            }
            branchesToDelete = dlg.getSelectedNodes();
        } else {
            branchesToDelete = branchesOfCommit;
        }
        if (!branchesToDelete.isEmpty()) {
            try {
                DeleteBranchOperationUI.deleteBranches(repository, branchesToDelete);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(UIText.RepositoriesView_BranchDeletionFailureMessage, e.getCause());
            }
        }
        return null;
    }

    public boolean isEnabled() {
        List<Ref> branchesOfCommit;
        GitHistoryPage page = this.getPage();
        Repository repository = this.getRepository(page);
        if (repository == null) {
            return false;
        }
        try {
            branchesOfCommit = this.getBranchesOfCommit(this.getSelection(page), repository, true);
        }
        catch (IOException e) {
            Activator.logError(UIText.AbstractHistoryCommitHandler_cantGetBranches, e);
            return false;
        }
        return !branchesOfCommit.isEmpty();
    }
}

