/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

abstract class AbstractPolyPoly
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    private static final int EMF_N_POLYS_OFFSET = 16;
    private static final int EMF_COUNT_POINTS_OFFSET = 20;
    private static final int EMF_COUNTS_OFFSET = 24;
    private static final int WMF_N_POLYS_OFFSET = 0;
    private static final int WMF_COUNTS_OFFSET = 2;
    private int m_nPolys = 0;
    private int m_nPoints = 0;
    private int[] m_nPointsInPoly = null;
    private int[] m_xPointList = null;
    private int[] m_yPointList = null;
    private boolean m_b16Bit = true;

    public AbstractPolyPoly(boolean b16Bit) {
        this.m_b16Bit = b16Bit;
    }

    @Override
    public void readWMFRecord(Record emr) throws IOException {
        this.m_nPolys = emr.getShortAt(0);
        this.m_nPointsInPoly = new int[this.m_nPolys];
        this.m_nPoints = 0;
        int i = 0;
        while (i < this.m_nPolys) {
            this.m_nPointsInPoly[i] = emr.getShortAt(2 + i * 2);
            this.m_nPoints += this.m_nPointsInPoly[i];
            ++i;
        }
        this.m_xPointList = new int[this.m_nPoints];
        this.m_yPointList = new int[this.m_nPoints];
        int curOffset = 2 + this.m_nPolys * 2;
        int i2 = 0;
        while (i2 < this.m_nPoints) {
            this.m_xPointList[i2] = emr.getShortAt(curOffset);
            this.m_yPointList[i2] = emr.getShortAt(curOffset + 2);
            curOffset += 4;
            ++i2;
        }
    }

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_nPolys = emr.getIntAt(16);
        this.m_nPoints = emr.getIntAt(20);
        this.m_nPointsInPoly = new int[this.m_nPolys];
        this.m_xPointList = new int[this.m_nPoints];
        this.m_yPointList = new int[this.m_nPoints];
        int i = 0;
        while (i < this.m_nPolys) {
            this.m_nPointsInPoly[i] = emr.getIntAt(24 + i * 4);
            ++i;
        }
        int curOffset = 24 + this.m_nPolys * 4;
        int i2 = 0;
        while (i2 < this.m_nPoints) {
            if (this.m_b16Bit) {
                this.m_xPointList[i2] = emr.getShortAt(curOffset);
                this.m_yPointList[i2] = emr.getShortAt(curOffset + 2);
                curOffset += 4;
            } else {
                this.m_xPointList[i2] = emr.getIntAt(curOffset);
                this.m_yPointList[i2] = emr.getIntAt(curOffset + 4);
                curOffset += 8;
            }
            ++i2;
        }
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        int curOffset = 0;
        int i = 0;
        while (i < this.m_nPolys) {
            int numPoints = this.m_nPointsInPoly[i];
            int[] xPoints = new int[numPoints];
            int[] yPoints = new int[numPoints];
            int j = 0;
            while (j < numPoints) {
                xPoints[j] = context.convertXToSVGLogicalUnits(this.m_xPointList[curOffset]);
                yPoints[j] = context.convertYToSVGLogicalUnits(this.m_yPointList[curOffset]);
                ++curOffset;
                ++j;
            }
            this.renderPoly(g, context, xPoints, yPoints, numPoints);
            ++i;
        }
    }

    @Override
    public void render(DeviceContext context) throws TranscoderException {
        int curOffset = 0;
        GeneralPath p = new GeneralPath();
        int i = 0;
        while (i < this.m_nPolys) {
            int numPoints = this.m_nPointsInPoly[i];
            int[] xPoints = new int[numPoints];
            int[] yPoints = new int[numPoints];
            int j = 0;
            while (j < numPoints) {
                xPoints[j] = context.convertXToSVGLogicalUnits(this.m_xPointList[curOffset]);
                yPoints[j] = context.convertYToSVGLogicalUnits(this.m_yPointList[curOffset]);
                ++curOffset;
                ++j;
            }
            this.renderPoly(p, xPoints, yPoints, numPoints);
            ++i;
        }
        context.getGdiPath().appendFigure(p);
    }

    protected abstract boolean renderPoly(Graphics2D var1, DeviceContext var2, int[] var3, int[] var4, int var5);

    protected abstract boolean renderPoly(GeneralPath var1, int[] var2, int[] var3, int var4);
}

