/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMappingWithRanges;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class HorizontalBranchingMappingStrategyWithRanges
extends HorizontalBranchingMappingStrategy {
    private boolean copyOnBranch;

    @Override
    public boolean hasDeltaSupport() {
        return true;
    }

    public boolean shallCopyOnBranch() {
        return this.copyOnBranch;
    }

    @Override
    protected IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    @Override
    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMappingWithRanges(this, containingClass, feature);
    }

    @Override
    protected void rawExportList(CDODataOutput out, IDBConnection connection, IListMapping listMapping, IDBTable attrTable, String attrSuffix) throws IOException {
        super.rawExportList(out, connection, listMapping, attrTable, attrSuffix);
        for (IDBTable table : listMapping.getDBTables()) {
            this.rawExportListPostProcess(out, connection, attrTable, attrSuffix, table);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rawExportListPostProcess(CDODataOutput out, IDBConnection connection, IDBTable attrTable, String attrSuffix, IDBTable table) throws IOException {
        builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_ID));
        builder.append(", l_t.");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_BRANCH));
        builder.append(", l_t.");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_ADDED));
        builder.append(", l_t.");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED));
        builder.append(", l_t.");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_IDX));
        builder.append(" FROM ");
        builder.append(table);
        builder.append(" l_t, ");
        builder.append(attrTable);
        builder.append(" a_t");
        builder.append(attrSuffix);
        builder.append(this.getListJoinForPostProcess("a_t", "l_t"));
        builder.append(" AND l_t.");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED));
        builder.append(" IS NOT NULL");
        sql = DBUtil.trace((String)builder.toString());
        idHandler = this.getStore().getIDHandler();
        stmt = connection.prepareStatement(sql, 1004, 1007, IDBPreparedStatement.ReuseProbability.MEDIUM);
        resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            size = DBUtil.getRowCount((ResultSet)resultSet);
            out.writeXInt(size);
            ** if (size != 0) goto lbl56
        }
        catch (Throwable var17_18) {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            throw var17_18;
        }
lbl-1000:
        // 1 sources

        {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return;
        }
lbl56:
        // 1 sources

        ** GOTO lbl75
        {
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
lbl-1000:
        // 1 sources

        {
            source = idHandler.getCDOID((ResultSet)resultSet, 1);
            branch = resultSet.getInt(2);
            versionAdded = resultSet.getInt(3);
            versionRemoved = resultSet.getInt(4);
            idx = resultSet.getInt(5);
            out.writeCDOID(source);
            out.writeXInt(branch);
            out.writeXInt(versionAdded);
            out.writeXInt(versionRemoved);
            out.writeXInt(idx);
lbl75:
            // 2 sources

            ** while (resultSet.next())
        }
lbl76:
        // 1 sources

        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    protected void rawImportList(CDODataInput in, IDBConnection connection, IListMapping listMapping, OMMonitor monitor) throws IOException {
        Collection<IDBTable> tables = listMapping.getDBTables();
        int size = tables.size();
        if (size == 0) {
            return;
        }
        monitor.begin((double)(2 * size));
        try {
            super.rawImportList(in, connection, listMapping, monitor.fork((double)size));
            for (IDBTable table : tables) {
                this.rawImportListPostProcess(in, connection, table, monitor.fork());
            }
        }
        finally {
            monitor.done();
        }
    }

    private void rawImportListPostProcess(CDODataInput in, IDBConnection connection, IDBTable table, OMMonitor monitor) throws IOException {
        int size = in.readXInt();
        if (size == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(table);
        builder.append(" SET ");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED));
        builder.append("=? WHERE ");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_ID));
        builder.append("=? AND ");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_BRANCH));
        builder.append("=? AND ");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_ADDED));
        builder.append("=? AND ");
        builder.append(DBUtil.quoted((String)MappingNames.LIST_IDX));
        builder.append("=?");
        String sql = DBUtil.trace((String)builder.toString());
        IIDHandler idHandler = this.getStore().getIDHandler();
        IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        monitor.begin((double)(1 + 2 * size));
        try {
            try {
                monitor.worked();
                int row = 0;
                while (row < size) {
                    CDOID source = in.readCDOID();
                    int branch = in.readXInt();
                    int versionAdded = in.readXInt();
                    int versionRemoved = in.readXInt();
                    int idx = in.readXInt();
                    stmt.setInt(1, versionRemoved);
                    idHandler.setCDOID((PreparedStatement)stmt, 2, source);
                    stmt.setInt(3, branch);
                    stmt.setInt(4, versionAdded);
                    stmt.setInt(5, idx);
                    stmt.addBatch();
                    monitor.worked();
                    ++row;
                }
                OMMonitor.Async async = monitor.forkAsync((double)size);
                try {
                    stmt.executeBatch();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
            monitor.done();
        }
    }

    protected String getListJoinForPostProcess(String attrTable, String listTable) {
        String join = this.getListJoinBasic(attrTable, listTable);
        return this.modifyListJoin2(attrTable, listTable, join, true, true);
    }

    @Override
    protected String modifyListJoin(String attrTable, String listTable, String join, boolean forRawExport) {
        return this.modifyListJoin2(attrTable, listTable, join, forRawExport, false);
    }

    private String modifyListJoin2(String attrTable, String listTable, String join, boolean forRawExport, boolean forPostProcess) {
        join = String.valueOf(join) + " AND " + listTable + ".";
        if (forRawExport) {
            join = forPostProcess ? String.valueOf(join) + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED) : String.valueOf(join) + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_ADDED);
            join = String.valueOf(join) + "=" + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION);
        } else {
            join = String.valueOf(join) + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_ADDED);
            join = String.valueOf(join) + "<=" + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION);
            join = String.valueOf(join) + " AND (" + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED);
            join = String.valueOf(join) + " IS NULL OR " + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED);
            join = String.valueOf(join) + ">" + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_VERSION) + ")";
        }
        join = String.valueOf(join) + " AND " + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH);
        join = String.valueOf(join) + "=" + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_BRANCH);
        if (forRawExport && !forPostProcess) {
            join = String.valueOf(join) + " ORDER BY " + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_ID);
            join = String.valueOf(join) + ", " + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_BRANCH);
            join = String.valueOf(join) + ", " + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_ADDED);
            join = String.valueOf(join) + ", " + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_IDX);
        }
        return join;
    }

    @Override
    protected DBUtil.DeserializeRowHandler getImportListHandler() {
        return new ImportListHandler();
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        String value = this.getProperties().get("copyOnBranch");
        this.copyOnBranch = value == null ? false : Boolean.valueOf(value);
    }

    private final class ImportListHandler
    implements DBUtil.DeserializeRowHandler {
        private final IIDHandler idHandler;
        private IDBPreparedStatement stmt;

        private ImportListHandler() {
            this.idHandler = HorizontalBranchingMappingStrategyWithRanges.this.getStore().getIDHandler();
        }

        public void handleRow(ExtendedDataInput in, Connection connection, IDBField[] fields, Object[] values) throws SQLException, IOException {
            int versionAdded = DBUtil.asInt((Object)values[2]);
            if (versionAdded == 1) {
                return;
            }
            if (this.stmt == null) {
                String sql = "UPDATE " + fields[0].getTable() + " SET " + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED) + "=?" + " WHERE " + DBUtil.quoted((String)MappingNames.LIST_REVISION_ID) + "=?" + " AND " + DBUtil.quoted((String)MappingNames.LIST_REVISION_BRANCH) + "=?" + " AND " + DBUtil.quoted((String)MappingNames.LIST_IDX) + "=?" + " AND " + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_ADDED) + "<?" + " AND " + DBUtil.quoted((String)MappingNames.LIST_REVISION_VERSION_REMOVED) + " IS NULL";
                this.stmt = ((IDBConnection)connection).prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
            }
            Object sourceID = values[0];
            int branch = DBUtil.asInt((Object)values[1]);
            int index = DBUtil.asInt((Object)values[4]);
            this.stmt.setInt(1, versionAdded);
            this.idHandler.setCDOIDRaw((PreparedStatement)this.stmt, 2, sourceID);
            this.stmt.setInt(3, branch);
            this.stmt.setInt(4, index);
            this.stmt.setInt(5, versionAdded);
            this.stmt.addBatch();
        }

        public void done(boolean successful) throws SQLException, IOException {
            if (this.stmt != null) {
                try {
                    if (successful) {
                        this.stmt.executeBatch();
                    }
                }
                finally {
                    DBUtil.close((Statement)this.stmt);
                    this.stmt = null;
                }
            }
        }
    }
}

