/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.ui;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.util.CacheHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.SiriusDragEditPartsTrackerEx;
import org.eclipse.sirius.ext.base.Option;

public class SequenceDragEditPartsTrackerEx
extends SiriusDragEditPartsTrackerEx {
    public SequenceDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected boolean handleButtonUp(int button) {
        SequenceCacheDragTrackerHelper.handleButtonUp((IGraphicalEditPart)this.getSourceEditPart());
        return super.handleButtonUp(button);
    }

    protected boolean handleButtonDown(int button) {
        boolean handleButtonDown = super.handleButtonDown(button);
        SequenceCacheDragTrackerHelper.handleButtonDown((IGraphicalEditPart)this.getSourceEditPart());
        return handleButtonDown;
    }

    public static final class SequenceCacheDragTrackerHelper {
        private SequenceCacheDragTrackerHelper() {
        }

        public static void handleButtonUp(IGraphicalEditPart smep) {
            SequenceDiagram diagram = SequenceCacheDragTrackerHelper.getSequenceDiagram(smep);
            if (diagram != null) {
                diagram.useCache(false);
                diagram.clearAllCaches();
            }
            CacheHelper.setStructuralCacheEnabled((boolean)false);
            CacheHelper.setVerticalRangeCacheEnabled((boolean)false);
            CacheHelper.clearCaches();
        }

        public static void handleButtonDown(IGraphicalEditPart smep) {
            CacheHelper.clearCaches();
            CacheHelper.setStructuralCacheEnabled((boolean)true);
            CacheHelper.setVerticalRangeCacheEnabled((boolean)true);
            SequenceDiagram diagram = SequenceCacheDragTrackerHelper.getSequenceDiagram(smep);
            if (diagram != null) {
                diagram.useCache(true);
            }
        }

        private static SequenceDiagram getSequenceDiagram(IGraphicalEditPart smep) {
            View notationView;
            Option iSequenceElement;
            SequenceDiagram diagram = null;
            if (smep != null && (iSequenceElement = ISequenceElementAccessor.getISequenceElement((View)(notationView = smep.getNotationView()))).some()) {
                diagram = ((ISequenceElement)iSequenceElement.get()).getDiagram();
            }
            return diagram;
        }
    }
}

