/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.util.List;
import org.eclipse.emf.cdo.CDONotification;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.object.CDOLegacyWrapper;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOLegacyAdapter
extends CDOLegacyWrapper
implements Adapter.Internal {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyAdapter.class);
    public static boolean extendedLegacyAttachmentChecks = true;

    public CDOLegacyAdapter(InternalEObject object) {
        super(object);
        this.instance.eAdapters().add((Object)this);
        ((BasicNotifierImpl.EObservableAdapterList)this.instance.eAdapters()).addListener((BasicNotifierImpl.EObservableAdapterList.Listener)new AdapterListListener());
    }

    public void setTarget(Notifier newTarget) {
        this.instance = (InternalEObject)newTarget;
    }

    public void unsetTarget(Notifier oldTarget) {
        if (this.instance == oldTarget) {
            this.instance = null;
        }
    }

    public Notifier getTarget() {
        return this.instance;
    }

    public boolean isAdapterForType(Object type) {
        return type == CDOLegacyAdapter.class;
    }

    public void notifyChanged(Notification msg) {
        if (msg.isTouch() || msg instanceof CDONotification) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)msg.getFeature();
        if (feature == null) {
            return;
        }
        if (this.viewAndState.view == null || !(this.viewAndState.view instanceof CDOTransaction)) {
            return;
        }
        int featureID = this.eClass().getFeatureID(feature);
        boolean persistent = this.cdoClassInfo().isPersistent(featureID);
        if (persistent || extendedLegacyAttachmentChecks) {
            int eventType = msg.getEventType();
            int position = msg.getPosition();
            Object oldValue = msg.getOldValue();
            Object newValue = msg.getNewValue();
            switch (eventType) {
                case 1: {
                    this.notifySet(feature, persistent, position, oldValue, newValue);
                    break;
                }
                case 2: {
                    this.notifyUnset(feature, persistent, oldValue);
                    break;
                }
                case 7: {
                    this.notifyMove(feature, persistent, position, oldValue);
                    break;
                }
                case 3: {
                    this.notifyAdd(feature, persistent, position, newValue);
                    break;
                }
                case 5: {
                    this.notifyAddMany(feature, persistent, position, newValue);
                    break;
                }
                case 4: {
                    this.notifyRemove(feature, persistent, position, oldValue);
                    break;
                }
                case 6: {
                    if (newValue != null && !(newValue instanceof int[])) {
                        throw new IllegalArgumentException("New value of REMOVE_MANY notification is not an array of indices.");
                    }
                    this.notifyRemoveMany(feature, persistent, (int[])newValue);
                }
            }
            this.instanceToRevisionContainment();
        }
    }

    protected void notifySet(EStructuralFeature feature, boolean persistent, int position, Object oldValue, Object newValue) {
        EReference reference;
        CDOStore store = this.viewAndState.view.getStore();
        if (persistent) {
            if (newValue == null && feature.isUnsettable() && position == -1) {
                store.set(this.instance, feature, position, EStructuralFeature.Internal.DynamicValueHolder.NIL);
            } else {
                store.set(this.instance, feature, position, newValue);
            }
        }
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            if (oldValue != null) {
                InternalEObject oldChild = (InternalEObject)oldValue;
                this.setContainer(store, oldChild, null, -1, persistent);
            }
            if (newValue != null) {
                InternalEObject newChild = (InternalEObject)newValue;
                this.setContainer(store, newChild, this, newChild.eContainerFeatureID(), persistent);
            }
        }
    }

    protected void notifyUnset(EStructuralFeature feature, boolean persistent, Object oldValue) {
        EReference reference;
        CDOStore store = this.viewAndState.view.getStore();
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            List list = (List)oldValue;
            for (Object child : list) {
                if (child == null) continue;
                this.setContainer(store, (InternalEObject)child, null, -1, persistent);
            }
        }
        if (persistent) {
            store.unset(this.instance, feature);
        }
    }

    protected void notifyMove(EStructuralFeature feature, boolean persistent, int position, Object oldValue) {
        if (persistent) {
            CDOStore store = this.viewAndState.view.getStore();
            store.move(this.instance, feature, position, (Integer)oldValue);
        }
    }

    protected void notifyAdd(EStructuralFeature feature, boolean persistent, int position, Object newValue) {
        EReference reference;
        CDOStore store = this.viewAndState.view.getStore();
        if (persistent) {
            store.add(this.instance, feature, position, newValue);
        }
        if (newValue != null && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            InternalEObject newChild = (InternalEObject)newValue;
            this.setContainer(store, newChild, this, newChild.eContainerFeatureID(), persistent);
        }
    }

    protected void notifyAddMany(EStructuralFeature feature, boolean persistent, int position, Object newValue) {
        CDOStore store = this.viewAndState.view.getStore();
        int pos = position;
        List list = (List)newValue;
        for (Object object : list) {
            EReference reference;
            if (persistent) {
                store.add(this.instance, feature, pos++, object);
            }
            if (object == null || !(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) continue;
            InternalEObject newChild = (InternalEObject)object;
            this.setContainer(store, newChild, this, newChild.eContainerFeatureID(), persistent);
        }
    }

    protected void notifyRemove(EStructuralFeature feature, boolean persistent, int position, Object oldValue) {
        EReference reference;
        CDOStore store = this.viewAndState.view.getStore();
        Object oldChild = null;
        oldChild = persistent ? store.remove(this.instance, feature, position) : oldValue;
        if (oldChild instanceof InternalEObject && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            InternalEObject oldChildEObject = (InternalEObject)oldChild;
            this.setContainer(store, oldChildEObject, null, -1, persistent);
        }
    }

    protected void notifyRemoveMany(EStructuralFeature feature, boolean persistent, int[] positions) {
        block7: {
            CDOStore store;
            block6: {
                EReference reference;
                store = this.viewAndState.view.getStore();
                if (positions != null) break block6;
                Object[] oldChildren = store.toArray(this.instance, feature);
                if (persistent) {
                    store.clear(this.instance, feature);
                }
                if (!(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) break block7;
                int i = 0;
                while (i < oldChildren.length) {
                    Object oldChild = oldChildren[i];
                    if (oldChild instanceof InternalEObject) {
                        this.setContainer(store, (InternalEObject)oldChild, null, -1, persistent);
                    }
                    ++i;
                }
                break block7;
            }
            Object[] oldChildren = null;
            if (!persistent) {
                oldChildren = store.toArray(this.instance, feature);
            }
            int i = positions.length - 1;
            while (i >= 0) {
                EReference reference;
                Object oldChild = null;
                oldChild = persistent ? store.remove(this.instance, feature, positions[i]) : oldChildren[i];
                if (oldChild instanceof InternalEObject && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                    InternalEObject oldChildEObject = (InternalEObject)oldChild;
                    this.setContainer(store, oldChildEObject, null, -1, persistent);
                }
                --i;
            }
        }
    }

    private void setContainer(CDOStore store, InternalEObject object, InternalEObject container, int containingFeatureID, boolean featurePersistent) {
        boolean objectPersistent;
        if (object instanceof CDOObjectImpl) {
            return;
        }
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)object);
        boolean bl = objectPersistent = !FSMUtil.isTransient(cdoObject);
        if (extendedLegacyAttachmentChecks) {
            Resource.Internal directResource = object.eDirectResource();
            if (container == null) {
                if (!(directResource instanceof CDOResource) && objectPersistent) {
                    CDOStateMachine.INSTANCE.detach((InternalCDOObject)cdoObject);
                    objectPersistent = false;
                }
            } else if (directResource == null || directResource instanceof CDOResource) {
                CDOObject cdoContainer = CDOUtil.getCDOObject((EObject)container);
                if (featurePersistent) {
                    boolean containerPersistent;
                    boolean bl2 = containerPersistent = !FSMUtil.isTransient(cdoContainer);
                    if (!containerPersistent) {
                        featurePersistent = false;
                    }
                }
                if (featurePersistent && !objectPersistent) {
                    InternalCDOTransaction transaction = (InternalCDOTransaction)cdoContainer.cdoView();
                    CDOStateMachine.INSTANCE.attach((InternalCDOObject)cdoObject, transaction);
                    objectPersistent = true;
                }
            }
        }
        if (!objectPersistent) {
            return;
        }
        store.setContainer(object, null, container, containingFeatureID);
    }

    protected class AdapterListListener
    implements BasicNotifierImpl.EObservableAdapterList.Listener {
        public void added(Notifier notifier, Adapter adapter) {
            InternalCDOView view;
            if (TRACER.isEnabled()) {
                TRACER.format("Added : {0} to {1} ", new Object[]{adapter, CDOLegacyAdapter.this});
            }
            if (!FSMUtil.isTransient(CDOLegacyAdapter.this) && (view = CDOLegacyAdapter.this.cdoView()) != null && view.isActive()) {
                view.handleAddAdapter(CDOLegacyAdapter.this, adapter);
            }
        }

        public void removed(Notifier notifier, Adapter adapter) {
            InternalCDOView view;
            if (TRACER.isEnabled()) {
                TRACER.format("Removed : {0} from {1} ", new Object[]{adapter, CDOLegacyAdapter.this});
            }
            if (!FSMUtil.isTransient(CDOLegacyAdapter.this) && (view = CDOLegacyAdapter.this.cdoView()) != null && view.isActive()) {
                view.handleRemoveAdapter(CDOLegacyAdapter.this, adapter);
            }
        }
    }
}

