/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.comparator;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparableComparator;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorChain;
import org.eclipse.jpt.common.utility.internal.comparator.FalsesFirstBooleanComparator;
import org.eclipse.jpt.common.utility.internal.comparator.NullsFirstComparator;
import org.eclipse.jpt.common.utility.internal.comparator.NullsLastComparator;
import org.eclipse.jpt.common.utility.internal.comparator.ReverseComparator;
import org.eclipse.jpt.common.utility.internal.comparator.StringCollator;
import org.eclipse.jpt.common.utility.internal.comparator.TransformationComparator;
import org.eclipse.jpt.common.utility.internal.comparator.TruesFirstBooleanComparator;
import org.eclipse.jpt.common.utility.internal.comparator.VersionComparator;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class ComparatorTools {
    public static final Comparator<String> INTEGER_VERSION_COMPARATOR = ComparatorTools.versionComparator(VersionComparator.SegmentParser.IntegerSegmentParser.instance());

    public static <E extends Comparable<E>> E min(E o1, E o2) {
        return o1.compareTo(o2) < 0 ? o1 : o2;
    }

    public static <E> E min(E o1, E o2, Comparator<? super E> comparator) {
        return comparator.compare(o1, o2) < 0 ? o1 : o2;
    }

    public static <E extends Comparable<E>> E max(E o1, E o2) {
        return o1.compareTo(o2) > 0 ? o1 : o2;
    }

    public static <E> E max(E o1, E o2, Comparator<? super E> comparator) {
        return comparator.compare(o1, o2) > 0 ? o1 : o2;
    }

    public static Comparator<Boolean> booleanComparator(boolean trueFirst) {
        return trueFirst ? ComparatorTools.truesFirstBooleanComparator() : ComparatorTools.falsesFirstBooleanComparator();
    }

    public static Comparator<Boolean> falsesFirstBooleanComparator() {
        return FalsesFirstBooleanComparator.instance();
    }

    public static Comparator<Boolean> truesFirstBooleanComparator() {
        return TruesFirstBooleanComparator.instance();
    }

    @SafeVarargs
    public static <E> Comparator<E> chain(Comparator<? super E> ... comparators) {
        return ComparatorTools.chain(ArrayTools.iterable(comparators));
    }

    public static <E> Comparator<E> chain(Iterable<Comparator<? super E>> comparators) {
        return new ComparatorChain<E>(comparators);
    }

    public static <E extends Comparable<E>> Comparator<E> comparableComparator() {
        return ComparableComparator.instance();
    }

    public static <E extends Comparable<E>> Comparator<E> naturalComparator() {
        return ComparatorTools.comparableComparator();
    }

    public static <E> Comparator<E> nullsFirst(Comparator<? super E> comparator) {
        return new NullsFirstComparator<E>(comparator);
    }

    public static <E> Comparator<E> nullsLast(Comparator<? super E> comparator) {
        return new NullsLastComparator<E>(comparator);
    }

    public static <E extends Comparable<E>> Comparator<E> reverseComparator() {
        return ComparatorTools.reverse(ComparatorTools.comparableComparator());
    }

    public static <E> Comparator<E> reverse(Comparator<? super E> comparator) {
        return new ReverseComparator<E>(comparator);
    }

    public static Comparator<String> stringCollator() {
        return ComparatorTools.stringCollator(Collator.getInstance());
    }

    public static Comparator<String> stringCollator(Locale locale) {
        return ComparatorTools.stringCollator(Collator.getInstance(locale));
    }

    public static Comparator<String> stringCollator(Collator collator) {
        return new StringCollator(collator);
    }

    public static <E, O> Comparator<E> transformationComparator(Transformer<? super E, ? extends O> transformer) {
        return ComparatorTools.transformationComparator(transformer, ComparatorTools.comparableComparator());
    }

    public static <E, O> Comparator<E> transformationComparator(Transformer<? super E, ? extends O> transformer, Comparator<O> comparator) {
        return new TransformationComparator<E, O>(transformer, comparator);
    }

    public static <T extends Comparable<T>> Comparator<String> integerVersionComparator() {
        return INTEGER_VERSION_COMPARATOR;
    }

    public static <T extends Comparable<T>> Comparator<String> versionComparator(VersionComparator.SegmentParser<T> segmentParser) {
        return ComparatorTools.versionComparator(".", segmentParser);
    }

    public static <T extends Comparable<T>> Comparator<String> versionComparator(char delimiter, VersionComparator.SegmentParser<T> segmentParser) {
        return ComparatorTools.versionComparator(new char[]{delimiter}, segmentParser);
    }

    public static <T extends Comparable<T>> Comparator<String> versionComparator(char[] delimiters, VersionComparator.SegmentParser<T> segmentParser) {
        return ComparatorTools.versionComparator(new String(delimiters), segmentParser);
    }

    public static <T extends Comparable<T>> Comparator<String> versionComparator(String delimiters, VersionComparator.SegmentParser<T> segmentParser) {
        return new VersionComparator<T>(delimiters, segmentParser);
    }

    private ComparatorTools() {
        throw new UnsupportedOperationException();
    }
}

