/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.util.MatcherAdaper;

public class Textile {
    private static final String REGEX_TEXTILE_CLASS_ID = "(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))";
    private static final String REGEX_TEXTILE_STYLE = "(?:\\{([^\\{\\}]+)\\})";
    private static final String REGEX_LANGUAGE = "(?:\\[([^\\[\\]]+)\\])";
    public static final String REGEX_ATTRIBUTES = "(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}";
    public static final String REGEX_BLOCK_ATTRIBUTES = "(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}";
    public static final int ATTRIBUTES_GROUP_COUNT = 4;
    public static final int ATTRIBUTES_BLOCK_GROUP_COUNT = 7;
    private static final Pattern explicitBlockBeginPattern = Pattern.compile("(((h[1-6])|p|pre|bc|bq|table|###)|(fn([0-9]{1,2})))(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}\\.\\.?\\s+.*");
    private static final Map<String, String> alignmentToStyle = new HashMap<String, String>();

    static {
        alignmentToStyle.put("<", "text-align: left;");
        alignmentToStyle.put(">", "text-align: right;");
        alignmentToStyle.put("=", "text-align: center;");
        alignmentToStyle.put("<>", "text-align: justify;");
    }

    public static Attributes configureAttributes(Attributes attributes, Matcher matcher, int offset, boolean block) {
        return Textile.configureAttributes((org.eclipse.mylyn.wikitext.parser.util.Matcher)new MatcherAdaper(matcher), attributes, offset, block);
    }

    private static void appendStyles(Attributes attributes, String cssStyles) {
        if (cssStyles == null || cssStyles.length() == 0) {
            return;
        }
        Object styles = attributes.getCssStyle();
        if (styles == null) {
            attributes.setCssStyle(cssStyles);
        } else {
            styles = ((String)styles).endsWith(";") ? (String)styles + " " : (String)styles + "; ";
            styles = (String)styles + cssStyles;
            attributes.setCssStyle((String)styles);
        }
    }

    public static Attributes configureAttributes(org.eclipse.mylyn.wikitext.parser.util.Matcher matcher, Attributes attributes, int offset, boolean block) {
        if (offset < 1) {
            throw new IllegalArgumentException();
        }
        if (block) {
            String alignment;
            String padding = matcher.group(offset);
            if (padding != null) {
                Textile.appendStyles(attributes, "padding-left: " + padding.length() + "em;");
            }
            if ((padding = matcher.group(++offset)) != null) {
                Textile.appendStyles(attributes, "padding-right: " + padding.length() + "em;");
            }
            if ((alignment = matcher.group(++offset)) != null) {
                Textile.appendStyles(attributes, alignmentToStyle.get(alignment));
            }
            ++offset;
        }
        String cssClass2 = matcher.group(offset);
        String id = matcher.group(offset + 1);
        String cssStyles2 = matcher.group(offset + 2);
        String language = matcher.group(offset + 3);
        if (id != null && attributes.getId() == null) {
            attributes.setId(id);
        }
        if (attributes.getCssClass() != null || cssClass2 != null) {
            attributes.setCssClass((String)(attributes.getCssClass() == null ? cssClass2 : (cssClass2 == null ? attributes.getCssClass() : attributes.getCssClass() + " " + cssClass2)));
        }
        Textile.appendStyles(attributes, cssStyles2);
        attributes.setLanguage(language);
        return attributes;
    }

    public static boolean explicitBlockBegins(String line, int offset) {
        if (offset != 0) {
            return false;
        }
        return explicitBlockBeginPattern.matcher(line).matches();
    }
}

