/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.activities.InternalActivityHelper;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryLabelProvider;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.CategorizedActivity;

public class ActivityEnabler {
    private static final int ALL = 2;
    private static final int NONE = 0;
    private static final int SOME = 1;
    protected CheckboxTreeViewer dualViewer;
    private Set<String> managedActivities = new HashSet<String>(7);
    protected ActivityCategoryContentProvider provider = new ActivityCategoryContentProvider();
    protected Text descriptionText;
    private Properties strings;
    private IMutableActivityManager activitySupport;
    private TableViewer dependantViewer;
    private ISelectionChangedListener selectionListener = event -> {
        Object element = event.getStructuredSelection().getFirstElement();
        try {
            if (element instanceof ICategory) {
                this.descriptionText.setText(((ICategory)element).getDescription());
            } else if (element instanceof IActivity) {
                this.descriptionText.setText(((IActivity)element).getDescription());
            }
        }
        catch (NotDefinedException e) {
            this.descriptionText.setText("");
        }
    };
    private ICheckStateListener checkListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            HashSet<Object> checked = new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements()));
            Object element = event.getElement();
            if (element instanceof ICategory) {
                ActivityEnabler.this.dualViewer.setSubtreeChecked(element, event.getChecked());
                ActivityEnabler.this.dualViewer.setGrayed(element, false);
                Object[] objectArray = ActivityEnabler.this.provider.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object categoryActivity = objectArray[n2];
                    this.handleDuplicateActivities(event.getChecked(), categoryActivity);
                    ++n2;
                }
            } else {
                this.handleActivityCheck(checked, element);
                this.handleDuplicateActivities(event.getChecked(), element);
            }
        }

        private void handleDuplicateActivities(boolean checkedState, Object element) {
            Object[] duplicateActivities;
            Object[] objectArray = duplicateActivities = ActivityEnabler.this.provider.getDuplicateCategoryActivities((CategorizedActivity)element);
            int n = duplicateActivities.length;
            int n2 = 0;
            while (n2 < n) {
                Object activity = objectArray[n2];
                ActivityEnabler.this.dualViewer.setChecked(activity, checkedState);
                this.handleActivityCheck(new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements())), activity);
                ++n2;
            }
        }

        private void handleActivityCheck(Set<Object> checked, Object element) {
            CategorizedActivity proxy = (CategorizedActivity)element;
            Object[] children = ActivityEnabler.this.provider.getChildren(proxy.getCategory());
            int state = 0;
            int count = 0;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (checked.contains(child)) {
                    ++count;
                }
                ++n2;
            }
            if (count == children.length) {
                state = 2;
            } else if (count != 0) {
                state = 1;
            }
            if (state == 0) {
                checked.remove(proxy.getCategory());
            } else {
                checked.add(proxy.getCategory());
            }
            ActivityEnabler.this.dualViewer.setGrayed((Object)proxy.getCategory(), state == 1);
            ActivityEnabler.this.dualViewer.setCheckedElements(checked.toArray());
            this.handleRequiredActivities(checked, element);
        }

        private void handleRequiredActivities(Set<?> checked, Object element) {
            Object[] requiredActivities = null;
            if (checked.contains(element)) {
                Object[] objectArray = requiredActivities = ActivityEnabler.this.provider.getChildRequiredActivities(((CategorizedActivity)element).getId());
                int n = requiredActivities.length;
                int n2 = 0;
                while (n2 < n) {
                    Object activity = objectArray[n2];
                    if (!checked.contains(activity)) {
                        ActivityEnabler.this.dualViewer.setChecked(activity, true);
                        this.handleActivityCheck(new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements())), activity);
                    }
                    ++n2;
                }
            } else {
                Object[] objectArray = requiredActivities = ActivityEnabler.this.provider.getParentRequiredActivities(((CategorizedActivity)element).getId());
                int n = requiredActivities.length;
                int n3 = 0;
                while (n3 < n) {
                    Object requiredActivity = objectArray[n3];
                    if (checked.contains(requiredActivity)) {
                        ActivityEnabler.this.dualViewer.setChecked(requiredActivity, false);
                        this.handleActivityCheck(new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements())), requiredActivity);
                    }
                    ++n3;
                }
            }
        }
    };

    public ActivityEnabler(IMutableActivityManager activitySupport, Properties strings) {
        this.activitySupport = activitySupport;
        this.strings = strings;
    }

    public Control createControl(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        new Label(composite, 0).setText(this.strings.getProperty("activityName", ActivityMessages.ActivityEnabler_activities));
        new Label(composite, 0).setText(ActivityMessages.ActivityEnabler_description);
        this.dualViewer = new CheckboxTreeViewer(composite);
        this.dualViewer.setComparator(new ViewerComparator());
        this.dualViewer.setLabelProvider((IBaseLabelProvider)new ActivityCategoryLabelProvider());
        this.dualViewer.setContentProvider((IContentProvider)this.provider);
        this.dualViewer.setInput((Object)this.activitySupport);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.dualViewer.getControl().setLayoutData((Object)data);
        Composite detailsComp = new Composite(composite, 0);
        detailsComp.setLayout((Layout)new GridLayout());
        detailsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionText = new Text(detailsComp, 2632);
        data = new GridData(4, 4, true, false);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)5);
        this.descriptionText.setLayoutData((Object)data);
        this.setInitialStates();
        new Label(detailsComp, 0).setText(ActivityMessages.ActivitiesPreferencePage_requirements);
        this.dependantViewer = new TableViewer(detailsComp, 2048);
        this.dependantViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.dependantViewer.setContentProvider((IContentProvider)new ActivityCategoryContentProvider());
        this.dependantViewer.setLabelProvider((IBaseLabelProvider)new ActivityCategoryLabelProvider());
        this.dependantViewer.setInput((Object)Collections.EMPTY_SET);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)this.createGridLayoutWithoutMargins(2, fontMetrics));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(ActivityMessages.ActivityEnabler_selectAll);
        selectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleTreeEnablement(true)));
        this.setButtonLayoutData(selectAllButton, fontMetrics);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(ActivityMessages.ActivityEnabler_deselectAll);
        deselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleTreeEnablement(false)));
        this.setButtonLayoutData(deselectAllButton, fontMetrics);
        this.dualViewer.addCheckStateListener(this.checkListener);
        this.dualViewer.addSelectionChangedListener(this.selectionListener);
        this.dualViewer.setSelection((ISelection)new StructuredSelection());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private GridLayout createGridLayoutWithoutMargins(int nColumns, FontMetrics fontMetrics) {
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        layout.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        return layout;
    }

    private GridData setButtonLayoutData(Button button, FontMetrics fontMetrics) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void setInitialStates() {
        Set<String> enabledActivities = this.activitySupport.getEnabledActivityIds();
        this.setEnabledStates(enabledActivities);
    }

    private void setEnabledStates(Set<String> enabledActivities) {
        Set<String> categories = this.activitySupport.getDefinedCategoryIds();
        ArrayList<Comparable<IActivity>> checked = new ArrayList<Comparable<IActivity>>(10);
        ArrayList<ICategory> grayed = new ArrayList<ICategory>(10);
        for (String categoryId : categories) {
            ICategory category = this.activitySupport.getCategory(categoryId);
            int state = 0;
            Set<String> activities = InternalActivityHelper.getActivityIdsForCategory(this.activitySupport, category);
            int foundCount = 0;
            for (String activityId : activities) {
                this.managedActivities.add(activityId);
                if (!enabledActivities.contains(activityId)) continue;
                IActivity activity = this.activitySupport.getActivity(activityId);
                checked.add(new CategorizedActivity(category, activity));
                ++foundCount;
            }
            if (foundCount == activities.size()) {
                state = 2;
            } else if (foundCount > 0) {
                state = 1;
            }
            if (state == 0) continue;
            checked.add(category);
            if (state != 1) continue;
            grayed.add(category);
        }
        this.dualViewer.setCheckedElements(checked.toArray());
        this.dualViewer.setGrayedElements(grayed.toArray());
    }

    public void updateActivityStates() {
        HashSet<String> enabledActivities = new HashSet<String>(this.activitySupport.getEnabledActivityIds());
        enabledActivities.removeAll(this.managedActivities);
        Object[] objectArray = this.dualViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!(element instanceof ICategory) && !this.dualViewer.getGrayed(element)) {
                enabledActivities.add(((IActivity)element).getId());
            }
            ++n2;
        }
        this.activitySupport.setEnabledActivityIds(enabledActivities);
    }

    public void restoreDefaults() {
        HashSet<String> defaultEnabled = new HashSet<String>();
        Set<String> activityIds = this.activitySupport.getDefinedActivityIds();
        for (String activityId : activityIds) {
            IActivity activity = this.activitySupport.getActivity(activityId);
            try {
                if (!activity.isDefaultEnabled()) continue;
                defaultEnabled.add(activityId);
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
        this.setEnabledStates(defaultEnabled);
    }

    protected void toggleTreeEnablement(boolean enabled) {
        Object[] elements = this.provider.getElements(this.activitySupport);
        this.dualViewer.setGrayedElements(new Object[0]);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.dualViewer.expandToLevel(element, -1);
            this.dualViewer.setSubtreeChecked(element, enabled);
            ++n2;
        }
    }
}

