/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.lemminx.utils.LevenshteinDistance;

public class StringUtils {
    public static final String[] EMPTY_STRING = new String[0];
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final Collection<String> TRUE_FALSE_ARRAY = Arrays.asList("true", "false");
    private static final float MAX_DISTANCE_DIFF_RATIO = 0.4f;

    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    public static boolean isWhitespace(String value, int index) {
        return StringUtils.isWhitespace(value, index, value.length());
    }

    public static boolean isWhitespace(String value, int index, int end) {
        if (value == null) {
            return false;
        }
        while (index < end) {
            char c = value.charAt(index);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isWhitespace(String value) {
        return StringUtils.isWhitespace(value, 0);
    }

    public static boolean isBlank(String value) {
        return StringUtils.isEmpty(value) || StringUtils.isWhitespace(value);
    }

    public static void normalizeSpace(String str, StringBuilder b) {
        String space = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                if (i == 0 || Character.isWhitespace(str.charAt(i - 1))) continue;
                space = " ";
                continue;
            }
            b.append(space);
            space = "";
            b.append(c);
        }
    }

    public static String normalizeSpace(String str) {
        StringBuilder b = new StringBuilder(str.length());
        StringUtils.normalizeSpace(str, b);
        return b.toString();
    }

    public static String getStartWhitespaces(String lineText) {
        return StringUtils.getWhitespaces(lineText, 0, lineText.length());
    }

    public static String getWhitespaces(String text, int start, int end) {
        char c;
        StringBuilder whitespaces = new StringBuilder();
        for (int i = start; i < end && Character.isWhitespace(c = text.charAt(i)); ++i) {
            whitespaces.append(c);
        }
        return whitespaces.toString();
    }

    public static void trimNewLines(String value, StringBuilder s) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        boolean hasNewLine = false;
        int start = 0;
        for (st = 0; st < len && Character.isWhitespace(val[st]); ++st) {
            if (val[st] == '\r' || val[st] == '\n') {
                hasNewLine = true;
                continue;
            }
            if (hasNewLine) break;
        }
        if (hasNewLine) {
            start = st;
            if (st > 0 && st < len && val[st - 1] == '\r' && val[st] == '\n') {
                ++start;
            }
        }
        hasNewLine = false;
        int end = len;
        while (st < len && Character.isWhitespace(val[len - 1])) {
            if (val[len - 1] == '\r' || val[len - 1] == '\n') {
                hasNewLine = true;
            } else if (hasNewLine) break;
            --len;
        }
        if (hasNewLine) {
            end = len;
            if (val[len - 1] == '\r' && val[len] == '\n') {
                --end;
            }
        }
        s.append(value, start, end);
    }

    public static String trimNewLines(String value) {
        StringBuilder s = new StringBuilder();
        StringUtils.trimNewLines(value, s);
        return s.toString();
    }

    public static String lTrim(String value) {
        int len = value.length();
        int i = 0;
        char[] val = value.toCharArray();
        char c = val[i];
        while (i < value.length() && Character.isWhitespace(c)) {
            c = val[++i];
        }
        return value.substring(i, len);
    }

    public static int getNumberOfNewLines(String text, boolean isWhitespace, String delimiter, int newLineLimit) {
        if (!isWhitespace) {
            return 0;
        }
        int newLineCounter = 0;
        boolean delimiterHasTwoCharacters = delimiter.length() == 2;
        for (int i = 0; newLineCounter <= newLineLimit && i < text.length(); ++i) {
            String c;
            if (delimiterHasTwoCharacters) {
                if (i + 1 >= text.length() || !delimiter.equals(c = text.substring(i, i + 2))) continue;
                ++newLineCounter;
                ++i;
                continue;
            }
            c = String.valueOf(text.charAt(i));
            if (!delimiter.equals(c)) continue;
            ++newLineCounter;
        }
        return newLineCounter;
    }

    public static String getDefaultString(String text) {
        if (text != null) {
            return text;
        }
        return "";
    }

    public static int getOffsetAfterWhitespace(String text, int endOffset) {
        if (text == null || endOffset <= 0 || endOffset > text.length()) {
            return -1;
        }
        char c = text.charAt(endOffset - 1);
        int i = endOffset;
        if (!Character.isWhitespace(c)) {
            while (!Character.isWhitespace(c) && --i > 0) {
                c = text.charAt(i - 1);
            }
            return i;
        }
        return -1;
    }

    public static int getFrontWhitespaceLength(String text) {
        if (StringUtils.isWhitespace(text)) {
            return text.length();
        }
        int i = 0;
        while (Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return i;
    }

    public static int getTrailingWhitespaceLength(String text) {
        if (StringUtils.isWhitespace(text)) {
            return text.length();
        }
        int i = text.length() - 1;
        while (Character.isWhitespace(text.charAt(i))) {
            --i;
        }
        return text.length() - i - 1;
    }

    public static String cleanPathForWindows(String pathString) {
        if (pathString.startsWith("/") && pathString.length() > 3) {
            char letter = pathString.charAt(1);
            char colon = pathString.charAt(2);
            if (Character.isLetter(letter) && ':' == colon) {
                pathString = pathString.substring(1);
            }
        }
        pathString = pathString.replace("/", "\\");
        return pathString;
    }

    public static String escapeBackticks(String text) {
        StringBuilder b = new StringBuilder(text);
        for (int i = text.length() - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (c != '`') continue;
            b.insert(i, "\\");
        }
        return b.toString();
    }

    public static boolean isTagOutsideOfBackticks(String text) {
        boolean inBacktick = false;
        block0: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '`') {
                if (inBacktick) {
                    inBacktick = false;
                    continue;
                }
                inBacktick = true;
                continue;
            }
            if (c != '<') continue;
            ++i;
            while (i < text.length()) {
                c = text.charAt(i);
                if (c == '`') {
                    --i;
                    continue block0;
                }
                if (c == '>') {
                    if (inBacktick) continue block0;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static int findStartWord(String text, int offset, Predicate<Character> isValidChar) {
        return StringUtils.findStartWord(text, offset, 0, isValidChar);
    }

    public static int findStartWord(String text, int offset, int min, Predicate<Character> isValidChar) {
        if (offset < 0 || offset >= text.length()) {
            return -1;
        }
        for (int i = offset - 1; i >= min; --i) {
            if (isValidChar.test(Character.valueOf(text.charAt(i)))) continue;
            return i + 1;
        }
        return min;
    }

    public static int findEndWord(String text, int offset, Predicate<Character> isValidChar) {
        return StringUtils.findEndWord(text, offset, text.length(), isValidChar);
    }

    public static int findEndWord(String text, int offset, int max, Predicate<Character> isValidChar) {
        if (offset < 0 || offset >= text.length() || !isValidChar.test(Character.valueOf(text.charAt(offset)))) {
            return -1;
        }
        for (int i = offset + 1; i < max; ++i) {
            if (isValidChar.test(Character.valueOf(text.charAt(i)))) continue;
            return i;
        }
        return max;
    }

    public static String convertToQuotelessValue(String value) {
        if (value == null || !StringUtils.isQuoted(value)) {
            return value;
        }
        return value.substring(1, value.length() - 1);
    }

    public static boolean isQuoted(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        char quoteValueStart = value.charAt(0);
        if (quoteValueStart != '\"' && quoteValueStart != '\'') {
            return false;
        }
        char quoteValueEnd = value.charAt(value.length() - 1);
        return quoteValueEnd == quoteValueStart;
    }

    public static boolean isSimilar(String reference, String current) {
        int threshold = Math.round(0.4f * (float)reference.length());
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance(threshold);
        return levenshteinDistance.apply(reference, current) != -1;
    }
}

