/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class StringUtils {
    public static final int ALIGN_LEFT = -1;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_RIGHT = 1;

    public static String align(String s, int width, int alignment) {
        return StringUtils.align(s, width, ' ', alignment);
    }

    public static String align(String s, int width, char paddingChar, int alignment) {
        if (s.length() < width) {
            int diff = width - s.length();
            String left = "";
            String right = "";
            if (alignment == 0) {
                int numLeftChars = diff / 2;
                int numRightChars = numLeftChars + diff % 2;
                left = StringUtils.multiply(paddingChar, numLeftChars);
                right = StringUtils.multiply(paddingChar, numRightChars);
            } else if (alignment < 0) {
                right = StringUtils.multiply(paddingChar, diff);
            } else {
                left = StringUtils.multiply(paddingChar, diff);
            }
            s = left + s + right;
        }
        return s;
    }

    public static void align(PrintWriter output, String s, int width, int alignment) {
        StringUtils.align(output, s, width, ' ', alignment);
    }

    public static void align(PrintWriter output, String s, int width, char paddingChar, int alignment) {
        if (s.length() < width) {
            int diff = width - s.length();
            if (alignment == 0) {
                int numLeftChars = diff / 2;
                int numRightChars = numLeftChars + diff % 2;
                StringUtils.multiply(output, paddingChar, numLeftChars);
                output.write(s);
                StringUtils.multiply(output, paddingChar, numRightChars);
            } else if (alignment < 0) {
                output.write(s);
                StringUtils.multiply(output, paddingChar, diff);
            } else {
                StringUtils.multiply(output, paddingChar, diff);
                output.write(s);
            }
        } else {
            output.write(s);
        }
    }

    public static String multiply(char c, int count) {
        return StringUtils.multiply(String.valueOf(c), count);
    }

    public static String multiply(String s, int count) {
        if (count < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static void multiply(PrintWriter output, char c, int count) {
        for (int i = 0; i < count; ++i) {
            output.write(c);
        }
    }

    public static void multiply(PrintWriter output, String s, int count) {
        for (int i = 0; i < count; ++i) {
            output.write(s);
        }
    }

    public static String prependEachLine(String s, String prependWith) {
        StringWriter sw = new StringWriter(s.length() + prependWith.length() * 20);
        StringUtils.prependEachLine(new PrintWriter(sw), s, prependWith);
        return sw.toString();
    }

    public static void prependEachLine(PrintWriter output, String s, String prependWith) {
        if (s.length() == 0) {
            return;
        }
        output.write(prependWith);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            output.write(c);
            if (c != '\n' && c != '\r' && c != '\f') continue;
            output.write(prependWith);
        }
    }
}

