/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualSecondaryTable;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.SecondaryTablePrimaryKeyJoinColumnValidator;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericOrmSecondaryTable
extends AbstractOrmTable<OrmEntity, OrmSpecifiedSecondaryTable.ParentAdapter, XmlSecondaryTable>
implements OrmSpecifiedSecondaryTable {
    protected XmlSecondaryTable xmlSecondaryTable;
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedPrimaryKeyJoinColumn, XmlPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumnContainer;
    protected final BaseJoinColumn.ParentAdapter primaryKeyJoinColumnParentAdapter = this.buildPrimaryKeyJoinColumnParentAdapter();
    protected OrmSpecifiedPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;

    public GenericOrmSecondaryTable(OrmSpecifiedSecondaryTable.ParentAdapter parentAdapter, XmlSecondaryTable xmlSecondaryTable) {
        super(parentAdapter, xmlSecondaryTable);
        this.specifiedPrimaryKeyJoinColumnContainer = this.buildSpecifiedPrimaryKeyJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncSpecifiedPrimaryKeyJoinColumns(monitor);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn.synchronizeWithResourceModel(monitor);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedPrimaryKeyJoinColumns(), monitor);
        this.updateDefaultPrimaryKeyJoinColumn(monitor);
    }

    @Override
    public XmlSecondaryTable getXmlTable() {
        return this.xmlSecondaryTable;
    }

    @Override
    protected void setXmlTable(XmlSecondaryTable xmlTable) {
        this.xmlSecondaryTable = xmlTable;
    }

    @Override
    protected XmlSecondaryTable buildXmlTable() {
        throw new IllegalStateException("XML secondary table is missing");
    }

    @Override
    protected void removeXmlTable() {
    }

    @Override
    public ListIterable<OrmSpecifiedPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumns() : this.getDefaultPrimaryKeyJoinColumns();
    }

    @Override
    public int getPrimaryKeyJoinColumnsSize() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumnsSize() : this.getDefaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterable<OrmSpecifiedPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumnContainer;
    }

    @Override
    public OrmSpecifiedPrimaryKeyJoinColumn getSpecifiedPrimaryKeyJoinColumn(int index) {
        return (OrmSpecifiedPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.get(index);
    }

    @Override
    public int getSpecifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumnContainer.size();
    }

    protected boolean hasSpecifiedPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumnsSize() != 0;
    }

    @Override
    public OrmSpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn() {
        return this.addSpecifiedPrimaryKeyJoinColumn(this.getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    @Override
    public OrmSpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        XmlPrimaryKeyJoinColumn xmlJoinColumn = this.buildXmlPrimaryKeyJoinColumn();
        OrmSpecifiedPrimaryKeyJoinColumn joinColumn = (OrmSpecifiedPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        this.xmlSecondaryTable.getPrimaryKeyJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlPrimaryKeyJoinColumn buildXmlPrimaryKeyJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn();
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(SpecifiedPrimaryKeyJoinColumn joinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnContainer.indexOf((OrmSpecifiedPrimaryKeyJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        this.specifiedPrimaryKeyJoinColumnContainer.remove(index);
        this.xmlSecondaryTable.getPrimaryKeyJoinColumns().remove(index);
    }

    @Override
    public void convertDefaultPrimaryKeyJoinColumnsToSpecified() {
        if (this.defaultPrimaryKeyJoinColumn == null) {
            throw new IllegalStateException("default PK join column is null");
        }
        String columnName = this.defaultPrimaryKeyJoinColumn.getDefaultName();
        String referencedColumnName = this.defaultPrimaryKeyJoinColumn.getDefaultReferencedColumnName();
        OrmSpecifiedPrimaryKeyJoinColumn pkJoinColumn = this.addSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumn.setSpecifiedName(columnName);
        pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
    }

    @Override
    public void clearSpecifiedPrimaryKeyJoinColumns() {
        this.specifiedPrimaryKeyJoinColumnContainer.clear();
        this.xmlSecondaryTable.getPrimaryKeyJoinColumns().clear();
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedPrimaryKeyJoinColumnContainer.move(targetIndex, sourceIndex);
        this.xmlSecondaryTable.getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedPrimaryKeyJoinColumns(IProgressMonitor monitor) {
        this.specifiedPrimaryKeyJoinColumnContainer.synchronizeWithResourceModel(monitor);
    }

    protected ListIterable<XmlPrimaryKeyJoinColumn> getXmlPrimaryKeyJoinColumns() {
        return IterableTools.cloneLive(this.xmlSecondaryTable.getPrimaryKeyJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedPrimaryKeyJoinColumn, XmlPrimaryKeyJoinColumn> buildSpecifiedPrimaryKeyJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedPrimaryKeyJoinColumns", new SpecifiedPrimaryKeyJoinColumnContainerAdapter());
    }

    protected BaseJoinColumn.ParentAdapter buildPrimaryKeyJoinColumnParentAdapter() {
        return new PrimaryKeyJoinColumnParentAdapter();
    }

    @Override
    public OrmSpecifiedPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(OrmSpecifiedPrimaryKeyJoinColumn joinColumn) {
        OrmSpecifiedPrimaryKeyJoinColumn old = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = joinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmSpecifiedPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        return this.defaultPrimaryKeyJoinColumn != null ? new SingleElementListIterable((Object)this.defaultPrimaryKeyJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultPrimaryKeyJoinColumn(IProgressMonitor monitor) {
        if (this.buildsDefaultPrimaryKeyJoinColumn()) {
            if (this.defaultPrimaryKeyJoinColumn == null) {
                this.setDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(null));
            } else {
                this.defaultPrimaryKeyJoinColumn.update(monitor);
            }
        } else {
            this.setDefaultPrimaryKeyJoinColumn(null);
        }
    }

    protected boolean buildsDefaultPrimaryKeyJoinColumn() {
        return !this.hasSpecifiedPrimaryKeyJoinColumns();
    }

    protected OrmEntity getEntity() {
        return (OrmEntity)this.parent;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public void initializeFrom(OrmVirtualSecondaryTable oldTable) {
        super.initializeFrom(oldTable);
        for (OrmVirtualPrimaryKeyJoinColumn pkJoinColumn : oldTable.getSpecifiedPrimaryKeyJoinColumns()) {
            this.addSpecifiedPrimaryKeyJoinColumn().initializeFrom(pkJoinColumn);
        }
    }

    protected OrmSpecifiedPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn xmlJoinColumn) {
        return this.getContextModelFactory().buildOrmPrimaryKeyJoinColumn(this.primaryKeyJoinColumnParentAdapter, xmlJoinColumn);
    }

    @Override
    protected String buildDefaultName() {
        return null;
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.connectionProfileIsActive();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateModels((Iterable<? extends JpaContextModel>)this.getPrimaryKeyJoinColumns(), messages, reporter);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedPrimaryKeyJoinColumn column : this.getPrimaryKeyJoinColumns()) {
            result = column.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public class PrimaryKeyJoinColumnParentAdapter
    implements BaseJoinColumn.ParentAdapter {
        @Override
        public JpaContextModel getColumnParent() {
            return GenericOrmSecondaryTable.this;
        }

        protected OrmEntity getEntity() {
            return GenericOrmSecondaryTable.this.getEntity();
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmSecondaryTable.this.getName();
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            if (this.getJoinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = this.getEntity().getParentEntity();
            return parentEntity != null ? parentEntity.getPrimaryKeyColumnName() : this.getEntity().getPrimaryKeyColumnName();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return GenericOrmSecondaryTable.this.getDbTable();
        }

        @Override
        public int getJoinColumnsSize() {
            return GenericOrmSecondaryTable.this.getPrimaryKeyJoinColumnsSize();
        }

        @Override
        public Table getReferencedColumnDbTable() {
            return this.getEntity().getPrimaryDbTable();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmSecondaryTable.this.getValidationTextRange();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new SecondaryTablePrimaryKeyJoinColumnValidator(GenericOrmSecondaryTable.this, (BaseJoinColumn)column, (BaseJoinColumn.ParentAdapter)this);
        }
    }

    public class SpecifiedPrimaryKeyJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedPrimaryKeyJoinColumn, XmlPrimaryKeyJoinColumn> {
        @Override
        public OrmSpecifiedPrimaryKeyJoinColumn buildContextElement(XmlPrimaryKeyJoinColumn resourceElement) {
            return GenericOrmSecondaryTable.this.buildPrimaryKeyJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<XmlPrimaryKeyJoinColumn> getResourceElements() {
            return GenericOrmSecondaryTable.this.getXmlPrimaryKeyJoinColumns();
        }

        @Override
        public XmlPrimaryKeyJoinColumn extractResourceElement(OrmSpecifiedPrimaryKeyJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

