/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;
import org.eclipse.wst.server.ui.internal.editor.StatusLineContributionItem;

public class ServerEditorActionBarContributor
extends EditorActionBarContributor {
    public static final String SERVER_EDITOR_SEPARATOR = "server-editor-additions";
    protected ServerEditor editor;

    public void setActiveEditor(IEditorPart targetEditor) {
        IStatusLineManager status;
        super.setActiveEditor(targetEditor);
        if (targetEditor != null && targetEditor.equals((Object)this.editor)) {
            return;
        }
        IActionBars actionBars = this.getActionBars();
        boolean actionBarsUpdated = false;
        if (this.editor != null) {
            this.editor.setStatus(null, null);
            status = actionBars.getStatusLineManager();
            status.removeAll();
            IToolBarManager tbm = actionBars.getToolBarManager();
            tbm.removeAll();
            actionBarsUpdated = true;
        }
        if (targetEditor instanceof ServerEditor) {
            this.editor = (ServerEditor)targetEditor;
            if (Trace.FINEST) {
                Trace.trace("/finest", "Editor action bar contributor for: " + String.valueOf((Object)this.editor));
            }
            this.editor.updateUndoAction();
            this.editor.updateRedoAction();
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.editor.getUndoAction());
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.editor.getRedoAction());
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.editor.getCopyAction());
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.editor.getCutAction());
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.editor.getPasteAction());
            status = actionBars.getStatusLineManager();
            StatusLineContributionItem item = new StatusLineContributionItem("id");
            status.add((IContributionItem)item);
            this.editor.setStatus(status, item);
            this.editor.updateStatusLine();
            IAction[] actions = this.editor.getEditorActions();
            IToolBarManager tbm = actionBars.getToolBarManager();
            tbm.add((IContributionItem)new Separator(SERVER_EDITOR_SEPARATOR));
            boolean modified = false;
            if (actions != null) {
                int size = actions.length;
                if (Trace.FINEST) {
                    Trace.trace("/finest", "Attempting to add editor actions: " + size);
                }
                int i = 0;
                while (i < size) {
                    if (Trace.FINEST) {
                        Trace.trace("/finest", "action: " + String.valueOf(actions[i]));
                    }
                    tbm.appendToGroup(SERVER_EDITOR_SEPARATOR, actions[i]);
                    modified = true;
                    ++i;
                }
            }
            if (modified) {
                tbm.update(false);
            }
            actionBarsUpdated = true;
        } else {
            this.editor = null;
        }
        if (actionBarsUpdated) {
            actionBars.updateActionBars();
        }
    }
}

