/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.util;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.enablement.oda.ws.impl.Driver;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class WSUIUtil {
    public static void checkExisted(DataSetDesign design) {
        if (design.getPublicProperties() == null) {
            try {
                design.setPublicProperties(DesignSessionUtil.createDataSetPublicProperties((String)design.getOdaExtensionDataSourceId(), (String)design.getOdaExtensionDataSetId(), (Properties)new Properties()));
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        if (design.getPrivateProperties() == null) {
            try {
                design.setPrivateProperties(DesignSessionUtil.createDataSetNonPublicProperties((String)design.getOdaExtensionDataSourceId(), (String)design.getOdaExtensionDataSetId(), (Properties)WSUIUtil.getDataSetInitialPrivateProperties()));
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
    }

    private static Properties getDataSetInitialPrivateProperties() {
        Properties props = new Properties();
        props.setProperty("operationTrace", "");
        props.setProperty("xmlQueryText", "");
        return props;
    }

    public static void savePage(DataSetDesign dataSetDesign) {
        block6: {
            if (!WSConsole.getInstance().isSessionOK()) {
                return;
            }
            IConnection conn = null;
            try {
                try {
                    Driver driver = new Driver();
                    conn = driver.getConnection(null);
                    Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)dataSetDesign.getDataSourceDesign());
                    conn.open(connProps);
                    WSUIUtil.updateDesign(dataSetDesign, conn, dataSetDesign.getQueryText());
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    WSUIUtil.closeConnection(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                WSUIUtil.closeConnection(conn);
                throw throwable;
            }
            WSUIUtil.closeConnection(conn);
        }
    }

    public static SOAPParameter[] getUsedParameter(SOAPParameter[] parameters) {
        int usedNum = 0;
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].isUsed()) {
                ++usedNum;
            }
            ++i;
        }
        SOAPParameter[] result = new SOAPParameter[usedNum];
        int resultPtr = 0;
        int i2 = 0;
        while (i2 < parameters.length) {
            if (parameters[i2].isUsed()) {
                SOAPParameter tParameter = new SOAPParameter(resultPtr + 1, parameters[i2].getName(), parameters[i2].getType(), parameters[i2].getDefaultValue());
                tParameter.setMaxOccurs(parameters[i2].getMaxOccurs());
                tParameter.setMinOccurs(parameters[i2].getMinOccurs());
                tParameter.setUsed(parameters[i2].isUsed());
                result[resultPtr] = tParameter;
                ++resultPtr;
            }
            ++i2;
        }
        return result;
    }

    private static void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        SOAPParameter[] soapParameters = WSConsole.getInstance().getParameters();
        soapParameters = WSUIUtil.getUsedParameter(soapParameters);
        if (!WSUtil.isNull((Object)soapParameters)) {
            int i = 0;
            while (i < soapParameters.length) {
                if (!WSUtil.isNull((Object)soapParameters[i])) {
                    query.setString(soapParameters[i].getId(), soapParameters[i].getDefaultValue());
                }
                ++i;
            }
        }
        query.setProperty("xmlQueryText", dataSetDesign.getPrivateProperties().getProperty("xmlQueryText"));
        query.setProperty("operationTrace", WSConsole.getInstance().getPropertyValue("operationTrace"));
        try {
            IResultSetMetaData md = query.getMetaData();
            WSUIUtil.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException odaException) {
            dataSetDesign.setResultSets(null);
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            WSUIUtil.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException odaException) {
            dataSetDesign.setParameters(null);
        }
        query.close();
    }

    private static void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private static void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (WSUtil.isNull((Object)paramDesign)) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0) {
            WSConsole.getInstance().merge2ParameterDefinitions(paramDesign.getParameterDefinitions());
        }
    }

    private static void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }
}

