/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;

public class ASTNodeSearchUtil {
    private ASTNodeSearchUtil() {
    }

    public static ASTNode[] getAstNodes(SearchMatch[] searchResults, JavaScriptUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.getAstNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode getAstNode(SearchMatch searchResult, JavaScriptUnit cuNode) {
        ASTNode selectedNode = ASTNodeSearchUtil.getAstNode(cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }

    public static ASTNode getAstNode(JavaScriptUnit cuNode, int start, int length) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(start, length), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode node = analyzer.getFirstSelectedNode();
        if (node == null && analyzer.getLastCoveringNode() instanceof SuperConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        } else if (node == null && analyzer.getLastCoveringNode() instanceof ConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        }
        if (node == null) {
            return null;
        }
        ASTNode parentNode = node.getParent();
        if (parentNode instanceof FunctionDeclaration) {
            FunctionDeclaration md = (FunctionDeclaration)parentNode;
            if (!(node instanceof SimpleName) && md.isConstructor() && md.getBody() != null && md.getBody().statements().size() > 0 && (md.getBody().statements().get(0) instanceof ConstructorInvocation || md.getBody().statements().get(0) instanceof SuperConstructorInvocation) && ((ASTNode)md.getBody().statements().get(0)).getLength() == length + 1) {
                return (ASTNode)md.getBody().statements().get(0);
            }
        }
        if (parentNode instanceof SuperConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        if (parentNode instanceof ConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        return node;
    }

    public static FunctionDeclaration getMethodDeclarationNode(IFunction iMethod, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (FunctionDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iMethod, cuNode), FunctionDeclaration.class);
    }

    public static BodyDeclaration getMethodOrAnnotationTypeMemberDeclarationNode(IFunction iMethod, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, cuNode);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, JavaScriptUnit cuNode) throws JavaScriptModelException {
        ASTNode node = ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode);
        if (node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(node, VariableDeclarationFragment.class);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (FieldDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode), FieldDeclaration.class);
    }

    public static BodyDeclaration getFieldOrEnumConstantDeclaration(IField iField, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return ASTNodeSearchUtil.getFieldDeclarationNode(iField, cuNode);
    }

    public static BodyDeclaration getBodyDeclarationNode(IMember iMember, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (BodyDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iMember, cuNode), BodyDeclaration.class);
    }

    public static AbstractTypeDeclaration getAbstractTypeDeclarationNode(IType iType, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (AbstractTypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), AbstractTypeDeclaration.class);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (TypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), TypeDeclaration.class);
    }

    public static ClassInstanceCreation getClassInstanceCreationNode(IType iType, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (ClassInstanceCreation)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), ClassInstanceCreation.class);
    }

    public static List getBodyDeclarationList(IType iType, JavaScriptUnit cuNode) throws JavaScriptModelException {
        if (iType.isAnonymous()) {
            return ASTNodeSearchUtil.getClassInstanceCreationNode(iType, cuNode).getAnonymousClassDeclaration().bodyDeclarations();
        }
        return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, cuNode).bodyDeclarations();
    }

    public static ASTNode[] getDeclarationNodes(IJavaScriptElement element, JavaScriptUnit cuNode) throws JavaScriptModelException {
        switch (element.getElementType()) {
            case 8: {
                return new ASTNode[]{ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)element, cuNode)};
            }
            case 12: {
                return ASTNodeSearchUtil.getImportNodes((IImportContainer)element, cuNode);
            }
            case 13: {
                return new ASTNode[]{ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)element, cuNode)};
            }
            case 10: {
                return new ASTNode[]{ASTNodeSearchUtil.getInitializerNode((IInitializer)element, cuNode)};
            }
            case 9: {
                return new ASTNode[]{ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IFunction)element, cuNode)};
            }
            case 7: {
                return new ASTNode[]{ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)element, cuNode)};
            }
        }
        Assert.isTrue((boolean)false, (String)String.valueOf(element.getElementType()));
        return null;
    }

    private static ASTNode getNameNode(IMember iMember, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return NodeFinder.perform((ASTNode)cuNode, iMember.getNameRange());
    }

    public static ImportDeclaration getImportDeclarationNode(IImportDeclaration reference, JavaScriptUnit cuNode) throws JavaScriptModelException {
        return (ImportDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ASTNode[] getImportNodes(IImportContainer reference, JavaScriptUnit cuNode) throws JavaScriptModelException {
        IJavaScriptElement[] imps = reference.getChildren();
        ASTNode[] result = new ASTNode[imps.length];
        int i = 0;
        while (i < imps.length) {
            result[i] = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)imps[i], cuNode);
            ++i;
        }
        return result;
    }

    public static Initializer getInitializerNode(IInitializer initializer, JavaScriptUnit cuNode) throws JavaScriptModelException {
        ASTNode node = ASTNodeSearchUtil.findNode(initializer.getSourceRange(), cuNode);
        if (node instanceof Initializer) {
            return (Initializer)node;
        }
        if (node instanceof Block && node.getParent() instanceof Initializer) {
            return (Initializer)node.getParent();
        }
        return null;
    }

    private static ASTNode findNode(ISourceRange range, JavaScriptUnit cuNode) {
        NodeFinder nodeFinder = new NodeFinder(range.getOffset(), range.getLength());
        cuNode.accept((ASTVisitor)nodeFinder);
        ASTNode coveredNode = nodeFinder.getCoveredNode();
        if (coveredNode != null) {
            return coveredNode;
        }
        return nodeFinder.getCoveringNode();
    }

    public static ASTNode[] findNodes(SearchMatch[] searchResults, JavaScriptUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.findNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode findNode(SearchMatch searchResult, JavaScriptUnit cuNode) {
        ASTNode selectedNode = NodeFinder.perform((ASTNode)cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }
}

