/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.editor.ui.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.SQLEditorUIService;
import org.eclipse.datatools.sqltools.core.services.SQLUIService;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.editor.ui.core.EditorCoreUIPlugin;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.internal.core.SQLDevToolsUIConfigRegistry;
import org.eclipse.datatools.sqltools.editor.ui.internal.core.SQLDevToolsUIConfigRegistryImpl;
import org.eclipse.datatools.sqltools.plan.IPlanOption;
import org.eclipse.datatools.sqltools.plan.IPlanService;

public class SQLToolsUIFacade {
    private static SQLToolsUIFacade _instance = new SQLToolsUIFacade();

    private SQLToolsUIFacade() {
    }

    public static SQLToolsUIFacade getInstance() {
        return _instance;
    }

    private static SQLDevToolsUIConfigRegistry getRegistry() {
        return EditorCoreUIPlugin.getDatabaseFactoryRegistry();
    }

    public static Collection getConfigurations() {
        Collection c = SQLToolsUIFacade.getRegistry().getConfigurations();
        return c;
    }

    public static Collection getSupportedDBDefinitionNames() {
        Collection c = SQLToolsUIFacade.getRegistry().getConfigurations();
        ArrayList<String> names = new ArrayList<String>();
        for (SQLDevToolsUIConfiguration factory : c) {
            String vendor = factory.getDatabaseVendorDefinitionId().getProductName();
            String version = factory.getDatabaseVendorDefinitionId().getVersion();
            names.add(String.valueOf(vendor) + "_" + version);
        }
        return names;
    }

    public static Collection getConnectibleDBDefinitionNames() {
        Iterator iter = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleProducts();
        ArrayList<String> names = new ArrayList<String>();
        while (iter.hasNext()) {
            String vendor = (String)iter.next();
            Iterator versions = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleVersions(vendor);
            while (versions.hasNext()) {
                String version = (String)versions.next();
                names.add(String.valueOf(vendor) + "_" + version);
            }
        }
        return names;
    }

    public static Collection getAllAvailableDBDefinitionIds() {
        HashSet<DatabaseVendorDefinitionId> ids = new HashSet<DatabaseVendorDefinitionId>();
        Collection c = SQLToolsUIFacade.getRegistry().getConfigurations();
        for (SQLDevToolsUIConfiguration factory : c) {
            ids.add(factory.getDatabaseVendorDefinitionId());
        }
        Iterator iter = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleProducts();
        while (iter.hasNext()) {
            String vendor = (String)iter.next();
            Iterator versions = DatabaseDefinitionRegistryImpl.INSTANCE.getConnectibleVersions(vendor);
            while (versions.hasNext()) {
                String version = (String)versions.next();
                ids.add(new DatabaseVendorDefinitionId(vendor, version));
            }
        }
        return ids;
    }

    public static Collection getAllAvailableDBDefinitionNames() {
        Collection Ids = SQLToolsUIFacade.getAllAvailableDBDefinitionIds();
        TreeSet<String> names = new TreeSet<String>();
        for (DatabaseVendorDefinitionId id : Ids) {
            names.add(id.toString());
        }
        return names;
    }

    public static SQLDevToolsUIConfiguration getConfigurationByDBDefName(String dbDefName) {
        return SQLToolsUIFacade.getConfigurationByVendorIdentifier(new DatabaseVendorDefinitionId(dbDefName));
    }

    public static SQLDevToolsUIConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId vendorId) {
        return SQLToolsUIFacade.getConfiguration(null, vendorId);
    }

    public static SQLDevToolsUIConfiguration getConfigurationByProfileName(String profileName) {
        return SQLToolsUIFacade.getConfigurationByVendorIdentifier(ProfileUtil.getDatabaseVendorDefinitionId((String)profileName));
    }

    public static SQLDevToolsUIConfiguration getConfiguration(DatabaseIdentifier databaseIdentifier, DatabaseVendorDefinitionId vendorId) {
        SQLDevToolsUIConfiguration f = null;
        if (databaseIdentifier != null) {
            f = SQLToolsUIFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        }
        if (f == null && vendorId != null) {
            vendorId = SQLToolsFacade.getCanonicalDatabaseVendorDefinitionId((DatabaseVendorDefinitionId)vendorId);
            f = SQLToolsUIFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        }
        if (f == null) {
            f = SQLToolsUIFacade.getDefaultConfiguration();
        }
        return f;
    }

    public static SQLDevToolsUIConfiguration getDefaultConfiguration() {
        SQLDevToolsUIConfiguration defaultConfiguration = SQLDevToolsUIConfigRegistryImpl.getDefaultConfiguration();
        if (defaultConfiguration == null) {
            defaultConfiguration = SQLDevToolsUIConfiguration.getDefaultInstance();
        }
        return defaultConfiguration;
    }

    public static DatabaseVendorDefinitionId getDefaultDatabaseVendorDefinitionId() {
        return SQLToolsUIFacade.getDefaultConfiguration().getDatabaseVendorDefinitionId();
    }

    public static SQLEditorUIService getSQLEditorService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsUIConfiguration f = SQLToolsUIFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLEditorUIService();
    }

    public static SQLDevToolsUIConfiguration getConfiguration(String dbType, DatabaseIdentifier databaseIdentifier) {
        if (dbType == null) {
            return SQLToolsUIFacade.getConfiguration(databaseIdentifier, null);
        }
        return SQLToolsUIFacade.getConfiguration(databaseIdentifier, new DatabaseVendorDefinitionId(dbType));
    }

    public static IPlanService getPlanService(DatabaseIdentifier databaseIdentifier) {
        SQLDevToolsUIConfiguration f = SQLToolsUIFacade.getConfiguration(null, databaseIdentifier);
        return f.getPlanService();
    }

    public static Collection getPlanOptions() {
        Collection c = SQLToolsUIFacade.getRegistry().getConfigurations();
        int size = c.size();
        SQLDevToolsUIConfiguration[] fs = (SQLDevToolsUIConfiguration[])c.toArray(new SQLDevToolsConfiguration[size]);
        ArrayList<IPlanOption> planOps = new ArrayList<IPlanOption>();
        int i = 0;
        while (i < size) {
            planOps.add(fs[i].getPlanService().getPlanOption());
            ++i;
        }
        return planOps;
    }

    public static GenericSQLContextType getSQLContextType(String dbType) {
        SQLUIService service = SQLToolsUIFacade.getSQLUIService(null, dbType);
        if (service != null) {
            return service.getSQLContextType();
        }
        return null;
    }

    public static SQLUIService getSQLUIService(DatabaseIdentifier databaseIdentifier, String dbType) {
        SQLDevToolsUIConfiguration f = SQLToolsUIFacade.getConfiguration(dbType, databaseIdentifier);
        return f.getSQLUIService();
    }

    public static Collection getSQLContextTypes() {
        Collection c = SQLToolsUIFacade.getRegistry().getConfigurations();
        int size = c.size();
        SQLDevToolsUIConfiguration[] fs = (SQLDevToolsUIConfiguration[])c.toArray(new SQLDevToolsConfiguration[size]);
        ArrayList<GenericSQLContextType> ctxTypes = new ArrayList<GenericSQLContextType>();
        int i = 0;
        while (i < size) {
            ctxTypes.add(fs[i].getSQLUIService().getSQLContextType());
            ++i;
        }
        return ctxTypes;
    }

    public static boolean showAction(String dbType, String actionId) {
        SQLDevToolsUIConfiguration f = null;
        f = SQLToolsUIFacade.getConfigurationByDBDefName(dbType);
        if (f != null) {
            return f.getActionService().supportsAction(actionId);
        }
        return false;
    }
}

