/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.UnusedSuppressWarningsFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class UnusedSuppressWarningsCleanUp
extends AbstractMultiFix {
    private StringLiteral fLiteral;
    private CompilationUnit fSavedCompilationUnit = null;

    public UnusedSuppressWarningsCleanUp(Map<String, String> options) {
        super(options);
    }

    public UnusedSuppressWarningsCleanUp() {
    }

    public void setLiteral(StringLiteral literal) {
        this.fLiteral = literal;
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, requireAST, false, requireAST, requiredOptions);
    }

    private boolean requireAST() {
        return this.isEnabled("cleanup.remove_unnecessary_suppress_warnings");
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null || !this.isEnabled("cleanup.remove_unnecessary_suppress_warnings")) {
            return null;
        }
        IProposableFix coreFix = this.fLiteral != null ? UnusedSuppressWarningsFixCore.createAllFix(this.fSavedCompilationUnit == null ? compilationUnit : this.fSavedCompilationUnit, this.fLiteral) : UnusedSuppressWarningsFixCore.createAllFix(compilationUnit);
        return coreFix;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null || !this.isEnabled("cleanup.remove_unnecessary_suppress_warnings")) {
            return null;
        }
        IProposableFix coreFix = UnusedSuppressWarningsFixCore.createAllFix(compilationUnit, this.fLiteral);
        return coreFix;
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unnecessary_suppress_warnings")) {
            result.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
            result.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
            result.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
            result.put("org.eclipse.jdt.core.compiler.problem.APILeak", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.autoboxing", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nullReference", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", "warning");
            result.put("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.annotatedTypeArgumentToUnannotated", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.discouragedReference", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", this.getPreview());
            result.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.deadCode", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLambdaParameter", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.incompatibleOwningContract", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "warning");
            String suppressRawWhenUnchecked = System.getProperty("suppressRawWhenUnchecked");
            if (suppressRawWhenUnchecked != null && "true".equalsIgnoreCase(suppressRawWhenUnchecked)) {
                result.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
            }
            result.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.remove_unnecessary_suppress_warnings")) {
            return new String[]{MultiFixMessages.UnusedSuppressWarningsCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.remove_unnecessary_suppress_warnings")) {
            return "int x = 3;\nSystem.out.println(x);\n\n";
        }
        return "@SuppressWarnings(\"unused\")\nint x = 3;\nSystem.out.println(x);\n";
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() == 536871547) {
            return this.isEnabled("cleanup.remove_unnecessary_suppress_warnings");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        try {
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            if (!cu.isStructureKnown()) {
                return 0;
            }
        }
        catch (JavaModelException e) {
            return 0;
        }
        this.fSavedCompilationUnit = compilationUnit;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unnecessary_suppress_warnings")) {
            result += this.getNumberOfProblems(problems, compilationUnit);
        }
        return result;
    }

    private int getNumberOfProblems(IProblem[] problems, CompilationUnit compilationUnit) {
        int result = 0;
        if (this.fLiteral == null) {
            return 1;
        }
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            StringLiteral literal;
            ASTNode node;
            IProblem problem = iProblemArray[n2];
            ProblemLocation location = new ProblemLocation(problem);
            if (location.getProblemId() == 536871547 && (node = location.getCoveringNode(compilationUnit)) instanceof StringLiteral && (literal = (StringLiteral)node).getLiteralValue().equals(this.fLiteral.getLiteralValue())) {
                ++result;
            }
            ++n2;
        }
        return result;
    }
}

