/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

public class GenericOrmJoinColumn
extends AbstractOrmBaseColumn<JoinColumn.ParentAdapter, XmlJoinColumn>
implements OrmSpecifiedJoinColumn {
    protected XmlJoinColumn xmlColumn;
    protected String specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName();
    protected String defaultReferencedColumnName;

    public GenericOrmJoinColumn(JoinColumn.ParentAdapter parentAdapter) {
        this(parentAdapter, null);
    }

    public GenericOrmJoinColumn(JoinColumn.ParentAdapter parentAdapter, XmlJoinColumn xmlColumn) {
        super(parentAdapter, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public XmlJoinColumn getXmlColumn() {
        return this.xmlColumn;
    }

    @Override
    protected void setXmlColumn(XmlJoinColumn xmlColumn) {
        this.xmlColumn = xmlColumn;
    }

    @Override
    protected XmlJoinColumn buildXmlColumn() {
        throw new IllegalStateException("XML join column is missing");
    }

    @Override
    protected void removeXmlColumn() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        this.setSpecifiedReferencedColumnName_(name);
        this.getXmlColumn().setReferencedColumnName(name);
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName() {
        XmlJoinColumn joinColumn = this.getXmlColumn();
        return joinColumn == null ? null : joinColumn.getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName((JoinColumn.ParentAdapter)this.parentAdapter);
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((JoinColumn.ParentAdapter)this.parentAdapter).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public void initializeFrom(OrmSpecifiedJoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public void initializeFrom(VirtualJoinColumn virtualColumn) {
        super.initializeFrom(virtualColumn);
        this.setSpecifiedReferencedColumnName(virtualColumn.getReferencedColumnName());
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        return this.getValidationTextRange(this.xmlColumn.getReferencedColumnNameTextRange());
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos)) {
            return this.getCandidateReferencedColumnNames();
        }
        return null;
    }

    protected boolean referencedColumnNameTouches(int pos) {
        XmlJoinColumn joinColumn = this.getXmlColumn();
        return joinColumn != null && joinColumn.referencedColumnNameTouches(pos);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((JoinColumn.ParentAdapter)this.parentAdapter).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }
}

