/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import java.util.Collections;
import org.eclipse.buildship.core.internal.util.gradle.JavaVersionUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.gradle.tooling.model.eclipse.EclipseJavaSourceSettings;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class JavaSourceSettingsUpdater {
    public static void update(IJavaProject project, EclipseProject modelProject, IProgressMonitor monitor) throws CoreException {
        EclipseJavaSourceSettings sourceSettings = modelProject.getJavaSourceSettings();
        String sourceVersion = JavaVersionUtil.adaptVersionToEclipseNamingConversions(sourceSettings.getSourceLanguageLevel());
        String targetVersion = JavaVersionUtil.adaptVersionToEclipseNamingConversions(sourceSettings.getTargetBytecodeVersion());
        boolean compilerOptionChanged = false;
        compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.compliance", sourceVersion);
        compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.source", sourceVersion);
        if ((compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetVersion)) && JavaSourceSettingsUpdater.isProjectAutoBuildingEnabled()) {
            JavaSourceSettingsUpdater.scheduleJdtBuild(project.getProject());
        }
    }

    private static boolean updateJavaProjectOptionIfNeeded(IJavaProject project, String optionKey, String newValue) {
        String currentValue = project.getOption(optionKey, true);
        if (currentValue == null || !currentValue.equals(newValue)) {
            project.setOption(optionKey, newValue);
            return true;
        }
        return false;
    }

    private static boolean isProjectAutoBuildingEnabled() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private static void scheduleJdtBuild(final IProject project) {
        WorkspaceJob build = new WorkspaceJob(String.format("Building project %s after Java compiler settings changed", project.getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    if (project.isAccessible()) {
                        project.build(6, "org.eclipse.jdt.core.javabuilder", Collections.emptyMap(), monitor);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
            }
        };
        build.schedule();
    }

    private JavaSourceSettingsUpdater() {
    }
}

