<p align="center"><a href="https://stylus-lang.com" target="_blank" rel="noopener noreferrer"><img width="150" src="https://raw.githubusercontent.com/stylus/stylus/dev/graphics/Logos/stylus.png" alt="Stylus logo"></a></p>

[![Build Status](https://github.com/stylus/stylus/actions/workflows/ci.yml/badge.svg?branch=dev)](https://github.com/stylus/stylus/actions?query=branch%3Adev)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-brightgreen.svg)](https://github.com/stylus/stylus/pulse)
[![npm version](https://img.shields.io/npm/v/stylus?color=brightgreen)](https://www.npmjs.com/package/stylus)
[![npm](https://img.shields.io/npm/dm/stylus.svg)](https://www.npmjs.com/package/stylus)
[![Join the community on github discussion](https://img.shields.io/badge/Join%20the%20community-on%20discussions-%23754ffb?logo=googlechat&logoColor=white)](https://github.com/stylus/stylus/discussions)

Stylus is a revolutionary new language, providing an efficient, dynamic, and expressive way to generate CSS. Supporting both an indented syntax and regular CSS style.

## Sponsors

You can sponsor stylus ongoing development via [opencollective](https://opencollective.com/stylus/) or [paypal](https://www.paypal.com/paypalme/iChenLei/) !

<table>
  <tbody>
    <tr>
      <td width="50%" align="center">
        <a href="https://automattic.com/">
          <img alt="automattic" src="https://user-images.githubusercontent.com/14012511/175755798-40ca295f-a0cf-45a6-b24a-303496552499.svg" />
        </a>
      </td>
      <td width="50%" align="center">
        <a href="https://www.mojotech.com/">
          <img alt="mojotech" src="https://user-images.githubusercontent.com/14012511/175755697-0a090b42-89f8-4651-9506-b6aefac57c66.png" />
        </a>
      </td>
    </tr>
    <tr>
      <td width="50%" align="center">
         <p style="font-size: 30px">Your Logo</p>
      </td>
      <td width="50%" align="center">
        <a href="http://opencollective.com/stylus/">
          <img alt="opencollective stylus" src="https://opencollective.com/webpack/donate/button@2x.png?color=blue" />
        </a>
        or
        <a href="https://www.paypal.com/paypalme/iChenLei/">
          <img alt="Paypal stylus" src="https://www.paypalobjects.com/digitalassets/c/website/marketing/apac/C2/logos-buttons/optimize/Full_Online_Tray_RGB.png" />
        </a>
      </td>
    </tr>
  </tbody>
</table>

### Backers
[![Backers](https://opencollective.com/stylus/individuals.svg)](https://opencollective.com/stylus/)

## Installation

```bash
$ npm install stylus -g
```

## Basic Usage
Watch and compile a stylus file from command line with 
```bash
stylus -w style.styl -o style.css
```
You can also [try all stylus features on stylus-lang.com](http://stylus-lang.com/try.html), build something with stylus on [codepen](http://codepen.io) or [RunKit](https://npm.runkit.com/stylus)

### Community modules

  - https://github.com/stylus/stylus/wiki

### Stylus cheatsheet

  - [Stylus cheatsheet](https://devhints.io/stylus), very useful stylus syntax code snippet for you

### Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](Code_of_Conduct.md). By participating in this project you agree to abide by its terms.

### Contribution

Please read our [Contribution Guide](Contributing.md) before making any pull requests to the project. Included are directions for opening issues, workflows, and coding standards.

Thank you to all the people who already contributed to Stylus!

<a href="https://github.com/stylus/stylus/graphs/contributors"><img src="https://opencollective.com/stylus/contributors.svg?width=890" /></a>

## License 

[MIT](https://github.com/stylus/stylus/blob/dev/LICENSE)

Copyright (c) 2010-present [TJ](https://github.com/tj) and [Stylus maintainers](https://github.com/orgs/stylus/people)
