/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.xsi.settings.XSISchemaLocationSplit;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.LSPFormattingOptions;
import org.eclipse.lsp4j.FormattingOptions;

public class XMLFormattingOptions
extends LSPFormattingOptions {
    public static final String DEFAULT_QUOTATION = "\"";
    public static final int DEFAULT_PRESERVER_NEW_LINES = 2;
    public static final int DEFAULT_TAB_SIZE = 2;
    public static final EnforceQuoteStyle DEFAULT_ENFORCE_QUOTE_STYLE = EnforceQuoteStyle.ignore;
    public static final boolean DEFAULT_PRESERVE_ATTR_LINE_BREAKS = true;
    public static final boolean DEFAULT_TRIM_TRAILING_SPACES = false;
    public static final int DEFAULT_SPLIT_ATTRIBUTES_INDENT_SIZE = 2;
    public static final String DEFAULT_XSI_SCHEMA_LOCATION_SPLIT = XSISchemaLocationSplit.onPair.name();
    public static final boolean DEFAULT_CLOSING_BRACKET_NEW_LINE = false;
    public static final List<String> DEFAULT_PRESERVE_SPACE = Arrays.asList("xsl:text", "xsl:comment", "xsl:processing-instruction", "literallayout", "programlisting", "screen", "synopsis", "pre", "xd:pre");
    private boolean legacy;
    private int maxLineWidth;
    private String splitAttributes;
    private boolean joinCDATALines;
    private boolean formatComments;
    private boolean joinCommentLines;
    private boolean enabled;
    private boolean spaceBeforeEmptyCloseTag;
    private boolean joinContentLines;
    private int preservedNewlines;
    private String enforceQuoteStyle;
    private boolean preserveAttributeLineBreaks;
    private boolean preserveEmptyContent;
    private int splitAttributesIndentSize;
    private boolean closingBracketNewLine;
    private String emptyElements;
    private List<String> preserveSpace;
    private boolean grammarAwareFormatting;
    private String xsiSchemaLocationSplit;

    public XMLFormattingOptions() {
        this(false);
    }

    public XMLFormattingOptions(boolean initializeDefaults) {
        if (initializeDefaults) {
            this.initializeDefaultSettings();
        }
    }

    private void initializeDefaultSettings() {
        super.setTabSize(2);
        super.setInsertSpaces(true);
        super.setTrimFinalNewlines(true);
        this.setSplitAttributes(SplitAttributes.preserve);
        this.setJoinCDATALines(false);
        this.setFormatComments(true);
        this.setJoinCommentLines(false);
        this.setJoinContentLines(false);
        this.setEnabled(true);
        this.setLegacy(false);
        this.setMaxLineWidth(100);
        this.setSpaceBeforeEmptyCloseTag(true);
        this.setPreserveEmptyContent(false);
        this.setPreservedNewlines(2);
        this.setEmptyElement(EmptyElements.ignore);
        this.setSplitAttributesIndentSize(2);
        this.setXsiSchemaLocationSplit(DEFAULT_XSI_SCHEMA_LOCATION_SPLIT);
        this.setClosingBracketNewLine(false);
        this.setPreserveAttributeLineBreaks(true);
        this.setPreserveSpace(DEFAULT_PRESERVE_SPACE);
        this.setGrammarAwareFormatting(true);
    }

    public XMLFormattingOptions(int tabSize, boolean insertSpaces, boolean initializeDefaultSettings) {
        if (initializeDefaultSettings) {
            this.initializeDefaultSettings();
        }
        super.setTabSize(tabSize);
        super.setInsertSpaces(insertSpaces);
    }

    public XMLFormattingOptions(int tabSize, boolean insertSpaces) {
        this(tabSize, insertSpaces, true);
    }

    public XMLFormattingOptions(FormattingOptions options, boolean initializeDefaultSettings) {
        if (initializeDefaultSettings) {
            this.initializeDefaultSettings();
        }
        this.merge(options);
    }

    public XMLFormattingOptions(FormattingOptions options) {
        this(options, true);
    }

    public SplitAttributes getSplitAttributes() {
        String value = this.splitAttributes;
        if (value != null) {
            try {
                return SplitAttributes.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SplitAttributes.preserve;
    }

    public void setSplitAttributes(SplitAttributes splitAttributes) {
        this.splitAttributes = splitAttributes.name();
    }

    public boolean isJoinCDATALines() {
        return this.joinCDATALines;
    }

    public void setJoinCDATALines(boolean joinCDATALines) {
        this.joinCDATALines = joinCDATALines;
    }

    public boolean isFormatComments() {
        return this.formatComments;
    }

    public void setFormatComments(boolean formatComments) {
        this.formatComments = formatComments;
    }

    public boolean isJoinCommentLines() {
        return this.joinCommentLines;
    }

    public void setJoinCommentLines(boolean joinCommentLines) {
        this.joinCommentLines = joinCommentLines;
    }

    public boolean isJoinContentLines() {
        return this.joinContentLines;
    }

    public void setJoinContentLines(boolean joinContentLines) {
        this.joinContentLines = joinContentLines;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public void setMaxLineWidth(int maxLineWidth) {
        this.maxLineWidth = maxLineWidth;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth < 0 ? 0 : this.maxLineWidth;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSpaceBeforeEmptyCloseTag(boolean spaceBeforeEmptyCloseTag) {
        this.spaceBeforeEmptyCloseTag = spaceBeforeEmptyCloseTag;
    }

    public boolean isSpaceBeforeEmptyCloseTag() {
        return this.spaceBeforeEmptyCloseTag;
    }

    public void setPreserveEmptyContent(boolean preserveEmptyContent) {
        this.preserveEmptyContent = preserveEmptyContent;
    }

    public boolean isPreserveEmptyContent() {
        return this.preserveEmptyContent;
    }

    public void setPreservedNewlines(int preservedNewlines) {
        this.preservedNewlines = preservedNewlines;
    }

    public int getPreservedNewlines() {
        return this.preservedNewlines;
    }

    public void setEmptyElement(EmptyElements emptyElement) {
        this.emptyElements = emptyElement.name();
    }

    public EmptyElements getEmptyElements() {
        String value = this.emptyElements;
        if (value != null) {
            try {
                return EmptyElements.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return EmptyElements.ignore;
    }

    public void setEnforceQuoteStyle(EnforceQuoteStyle enforce) {
        this.enforceQuoteStyle = enforce.name();
    }

    public EnforceQuoteStyle getEnforceQuoteStyle() {
        String value = this.enforceQuoteStyle;
        EnforceQuoteStyle enforceStyle = null;
        try {
            enforceStyle = value == null ? null : EnforceQuoteStyle.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_ENFORCE_QUOTE_STYLE;
        }
        return enforceStyle == null ? DEFAULT_ENFORCE_QUOTE_STYLE : enforceStyle;
    }

    public void setPreserveAttributeLineBreaks(boolean preserveAttributeLineBreaks) {
        this.preserveAttributeLineBreaks = preserveAttributeLineBreaks;
    }

    public boolean isPreserveAttributeLineBreaks() {
        if (this.getSplitAttributes() != SplitAttributes.preserve) {
            return false;
        }
        return this.preserveAttributeLineBreaks;
    }

    public void setSplitAttributesIndentSize(int splitAttributesIndentSize) {
        this.splitAttributesIndentSize = splitAttributesIndentSize;
    }

    public int getSplitAttributesIndentSize() {
        int splitAttributesIndentSize = this.splitAttributesIndentSize;
        return splitAttributesIndentSize < 0 ? 0 : splitAttributesIndentSize;
    }

    public boolean getClosingBracketNewLine() {
        return this.closingBracketNewLine;
    }

    public void setClosingBracketNewLine(boolean closingBracketNewLine) {
        this.closingBracketNewLine = closingBracketNewLine;
    }

    public void setPreserveSpace(List<String> preserveSpace) {
        this.preserveSpace = preserveSpace;
    }

    public List<String> getPreserveSpace() {
        return this.preserveSpace;
    }

    public boolean isGrammarAwareFormatting() {
        return this.grammarAwareFormatting;
    }

    public void setGrammarAwareFormatting(boolean grammarAwareFormatting) {
        this.grammarAwareFormatting = grammarAwareFormatting;
    }

    public String getXsiSchemaLocationSplit() {
        return this.xsiSchemaLocationSplit;
    }

    public void setXsiSchemaLocationSplit(String xsiSchemaLocationSplit) {
        this.xsiSchemaLocationSplit = xsiSchemaLocationSplit;
    }

    public XMLFormattingOptions merge(XMLFormattingOptions formattingOptions) {
        this.setTabSize(formattingOptions.getTabSize());
        this.setInsertFinalNewline(formattingOptions.isInsertFinalNewline());
        this.setInsertSpaces(formattingOptions.isInsertSpaces());
        this.setTrimFinalNewlines(formattingOptions.isTrimFinalNewlines());
        this.setTrimTrailingWhitespace(formattingOptions.isTrimTrailingWhitespace());
        this.setLegacy(formattingOptions.isLegacy());
        this.setMaxLineWidth(formattingOptions.getMaxLineWidth());
        this.setSplitAttributes(formattingOptions.getSplitAttributes());
        this.setJoinCDATALines(formattingOptions.isJoinCDATALines());
        this.setFormatComments(formattingOptions.isFormatComments());
        this.setJoinCommentLines(formattingOptions.isJoinCommentLines());
        this.setEnabled(formattingOptions.isEnabled());
        this.setSpaceBeforeEmptyCloseTag(formattingOptions.isSpaceBeforeEmptyCloseTag());
        this.setJoinContentLines(formattingOptions.isJoinContentLines());
        this.setPreservedNewlines(formattingOptions.getPreservedNewlines());
        this.setEnforceQuoteStyle(formattingOptions.getEnforceQuoteStyle());
        this.setPreserveAttributeLineBreaks(formattingOptions.isPreserveAttributeLineBreaks());
        this.setPreserveEmptyContent(formattingOptions.isPreserveEmptyContent());
        this.setSplitAttributesIndentSize(formattingOptions.getSplitAttributesIndentSize());
        this.setClosingBracketNewLine(formattingOptions.getClosingBracketNewLine());
        this.setEmptyElement(formattingOptions.getEmptyElements());
        this.setXsiSchemaLocationSplit(formattingOptions.getXsiSchemaLocationSplit());
        this.setPreserveSpace(formattingOptions.getPreserveSpace());
        this.setGrammarAwareFormatting(formattingOptions.isGrammarAwareFormatting());
        this.setMaxLineWidth(formattingOptions.getMaxLineWidth());
        return this;
    }

    public XMLFormattingOptions merge(FormattingOptions formattingOptions) {
        this.setTabSize(formattingOptions.getTabSize());
        this.setInsertFinalNewline(formattingOptions.isInsertFinalNewline());
        this.setInsertSpaces(formattingOptions.isInsertSpaces());
        this.setTrimFinalNewlines(formattingOptions.isTrimFinalNewlines());
        this.setTrimTrailingWhitespace(formattingOptions.isTrimTrailingWhitespace());
        return this;
    }

    public FormatElementCategory getFormatElementCategory(DOMElement element) {
        if (this.preserveSpace != null) {
            for (String elementName : this.preserveSpace) {
                if (!elementName.equals(element.getTagName())) continue;
                return FormatElementCategory.PreserveSpace;
            }
        }
        return null;
    }

    public static enum EmptyElements {
        expand,
        collapse,
        ignore;

    }

    public static enum SplitAttributes {
        preserve,
        splitNewLine,
        alignWithFirstAttr;

    }
}

